/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spring.starter.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.selector.SelectMessageQueueByHash;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.core.AbstractMessageSendingTemplate;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;

public class RocketMQTemplate
extends AbstractMessageSendingTemplate<String>
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(RocketMQTemplate.class);
    private DefaultMQProducer producer;
    private ObjectMapper objectMapper = new ObjectMapper();
    private String charset = "UTF-8";
    private MessageQueueSelector messageQueueSelector = new SelectMessageQueueByHash();

    public SendResult syncSend(String destination, org.springframework.messaging.Message<?> message) {
        return this.syncSend(destination, message, (long)this.producer.getSendMsgTimeout());
    }

    public SendResult syncSend(String destination, org.springframework.messaging.Message<?> message, long timeout) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            log.info("syncSend failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        try {
            long now = System.currentTimeMillis();
            Message rocketMsg = this.convertToRocketMsg(destination, message);
            SendResult sendResult = this.producer.send(rocketMsg, timeout);
            long costTime = System.currentTimeMillis() - now;
            log.debug("send message cost: {} ms, msgId:{}", (Object)costTime, (Object)sendResult.getMsgId());
            return sendResult;
        }
        catch (Exception e) {
            log.info("syncSend failed. destination:{}, message:{} ", (Object)destination, message);
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public SendResult syncSend(String destination, Object payload) {
        return this.syncSend(destination, payload, (long)this.producer.getSendMsgTimeout());
    }

    public SendResult syncSend(String destination, Object payload, long timeout) {
        org.springframework.messaging.Message<?> message = this.doConvert(payload, null, null);
        return this.syncSend(destination, message, timeout);
    }

    public SendResult syncSendOrderly(String destination, org.springframework.messaging.Message<?> message, String hashKey) {
        return this.syncSendOrderly(destination, message, hashKey, (long)this.producer.getSendMsgTimeout());
    }

    public SendResult syncSendOrderly(String destination, org.springframework.messaging.Message<?> message, String hashKey, long timeout) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            log.info("syncSendOrderly failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        try {
            long now = System.currentTimeMillis();
            Message rocketMsg = this.convertToRocketMsg(destination, message);
            SendResult sendResult = this.producer.send(rocketMsg, this.messageQueueSelector, (Object)hashKey, timeout);
            long costTime = System.currentTimeMillis() - now;
            log.debug("send message cost: {} ms, msgId:{}", (Object)costTime, (Object)sendResult.getMsgId());
            return sendResult;
        }
        catch (Exception e) {
            log.info("syncSendOrderly failed. destination:{}, message:{} ", (Object)destination, message);
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public SendResult syncSendOrderly(String destination, Object payload, String hashKey) {
        return this.syncSendOrderly(destination, payload, hashKey, (long)this.producer.getSendMsgTimeout());
    }

    public SendResult syncSendOrderly(String destination, Object payload, String hashKey, long timeout) {
        org.springframework.messaging.Message<?> message = this.doConvert(payload, null, null);
        return this.syncSendOrderly(destination, message, hashKey, (long)this.producer.getSendMsgTimeout());
    }

    public void asyncSend(String destination, org.springframework.messaging.Message<?> message, SendCallback sendCallback, long timeout) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            log.info("asyncSend failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        try {
            Message rocketMsg = this.convertToRocketMsg(destination, message);
            this.producer.send(rocketMsg, sendCallback, timeout);
        }
        catch (Exception e) {
            log.info("asyncSend failed. destination:{}, message:{} ", (Object)destination, message);
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public void asyncSend(String destination, org.springframework.messaging.Message<?> message, SendCallback sendCallback) {
        this.asyncSend(destination, message, sendCallback, (long)this.producer.getSendMsgTimeout());
    }

    public void asyncSend(String destination, Object payload, SendCallback sendCallback, long timeout) {
        org.springframework.messaging.Message<?> message = this.doConvert(payload, null, null);
        this.asyncSend(destination, message, sendCallback, timeout);
    }

    public void asyncSend(String destination, Object payload, SendCallback sendCallback) {
        this.asyncSend(destination, payload, sendCallback, (long)this.producer.getSendMsgTimeout());
    }

    public void asyncSendOrderly(String destination, org.springframework.messaging.Message<?> message, String hashKey, SendCallback sendCallback, long timeout) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            log.info("asyncSendOrderly failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        try {
            Message rocketMsg = this.convertToRocketMsg(destination, message);
            this.producer.send(rocketMsg, this.messageQueueSelector, (Object)hashKey, sendCallback, timeout);
        }
        catch (Exception e) {
            log.info("asyncSendOrderly failed. destination:{}, message:{} ", (Object)destination, message);
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public void asyncSendOrderly(String destination, org.springframework.messaging.Message<?> message, String hashKey, SendCallback sendCallback) {
        this.asyncSendOrderly(destination, message, hashKey, sendCallback, (long)this.producer.getSendMsgTimeout());
    }

    public void asyncSendOrderly(String destination, Object payload, String hashKey, SendCallback sendCallback) {
        this.asyncSendOrderly(destination, payload, hashKey, sendCallback, (long)this.producer.getSendMsgTimeout());
    }

    public void asyncSendOrderly(String destination, Object payload, String hashKey, SendCallback sendCallback, long timeout) {
        org.springframework.messaging.Message<?> message = this.doConvert(payload, null, null);
        this.asyncSendOrderly(destination, message, hashKey, sendCallback, timeout);
    }

    public void sendOneWay(String destination, org.springframework.messaging.Message<?> message) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            log.info("sendOneWay failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        try {
            Message rocketMsg = this.convertToRocketMsg(destination, message);
            this.producer.sendOneway(rocketMsg);
        }
        catch (Exception e) {
            log.info("sendOneWay failed. destination:{}, message:{} ", (Object)destination, message);
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public void sendOneWay(String destination, Object payload) {
        org.springframework.messaging.Message<?> message = this.doConvert(payload, null, null);
        this.sendOneWay(destination, message);
    }

    public void sendOneWayOrderly(String destination, org.springframework.messaging.Message<?> message, String hashKey) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            log.info("sendOneWayOrderly failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        try {
            Message rocketMsg = this.convertToRocketMsg(destination, message);
            this.producer.sendOneway(rocketMsg, this.messageQueueSelector, (Object)hashKey);
        }
        catch (Exception e) {
            log.info("sendOneWayOrderly failed. destination:{}, message:{}", (Object)destination, message);
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public void sendOneWayOrderly(String destination, Object payload, String hashKey) {
        org.springframework.messaging.Message<?> message = this.doConvert(payload, null, null);
        this.sendOneWayOrderly(destination, message, hashKey);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.producer, (String)"Property 'producer' is required");
        if (!StringUtils.isEmpty((Object)this.producer.getProducerGroup())) {
            this.producer.start();
        }
    }

    protected void doSend(String destination, org.springframework.messaging.Message<?> message) {
        SendResult sendResult = this.syncSend(destination, message);
        log.debug("send message to `{}` finished. result:{}", (Object)destination, (Object)sendResult);
    }

    private Message convertToRocketMsg(String destination, org.springframework.messaging.Message<?> message) {
        byte[] payloads;
        Object payloadObj = message.getPayload();
        if (payloadObj instanceof String) {
            payloads = ((String)payloadObj).getBytes(Charset.forName(this.charset));
        } else {
            try {
                String jsonObj = this.objectMapper.writeValueAsString(payloadObj);
                payloads = jsonObj.getBytes(Charset.forName(this.charset));
            }
            catch (Exception e) {
                throw new RuntimeException("convert to RocketMQ message failed.", e);
            }
        }
        String[] tempArr = destination.split(":", 2);
        String topic = tempArr[0];
        String tags = "";
        if (tempArr.length > 1) {
            tags = tempArr[1];
        }
        Message rocketMsg = new Message(topic, tags, payloads);
        MessageHeaders headers = message.getHeaders();
        if (Objects.nonNull(headers) && !headers.isEmpty()) {
            Object keys = headers.get((Object)"KEYS");
            if (!StringUtils.isEmpty((Object)keys)) {
                rocketMsg.setKeys(keys.toString());
            }
            Object flagObj = headers.getOrDefault((Object)"FLAG", (Object)"0");
            int flag = 0;
            try {
                flag = Integer.parseInt(flagObj.toString());
            }
            catch (NumberFormatException e) {
                log.info("flag must be integer, flagObj:{}", flagObj);
            }
            rocketMsg.setFlag(flag);
            Object waitStoreMsgOkObj = headers.getOrDefault((Object)"WAIT_STORE_MSG_OK", (Object)"true");
            boolean waitStoreMsgOK = Boolean.TRUE.equals(waitStoreMsgOkObj);
            rocketMsg.setWaitStoreMsgOK(waitStoreMsgOK);
            headers.entrySet().stream().filter(entry -> !Objects.equals(entry.getKey(), "KEYS") && !Objects.equals(entry.getKey(), "FLAG") && !Objects.equals(entry.getKey(), "WAIT_STORE_MSG_OK")).forEach(entry -> rocketMsg.putUserProperty("USERS_" + (String)entry.getKey(), String.valueOf(entry.getValue())));
        }
        return rocketMsg;
    }

    protected org.springframework.messaging.Message<?> doConvert(Object payload, Map<String, Object> headers, MessagePostProcessor postProcessor) {
        String content;
        if (payload instanceof String) {
            content = (String)payload;
        } else {
            try {
                content = this.objectMapper.writeValueAsString(payload);
            }
            catch (JsonProcessingException e) {
                log.info("convert payload to String failed. payload:{}", payload);
                throw new RuntimeException("convert to payload to String failed.", e);
            }
        }
        MessageBuilder builder = MessageBuilder.withPayload((Object)content);
        if (headers != null) {
            builder.copyHeaders(headers);
        }
        builder.setHeaderIfAbsent("contentType", (Object)MimeTypeUtils.TEXT_PLAIN);
        org.springframework.messaging.Message message = builder.build();
        if (postProcessor != null) {
            message = postProcessor.postProcessMessage(message);
        }
        return message;
    }

    public void destroy() {
        if (Objects.nonNull(this.producer)) {
            this.producer.shutdown();
        }
    }

    public DefaultMQProducer getProducer() {
        return this.producer;
    }

    public void setProducer(DefaultMQProducer producer) {
        this.producer = producer;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public MessageQueueSelector getMessageQueueSelector() {
        return this.messageQueueSelector;
    }

    public void setMessageQueueSelector(MessageQueueSelector messageQueueSelector) {
        this.messageQueueSelector = messageQueueSelector;
    }
}

