/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pac.sdk.cp;

import com.taobao.pac.sdk.cp.Authenticate;
import com.taobao.pac.sdk.cp.ErrorCode;
import com.taobao.pac.sdk.cp.PacLogger;
import com.taobao.pac.sdk.cp.RequestDataObject;
import com.taobao.pac.sdk.cp.ResponseDataObject;
import com.taobao.pac.sdk.cp.SendResult;
import com.taobao.pac.sdk.cp.SignStrategy;
import com.taobao.pac.sdk.cp.authenticate.CNMemberAuthenticate;
import com.taobao.pac.sdk.cp.authenticate.DeviceAuthenticate;
import com.taobao.pac.sdk.cp.sar.ServiceFactory;
import com.taobao.pac.sdk.cp.services.CodeService;
import com.taobao.pac.sdk.cp.services.HttpService;
import com.taobao.pac.sdk.cp.services.MappingService;
import com.taobao.pac.sdk.cp.services.dto.HttpResult;
import com.taobao.pac.sdk.cp.util.Sign;
import com.taobao.pac.sdk.cp.util.ThrowableUtil;
import java.util.HashMap;
import java.util.Map;

public class LinkClient {
    private int sockTimeout = 2000;
    private int connectTimeout = 3000;
    private String charset = "utf-8";
    private String url = "https://shidclink.cainiao.com";
    private SignStrategy signStrategy = SignStrategy.md5;
    private String appkey;
    private String secretKey = "123456";
    private PacLogger logger = PacLogger.instance;
    private CodeService codeService;
    private MappingService mappingService;
    private HttpService httpService;

    public LinkClient(String appkey, String secretKey) {
        this(appkey, secretKey, null);
    }

    public LinkClient(String appkey, String secretKey, String url) {
        this.appkey = appkey;
        this.secretKey = secretKey;
        if (url != null) {
            this.url = url;
        }
        this.init();
    }

    private synchronized void init() {
        ServiceFactory.init();
        if (this.appkey == null) {
            throw new IllegalArgumentException("\u5e94\u7528appkey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.secretKey == null) {
            throw new IllegalArgumentException("\u7269\u6d41\u5408\u4f5c\u4f19\u4f34\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7asecretKey");
        }
        if (this.url == null) {
            throw new IllegalArgumentException("domainName\u57df\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.mappingService = ServiceFactory.getService(MappingService.class);
        if (this.mappingService == null) {
            throw new IllegalArgumentException("Mapping\u63a5\u53e3\uff08mappingService\uff09\u4e0d\u80fd\u4e3anull");
        }
        this.codeService = ServiceFactory.getService(CodeService.class);
        if (this.codeService == null) {
            throw new IllegalArgumentException("\u7f16\u7801\u63a5\u53e3\uff08codeService\uff09\u4e0d\u80fd\u4e3anull");
        }
        this.httpService = ServiceFactory.getService(HttpService.class);
        if (this.httpService == null) {
            throw new IllegalArgumentException("\u7f16\u7801\u63a5\u53e3\uff08httpService\uff09\u4e0d\u80fd\u4e3anull");
        }
    }

    public <R extends ResponseDataObject> SendResult<R> invokeAsCainiaoMember(RequestDataObject<R> request2, CNMemberAuthenticate authenticate) throws IllegalArgumentException {
        return this.invoke(request2, authenticate);
    }

    public <R extends ResponseDataObject> SendResult<R> invokeAsDevice(RequestDataObject<R> request2, DeviceAuthenticate authenticate) throws IllegalArgumentException {
        return this.invoke(request2, authenticate);
    }

    private <R extends ResponseDataObject> SendResult<R> invoke(RequestDataObject<R> request2, Authenticate authenticate) throws IllegalArgumentException {
        String content;
        this.invalid(request2, authenticate);
        String api = request2.getApi();
        try {
            content = this.serializeRequest(api, request2);
        }
        catch (Exception e) {
            return new SendResult(ErrorCode.formatError, "request data object serialize exception:" + ThrowableUtil.getStackPrint(e));
        }
        String url = this.getUrl(authenticate.getUri());
        Map<String, String> params = this.getParams(api, content, request2, authenticate);
        HttpResult httpResult = this.httpService.request("post", url, this.getCharset(), this.getSockTimeout(), this.getConnectTimeout(), params, null, null);
        if (200 == httpResult.getStatus()) {
            try {
                return this.deserializeResult(api, httpResult.getContent());
            }
            catch (Exception e) {
                return new SendResult(ErrorCode.formatError, "response:" + httpResult.getContent() + ",exception:" + ThrowableUtil.getStackPrint(e));
            }
        }
        return new SendResult(ErrorCode.httpExcetpion, "http:" + httpResult.getStatus() + ",errorMsg:" + httpResult.getErrorMsg());
    }

    private String getUrl(String uri) {
        return this.url + uri;
    }

    private <R extends ResponseDataObject> void invalid(RequestDataObject<R> request2, Authenticate authenticate) throws IllegalArgumentException {
        if (request2 == null) {
            throw new IllegalArgumentException("request obj can't be null");
        }
        if (authenticate == null) {
            throw new IllegalArgumentException("authenticate obj can't be null");
        }
        authenticate.invalid();
    }

    private <R extends ResponseDataObject> String serializeRequest(String api, RequestDataObject<R> request2) throws Exception {
        return this.mappingService.serializeRequest(api, request2);
    }

    private SendResult deserializeResult(String api, String resultContent) throws Exception {
        return this.mappingService.deserializeResult(api, resultContent);
    }

    private Map<String, String> getParams(String api, String content, RequestDataObject request2, Authenticate authenticate) {
        HashMap<String, String> params = new HashMap<String, String>();
        String dataDigest = Sign.sign(this.codeService, this.getSecretKey(), this.getCharset(), this.getSignStrategy(), content, request2);
        params.put("msg_type", api);
        params.put("logistics_interface", content);
        params.put("data_digest", dataDigest);
        params.put("app_key", this.appkey);
        params.putAll(authenticate.getAuthenticateParams());
        return params;
    }

    public int getSockTimeout() {
        return this.sockTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getUrl() {
        return this.url;
    }

    public SignStrategy getSignStrategy() {
        return this.signStrategy;
    }

    public String getAppkey() {
        return this.appkey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }
}

