/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pac.sdk.cp;

import com.taobao.pac.sdk.cp.AuthReceiveListener;
import com.taobao.pac.sdk.cp.ErrorCode;
import com.taobao.pac.sdk.cp.FileUploadRequest;
import com.taobao.pac.sdk.cp.Logger;
import com.taobao.pac.sdk.cp.PacFileItem;
import com.taobao.pac.sdk.cp.PacLogger;
import com.taobao.pac.sdk.cp.QimenReceiveListener;
import com.taobao.pac.sdk.cp.ReceiveAuthParams;
import com.taobao.pac.sdk.cp.ReceiveListener;
import com.taobao.pac.sdk.cp.ReceiveSysParams;
import com.taobao.pac.sdk.cp.RemoteRequestResult;
import com.taobao.pac.sdk.cp.RequestDataObject;
import com.taobao.pac.sdk.cp.ResponseDataObject;
import com.taobao.pac.sdk.cp.SendAuthParams;
import com.taobao.pac.sdk.cp.SendResult;
import com.taobao.pac.sdk.cp.SendSysParams;
import com.taobao.pac.sdk.cp.SignStrategy;
import com.taobao.pac.sdk.cp.pull.BatchPullService;
import com.taobao.pac.sdk.cp.pull.ConfirmResponse;
import com.taobao.pac.sdk.cp.pull.PullResponse;
import com.taobao.pac.sdk.cp.sar.ServiceFactory;
import com.taobao.pac.sdk.cp.services.CodeService;
import com.taobao.pac.sdk.cp.services.Http2Service;
import com.taobao.pac.sdk.cp.services.HttpService;
import com.taobao.pac.sdk.cp.services.MappingService;
import com.taobao.pac.sdk.cp.services.dto.HttpProxy;
import com.taobao.pac.sdk.cp.services.dto.HttpResult;
import com.taobao.pac.sdk.cp.util.FileItemUtil;
import com.taobao.pac.sdk.cp.util.Sign;
import com.taobao.pac.sdk.cp.util.ThreadLocalCache;
import com.taobao.pac.sdk.cp.util.ThrowableUtil;
import com.taobao.pac.sdk.cp.util.UrlReplace;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class PacClient {
    private String pacUrl = "http://pac.partner.taobao.com/gateway/pac_message_receiver.do";
    private int sockTimeout = 2000;
    private int fileSockTimeout = 5000;
    private int connectTimeout = 3000;
    private String charset = "utf-8";
    private String secretKey = "123456";
    private SignStrategy signStrategy = SignStrategy.md5;
    private String appkey;
    private CodeService codeService;
    private MappingService mappingService;
    private HttpService httpService;
    private Http2Service http2Service;
    private Map<String, Object> outHttpParams = null;
    private HttpProxy httpProxy;
    private PacLogger logger = PacLogger.instance;
    private final Map<String, ReceiveListener> receiveListeners = new HashMap<String, ReceiveListener>();
    private final Map<String, QimenReceiveListener> qimenListeners = new HashMap<String, QimenReceiveListener>();
    private final Map<String, AuthReceiveListener> authReceiveListeners = new HashMap<String, AuthReceiveListener>();
    private BatchPullService batchPullService;
    private boolean monitorFlag = false;
    private int cpMonitorThreadNum = 2;
    private int cpMonitorThreadTime = 60000;

    public PacClient(String appkey, String secretKey) {
        this(appkey, secretKey, null);
    }

    public PacClient(String appkey, String secretKey, String pacUrl) {
        this.appkey = appkey;
        this.secretKey = secretKey;
        if (pacUrl != null) {
            this.pacUrl = pacUrl;
        }
        this.init();
    }

    private void init() {
        ServiceFactory.init();
        if (this.appkey == null) {
            throw new IllegalArgumentException("\u5e94\u7528ID\u7684appkey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.secretKey == null) {
            throw new IllegalArgumentException("\u7269\u6d41\u5408\u4f5c\u4f19\u4f34\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7asecretKey");
        }
        if (this.pacUrl == null) {
            throw new IllegalArgumentException("PAC\u7684\u8bbf\u95ee\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7apacUrl");
        }
        this.mappingService = ServiceFactory.getService(MappingService.class);
        if (this.mappingService == null) {
            throw new IllegalArgumentException("Mapping\u63a5\u53e3\uff08mappingService\uff09\u4e0d\u80fd\u4e3anull");
        }
        this.codeService = ServiceFactory.getService(CodeService.class);
        if (this.codeService == null) {
            throw new IllegalArgumentException("\u7f16\u7801\u63a5\u53e3\uff08codeService\uff09\u4e0d\u80fd\u4e3anull");
        }
        this.httpService = ServiceFactory.getService(HttpService.class);
        if (this.httpService == null) {
            throw new IllegalArgumentException("\u7f16\u7801\u63a5\u53e3\uff08httpService\uff09\u4e0d\u80fd\u4e3anull");
        }
        this.initBatchPullService(this.pacUrl);
    }

    public void registerReceiveListener(String api, ReceiveListener listener) {
        this.receiveListeners.put(api, listener);
    }

    public void registerQimenListener(String api, QimenReceiveListener listener) {
        this.qimenListeners.put(api, listener);
    }

    public void registerAuthReceiveListener(String api, AuthReceiveListener listener) {
        this.authReceiveListeners.put(api, listener);
    }

    public <R extends ResponseDataObject> R send(RequestDataObject<R> request2, SendSysParams sendSysParams) {
        String content;
        if (request2 == null) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u6570\u636e\u5bf9\u8c61request\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.validate(request2, sendSysParams);
        }
        catch (IllegalArgumentException e) {
            return this.getErrorResponseInstance(request2.getResponseClass(), ErrorCode.illegalParams, e.getMessage());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            content = this.serializeRequest(request2.getApi(), request2);
        }
        catch (Exception e) {
            SendResult result2 = new SendResult(ErrorCode.other, "request data object serialize exception." + ThrowableUtil.getStackPrint(e));
            return this.getErrorResponseInstance(request2.getResponseClass(), result2.getErrorCode(), result2.getErrorMsg());
        }
        Map<String, String> params = this.getParams(request2.getApi(), content, sendSysParams, request2);
        SendResult<R> result3 = this.sendByGateway(request2, params, sendSysParams.isQllFlag());
        if (!result3.isSuccess()) {
            R response2 = this.getErrorResponseInstance(request2.getResponseClass(), result3.getErrorCode(), result3.getErrorMsg());
            return response2;
        }
        return result3.getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends ResponseDataObject> R send(boolean enablePooling, RequestDataObject<R> request2, SendSysParams sendSysParams) {
        ThreadLocalCache.put(ThreadLocalCache.Key.ENABLE_POOLING, enablePooling);
        try {
            R r = this.send(request2, sendSysParams);
            return r;
        }
        finally {
            ThreadLocalCache.remove();
        }
    }

    public <R extends ResponseDataObject> R sendAuth(RequestDataObject<R> request2, SendAuthParams sendAuthParams) {
        String content;
        if (request2 == null) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u6570\u636e\u5bf9\u8c61request\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.validateAuth(request2, sendAuthParams);
        }
        catch (IllegalArgumentException e) {
            return this.getErrorResponseInstance(request2.getResponseClass(), ErrorCode.illegalParams, e.getMessage());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            content = this.serializeRequest(request2.getApi(), request2);
        }
        catch (Exception e) {
            SendResult result2 = new SendResult(ErrorCode.other, "request data object serialize exception." + ThrowableUtil.getStackPrint(e));
            return this.getErrorResponseInstance(request2.getResponseClass(), result2.getErrorCode(), result2.getErrorMsg());
        }
        Map<String, String> params = this.getAuthParams(request2.getApi(), content, sendAuthParams, request2);
        SendResult<R> result3 = this.sendByGateway(request2, params, sendAuthParams.isQllFlag());
        if (!result3.isSuccess()) {
            R response2 = this.getErrorResponseInstance(request2.getResponseClass(), result3.getErrorCode(), result3.getErrorMsg());
            return response2;
        }
        return result3.getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R extends ResponseDataObject> SendResult<R> sendByGateway(RequestDataObject<R> request2, Map<String, String> params, boolean qllFlag) {
        R response2;
        SendResult<R> sendResult = new SendResult<R>();
        String api = request2.getApi();
        if (this.logger.isInfoEnable()) {
            this.logger.info(api + "|sending content:" + params.get("logistics_interface"));
        }
        RemoteRequestResult remoteRequestResult = null;
        try {
            remoteRequestResult = new RemoteRequestResult();
            HttpResult httpResult = null;
            double startTime = System.currentTimeMillis();
            String url = this.getPacUrl();
            if (qllFlag) {
                if (!url.contains("?")) {
                    url = url + "?";
                }
                url = url + "&tb_eagleeyex_t=1";
            }
            if (200 == (httpResult = request2 instanceof FileUploadRequest ? this.httpService.request(url, this.getCharset(), this.getFileSockTimeout(), this.getConnectTimeout(), params, (FileUploadRequest)request2, this.outHttpParams, this.httpProxy) : this.httpService.request("post", url, this.getCharset(), this.getSockTimeout(), this.getConnectTimeout(), params, this.outHttpParams, this.httpProxy)).getStatus()) {
                remoteRequestResult.setSuccess(true);
                String resContent = httpResult.getContent();
                remoteRequestResult.setContent(resContent);
            } else {
                remoteRequestResult.setSuccess(false);
                remoteRequestResult.setErrorMsg("status:" + httpResult.getStatus() + ",body=" + httpResult.getErrorMsg());
            }
        }
        catch (Exception e) {
            SendResult<R> startTime = sendResult = new SendResult(ErrorCode.other, ThrowableUtil.getStackPrint(e));
            return startTime;
        }
        finally {
            if (this.logger.isLogEnable() && remoteRequestResult != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("\u76f8\u5173\u53c2\u6570\uff1acharset=").append(this.getCharset()).append(",secretKey=").append(this.getSecretKey()).append("\n");
                sb.append("\u8bf7\u6c42\u53c2\u6570\uff1a" + params).append("\n");
                sb.append("\u8fd4\u56de\u7ed3\u679c\uff1a").append("result=").append(remoteRequestResult.isSuccess()).append(",errorMsg=");
                sb.append(remoteRequestResult.getErrorMsg()).append(",").append("content=").append(remoteRequestResult.getContent());
                this.logger.error(sb.toString());
            }
        }
        if (!remoteRequestResult.isSuccess()) {
            sendResult = new SendResult(ErrorCode.other, remoteRequestResult.getErrorMsg());
            return sendResult;
        }
        try {
            response2 = this.deserializeResponse(api, remoteRequestResult.getContent());
        }
        catch (Exception e) {
            sendResult = new SendResult(ErrorCode.formatError, remoteRequestResult.getContent());
            return sendResult;
        }
        if (response2 == null) {
            sendResult = new SendResult(ErrorCode.formatError, "\u8fd4\u56de\u62a5\u6587\u8f6c\u5316\u4e3a\u5bf9\u8c61\u7ed3\u679c\u4e3anull\uff0c\u539f\u62a5\u6587\uff1a" + remoteRequestResult.getContent());
            return sendResult;
        }
        sendResult.setSuccess(true);
        sendResult.setResponse(response2);
        return sendResult;
    }

    private Map<String, String> getParams(String api, String content, SendSysParams sendSysParams, RequestDataObject request2) {
        HashMap<String, String> params = new HashMap<String, String>();
        String dataDigest = Sign.sign(this.codeService, this.getSecretKey(), this.getCharset(), this.getSignStrategy(), content, request2);
        params.put("msg_type", api);
        params.put("logistics_interface", content);
        params.put("data_digest", dataDigest);
        params.put("logistic_provider_id", sendSysParams.getFromCode());
        if (sendSysParams != null && sendSysParams.getToCode() != null && sendSysParams.getToCode().trim().length() > 0) {
            params.put("to_code", sendSysParams.getToCode());
        }
        return params;
    }

    private Map<String, String> getAuthParams(String api, String content, SendAuthParams sendAuthParams, RequestDataObject request2) {
        HashMap<String, String> params = new HashMap<String, String>();
        String dataDigest = Sign.sign(this.codeService, this.getSecretKey(), this.getCharset(), this.getSignStrategy(), content, request2);
        params.put("msg_type", api);
        params.put("logistics_interface", content);
        params.put("data_digest", dataDigest);
        params.put("token", sendAuthParams.getToken());
        if (sendAuthParams != null && sendAuthParams.getToCode() != null && sendAuthParams.getToCode().trim().length() > 0) {
            params.put("to_code", sendAuthParams.getToCode());
        }
        return params;
    }

    private void validate(RequestDataObject request2, SendSysParams sendSysParams) throws IllegalArgumentException {
        if (sendSysParams == null) {
            throw new IllegalArgumentException("SendSysParams \u4e3a\u7a7a");
        }
        if (sendSysParams.getFromCode() == null) {
            throw new IllegalArgumentException("fromCode \u4e3a\u7a7a");
        }
    }

    private void validateAuth(RequestDataObject request2, SendAuthParams sendAuthParams) throws IllegalArgumentException {
        if (sendAuthParams == null) {
            throw new IllegalArgumentException("SendAuthParams \u4e3a\u7a7a");
        }
        if (sendAuthParams.getToken() == null) {
            throw new IllegalArgumentException("token \u4e3a\u7a7a");
        }
    }

    public String receive(ReceiveSysParams receiveSysParams) {
        Object response2;
        RequestDataObject request2;
        String api = receiveSysParams.getApi();
        String dataDigest = receiveSysParams.getDataDigest();
        String content = receiveSysParams.getContent();
        ReceiveListener listener = this.receiveListeners.get(api);
        QimenReceiveListener qimenListener = this.qimenListeners.get(api);
        if (listener == null && qimenListener == null) {
            return this.getSysErrorResponse(ErrorCode.other, "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u76d1\u542c\u5904\u7406\u5668\uff1aapi=" + api);
        }
        if (qimenListener != null) {
            try {
                String differentSign = this.verify(content, dataDigest, null);
                if (differentSign != null) {
                    return this.getQimenSysErrorResponse(ErrorCode.illegalSign, "\u7cfb\u7edf\u7b7e\u540d\uff1a" + differentSign + "\uff0c\u5916\u90e8\u7b7e\u540d\uff1a" + dataDigest);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return this.getQimenSysErrorResponse(ErrorCode.illegalSign, "\u9a8c\u7b7e\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38...");
            }
            try {
                String response3 = qimenListener.execute(receiveSysParams);
                return response3;
            }
            catch (Exception e) {
                return this.getQimenSysErrorResponse(ErrorCode.partnerDealException, "\u8c03\u7528\u7269\u6d41\u5408\u4f5c\u5408\u4f5c\u4f19\u4f34\u7684\u76d1\u542c\u5904\u7406\u5668\u65f6\u5f02\u5e38\uff0c" + e.getMessage());
            }
        }
        try {
            request2 = this.deserializeRequest(api, content);
            if (request2 instanceof FileUploadRequest) {
                FileItemUtil.setFileItem(request2, receiveSysParams.getFileParams());
            }
        }
        catch (Exception e) {
            return this.getSysErrorResponse(ErrorCode.formatError, "\u6570\u636e\u62a5\u6587\u53cd\u5e8f\u5217\u5316\u5931\u8d25\uff0c" + e.getMessage());
        }
        try {
            String differentSign = this.verify(content, dataDigest, request2);
            if (differentSign != null) {
                return this.getSysErrorResponse(ErrorCode.illegalSign, "\u7cfb\u7edf\u7b7e\u540d\uff1a" + differentSign + "\uff0c\u5916\u90e8\u7b7e\u540d\uff1a" + dataDigest);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.getSysErrorResponse(ErrorCode.illegalSign, "\u9a8c\u7b7e\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38...");
        }
        try {
            response2 = listener.execute(receiveSysParams, request2);
        }
        catch (Exception e) {
            return this.getSysErrorResponse(ErrorCode.partnerDealException, "\u8c03\u7528\u7269\u6d41\u5408\u4f5c\u5408\u4f5c\u4f19\u4f34\u7684\u76d1\u542c\u5904\u7406\u5668\u65f6\u5f02\u5e38\uff0c" + e.getMessage());
        }
        try {
            return this.serializeResponse(api, (ResponseDataObject)response2);
        }
        catch (Exception e) {
            return this.getSysErrorResponse(ErrorCode.formatError, "\u8fd4\u56de\u5bf9\u8c61\u5e8f\u5217\u5316\u5f02\u5e38\uff0c" + e.getMessage());
        }
    }

    public String receiveAuth(ReceiveAuthParams receiveAuthParams) {
        Object response2;
        RequestDataObject request2;
        String api = receiveAuthParams.getApi();
        String content = receiveAuthParams.getContent();
        String dataDigest = receiveAuthParams.getDataDigest();
        AuthReceiveListener listener = this.authReceiveListeners.get(api);
        try {
            request2 = this.deserializeRequest(api, content);
        }
        catch (Exception e) {
            return this.getSysErrorResponse(ErrorCode.formatError, "\u6570\u636e\u62a5\u6587\u53cd\u5e8f\u5217\u5316\u5931\u8d25\uff0c" + e.getMessage());
        }
        String differentSign = null;
        try {
            this.verify(content, dataDigest, request2);
            if (differentSign != null) {
                return this.getSysErrorResponse(ErrorCode.illegalSign, "\u7cfb\u7edf\u7b7e\u540d\uff1a" + differentSign + "\uff0c\u5916\u90e8\u7b7e\u540d\uff1a" + dataDigest);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.getSysErrorResponse(ErrorCode.illegalSign, "\u9a8c\u7b7e\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38...");
        }
        try {
            response2 = listener.execute(receiveAuthParams, request2);
        }
        catch (Exception e) {
            return this.getSysErrorResponse(ErrorCode.partnerDealException, "\u8c03\u7528\u7269\u6d41\u5408\u4f5c\u5408\u4f5c\u4f19\u4f34\u7684\u76d1\u542c\u5904\u7406\u5668\u65f6\u5f02\u5e38\uff0c" + e.getMessage());
        }
        try {
            return this.serializeResponse(api, (ResponseDataObject)response2);
        }
        catch (Exception e) {
            return this.getSysErrorResponse(ErrorCode.formatError, "\u8fd4\u56de\u5bf9\u8c61\u5e8f\u5217\u5316\u5f02\u5e38\uff0c" + e.getMessage());
        }
    }

    private String verify(String content, String dataDigest, RequestDataObject request2) throws Exception {
        String sign = null;
        sign = request2 == null ? Sign.sign(this.codeService, this.getSignStrategy(), (content + this.getSecretKey()).getBytes(this.getCharset()), this.getCharset()) : Sign.sign(this.codeService, this.getSecretKey(), this.getCharset(), this.getSignStrategy(), content, request2);
        if (dataDigest.equals(sign)) {
            return null;
        }
        return "\u7b7e\u540d\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u7cfb\u7edf\u7b7e\u540d\uff1a" + sign + "\uff0c\u5916\u90e8\u7b7e\u540d\uff1a" + dataDigest;
    }

    public String getSysErrorResponse(ErrorCode errorCode, String errorMsg) {
        return "<response><success>false</success><errorCode>" + errorCode.getAlias() + "</errorCode><errorMsg><![CDATA[" + errorCode.getDesc() + ":" + errorMsg + "]]></errorMsg></response>";
    }

    public String getQimenSysErrorResponse(ErrorCode errorCode, String errorMsg) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><response><flag>failure</flag><code>" + (Object)((Object)errorCode) + "</code><message>" + errorMsg + "</message></response>";
        return xml;
    }

    public <R extends ResponseDataObject> String serializeRequest(String api, RequestDataObject<R> request2) throws Exception {
        return this.mappingService.serializeRequest(api, request2);
    }

    public <R extends ResponseDataObject> R deserializeResponse(String api, String responseContent) {
        try {
            return (R)((ResponseDataObject)this.mappingService.deserializeResponse(api, responseContent));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RequestDataObject deserializeRequest(String api, String content) {
        try {
            return (RequestDataObject)this.mappingService.deserializeRequest(api, content);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String serializeResponse(String api, ResponseDataObject response2) {
        try {
            return this.mappingService.serializeResponse(api, response2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isMultipartContent(HttpServletRequest req) {
        return this.httpService.isMultipleRequest(req);
    }

    public Map<String, PacFileItem> parseFileRequest(HttpServletRequest req, Map<String, String> params) {
        return this.httpService.parseFileRequest(req, params);
    }

    private void initBatchPullService(String pacUrl) {
        String pullUrl = UrlReplace.getActualUrl(pacUrl, "/pac_message_receiver.do", "/msg/pull.do");
        String confirmUrl = UrlReplace.getActualUrl(pacUrl, "/pac_message_receiver.do", "/msg/confirm.do");
        this.batchPullService = new BatchPullService(pullUrl, confirmUrl, this.getAppkey(), this.getSecretKey(), this.getCharset(), this.getSignStrategy(), this.getSockTimeout(), this.getConnectTimeout(), this);
    }

    public PullResponse dataBatchPull(String apiId, String outMsgId, long maxCount) {
        return this.batchPullService.dataBatchPull(apiId, outMsgId, maxCount);
    }

    public ConfirmResponse dataBatchConfirm(List<String> msgIdList, String outMsgId) {
        return this.batchPullService.dataBatchConfirm(msgIdList, outMsgId);
    }

    public int getSockTimeout() {
        return this.sockTimeout;
    }

    public void setSockTimeout(int sockTimeout) {
        this.sockTimeout = sockTimeout;
    }

    public int getFileSockTimeout() {
        return this.fileSockTimeout;
    }

    public void setFileSockTimeout(int fileSockTimeout) {
        this.fileSockTimeout = fileSockTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public CodeService getCodeService() {
        return this.codeService;
    }

    public MappingService getMappingService() {
        return this.mappingService;
    }

    public String getPacUrl() {
        return this.pacUrl;
    }

    public void setPacUrl(String pacUrl) {
        this.pacUrl = pacUrl;
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public SignStrategy getSignStrategy() {
        return this.signStrategy;
    }

    public void setSignStrategy(SignStrategy signStrategy) {
        this.signStrategy = signStrategy;
    }

    public void setPacLogger(PacLogger logger) {
        this.logger = logger;
        Logger.logger = logger;
    }

    public PacLogger getLogger() {
        return this.logger;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getAppkey() {
        return this.appkey;
    }

    public HttpService getHttpService() {
        return this.httpService;
    }

    public boolean isMonitorFlag() {
        return this.monitorFlag;
    }

    public Map<String, Object> getOutHttpParams() {
        return this.outHttpParams;
    }

    public void setOutHttpParams(Map<String, Object> outHttpParams) {
        this.outHttpParams = outHttpParams;
    }

    public void setMonitorFlag(boolean monitorFlag) {
        this.monitorFlag = monitorFlag;
    }

    private <R extends ResponseDataObject> R getErrorResponseInstance(Class<R> clazz, ErrorCode errorCode, String errorMsg) {
        return this.getErrorResponseInstance(clazz, errorCode.getAlias(), errorMsg);
    }

    private <R extends ResponseDataObject> R getErrorResponseInstance(Class<R> clazz, String errorCode, String errorMsg) {
        ResponseDataObject response2 = null;
        try {
            response2 = (ResponseDataObject)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        response2.setSuccess(false);
        response2.setErrorCode(errorCode);
        response2.setErrorMsg(errorMsg);
        return (R)response2;
    }

    public HttpProxy getHttpProxy() {
        return this.httpProxy;
    }

    public void setHttpProxy(HttpProxy httpProxy) {
        this.httpProxy = httpProxy;
    }
}

