/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pac.sdk.cp;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PacFileItem {
    private String fileName;
    private String mimeType;
    private byte[] content;
    private File file;

    public PacFileItem(String fileName, File file) {
        this.validate(fileName);
        this.fileName = fileName;
        this.file = file;
    }

    public PacFileItem(String fileName, String filePath) {
        this.validate(fileName);
        File file = new File(filePath);
        this.fileName = fileName;
        this.file = file;
    }

    public PacFileItem(String fileName, byte[] content) {
        this.validate(fileName);
        this.fileName = fileName;
        this.content = content;
    }

    public PacFileItem(String fileName, byte[] content, String mimeType) {
        this.validate(fileName);
        this.fileName = fileName;
        this.content = content;
        this.mimeType = mimeType;
    }

    public String getMimeType() throws IOException {
        if (this.mimeType == null) {
            this.mimeType = PacFileItem.getMimeType(this.getContent());
        }
        return this.mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getContent() throws IOException {
        if (this.content == null && this.file != null && this.file.exists()) {
            FileInputStream in = null;
            ByteArrayOutputStream out = null;
            try {
                int ch;
                in = new FileInputStream(this.file);
                out = new ByteArrayOutputStream();
                while ((ch = ((InputStream)in).read()) != -1) {
                    out.write(ch);
                }
                this.content = out.toByteArray();
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
        }
        return this.content;
    }

    public static String getMimeType(byte[] bytes) {
        String suffix = PacFileItem.getFileSuffix(bytes);
        String mimeType = "JPG".equals(suffix) ? "image/jpeg" : ("GIF".equals(suffix) ? "image/gif" : ("PNG".equals(suffix) ? "image/png" : ("BMP".equals(suffix) ? "image/bmp" : "application/octet-stream")));
        return mimeType;
    }

    public File getFile() {
        return this.file;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public static String getFileSuffix(byte[] bytes) {
        if (bytes == null || bytes.length < 10) {
            return null;
        }
        if (bytes[0] == 71 && bytes[1] == 73 && bytes[2] == 70) {
            return "GIF";
        }
        if (bytes[1] == 80 && bytes[2] == 78 && bytes[3] == 71) {
            return "PNG";
        }
        if (bytes[6] == 74 && bytes[7] == 70 && bytes[8] == 73 && bytes[9] == 70) {
            return "JPG";
        }
        if (bytes[0] == 66 && bytes[1] == 77) {
            return "BMP";
        }
        return null;
    }

    public String toString() {
        return "" + this.fileName;
    }

    private void validate(String fileName) throws IllegalArgumentException {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("file name cannot be null or empty");
        }
    }
}

