/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pac.sdk.cp;

import com.taobao.pac.sdk.cp.ErrorCode;
import com.taobao.pac.sdk.cp.PacClient;
import com.taobao.pac.sdk.cp.PacFileItem;
import com.taobao.pac.sdk.cp.PacLogger;
import com.taobao.pac.sdk.cp.ReceiveAuthParams;
import com.taobao.pac.sdk.cp.ReceiveSysParams;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PacServlet
extends HttpServlet {
    private static final long serialVersionUID = -6562702371933707885L;
    private String sysCharset;
    private PacLogger logger;
    private PacClient pacClient;
    private String responseContentType;

    public void init() {
        if (this.pacClient == null) {
            throw new RuntimeException("pacClient can't be null in PacServlet");
        }
        this.sysCharset = this.pacClient.getCharset();
        this.logger = this.pacClient.getLogger();
        this.responseContentType = "text/html;charset=" + this.sysCharset;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String qllTag;
        long startTime = System.currentTimeMillis();
        String ip = req.getRemoteHost();
        req.setCharacterEncoding(this.sysCharset);
        resp.setCharacterEncoding(this.sysCharset);
        HashMap<String, String> params = new HashMap<String, String>();
        Map<String, PacFileItem> fileParams = null;
        boolean isMultipart = this.pacClient.isMultipartContent(req);
        if (!isMultipart) {
            Enumeration enumeration = req.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = req.getParameter(key);
                params.put(key, value);
            }
        } else {
            fileParams = this.pacClient.parseFileRequest(req, params);
        }
        if ((qllTag = (String)params.get("t")) != null) {
            this.eagleEyeTag("1".equals(qllTag));
        }
        qllTag = (String)params.get("tb_eagleeyex_t");
        boolean qllFlag = false;
        if (qllTag != null && "1".equals(qllTag)) {
            qllFlag = true;
            this.eagleEyeTag(qllFlag);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n\u8fdc\u7a0bIP::");
        sb.append(ip);
        sb.append("\n\u63a5\u6536\u8bf7\u6c42\u53c2\u6570::").append(params);
        String msgId = (String)params.get("msg_id");
        String api = (String)params.get("msg_type");
        String dataDigest = (String)params.get("data_digest");
        String content = (String)params.get("logistics_interface");
        String partnerCode = (String)params.get("partner_code");
        String fromCpCode = (String)params.get("from_code");
        String token = (String)params.get("token");
        boolean isAuthReq = token != null && token.trim().length() > 0;
        Throwable isThrow = null;
        try {
            if (api == null || api.trim().length() == 0) {
                String errorMsg = "\u7cfb\u7edf\u53c2\u6570api(msg_type)\u4e3a\u7a7a";
                this.print(sb, resp, this.getSysErrorResponse(ErrorCode.illegalParams, errorMsg));
                return;
            }
            if (dataDigest == null || dataDigest.trim().length() == 0) {
                String errorMsg = "\u7cfb\u7edf\u53c2\u6570dataDigest(data_digest)\u4e3a\u7a7a";
                this.print(sb, resp, this.getSysErrorResponse(ErrorCode.illegalParams, errorMsg));
                return;
            }
            if (content == null || content.trim().length() == 0) {
                String errorMsg = "\u7cfb\u7edf\u53c2\u6570content(logistics_interface)\u4e3a\u7a7a";
                this.print(sb, resp, this.getSysErrorResponse(ErrorCode.illegalParams, errorMsg));
                return;
            }
            if (!(isAuthReq || partnerCode != null && partnerCode.trim().length() != 0)) {
                String errorMsg = "\u7cfb\u7edf\u53c2\u6570partnerCode(partner_code)\u4e3a\u7a7a";
                this.print(sb, resp, this.getSysErrorResponse(ErrorCode.illegalParams, errorMsg));
                return;
            }
            String result2 = null;
            try {
                if (isAuthReq) {
                    ReceiveAuthParams receiveAuthParams = new ReceiveAuthParams();
                    receiveAuthParams.setMsgId(msgId);
                    receiveAuthParams.setApi(api);
                    receiveAuthParams.setDataDigest(dataDigest);
                    receiveAuthParams.setContent(content);
                    receiveAuthParams.setToken(token);
                    receiveAuthParams.setFromCpCode(fromCpCode);
                    receiveAuthParams.setQllFlag(qllFlag);
                    if (fileParams != null) {
                        receiveAuthParams.setFileParams(fileParams);
                    }
                    result2 = this.pacClient.receiveAuth(receiveAuthParams);
                } else {
                    ReceiveSysParams receiveSysParams = new ReceiveSysParams();
                    receiveSysParams.setMsgId(msgId);
                    receiveSysParams.setApi(api);
                    receiveSysParams.setDataDigest(dataDigest);
                    receiveSysParams.setContent(content);
                    receiveSysParams.setPartnerCode(partnerCode);
                    receiveSysParams.setFromCpCode(fromCpCode);
                    receiveSysParams.setQllFlag(qllFlag);
                    if (fileParams != null) {
                        receiveSysParams.setFileParams(fileParams);
                    }
                    result2 = this.pacClient.receive(receiveSysParams);
                }
            }
            catch (Exception e) {
                String errorMsg = "\u53d1\u751f\u4e0d\u9884\u671f\u7684\u5f02\u5e38\uff1a" + e.getMessage();
                this.print(sb, resp, this.getSysErrorResponse(ErrorCode.other, errorMsg));
                long endTime = System.currentTimeMillis();
                sb.append("\n\u8017\u65f6::" + (endTime - startTime));
                if (isThrow != null) {
                    this.logger.error(sb.toString());
                } else if (this.logger.isLogEnable() && this.logger.isInfoEnable()) {
                    this.logger.info(sb.toString());
                }
                return;
            }
            this.print(sb, resp, result2);
        }
        catch (Throwable e) {
            isThrow = e;
            if (this.logger.isLogEnable()) {
                this.logger.error("\u5f02\u5e38", e);
            }
            sb.append("\n[ERROR]\u5f02\u5e38::" + e.getMessage());
            this.print(resp, sb.toString());
        }
        finally {
            long endTime = System.currentTimeMillis();
            sb.append("\n\u8017\u65f6::" + (endTime - startTime));
            if (isThrow != null) {
                this.logger.error(sb.toString());
            } else if (this.logger.isLogEnable() && this.logger.isInfoEnable()) {
                this.logger.info(sb.toString());
            }
        }
    }

    private String getSysErrorResponse(ErrorCode errorCode, String errorMsg) {
        return this.pacClient.getSysErrorResponse(errorCode, errorMsg);
    }

    private void print(StringBuilder sb, HttpServletResponse resp, String msg) throws IOException {
        sb.append("\n\u8fd4\u56de\uff1a" + msg);
        this.print(resp, msg);
    }

    private void print(HttpServletResponse resp, String msg) throws IOException {
        resp.setHeader("Content-type", this.responseContentType);
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(msg);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public void setPacClient(PacClient pacClient) {
        this.pacClient = pacClient;
    }

    private void eagleEyeTag(boolean qllTag) {
        if (qllTag) {
            try {
                Class<?> eagleEyleClass = Class.forName("com.taobao.eagleeye.EagleEye");
                Method putMethod = eagleEyleClass.getDeclaredMethod("putUserData", String.class, String.class);
                putMethod.invoke(eagleEyleClass, "t", "1");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

