/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pac.sdk.cp.ftp;

import com.taobao.pac.sdk.cp.PacClient;
import com.taobao.pac.sdk.cp.SendSysParams;
import com.taobao.pac.sdk.cp.dataobject.request.STANDARD_FTP.StandardFtpRequest;
import com.taobao.pac.sdk.cp.dataobject.response.STANDARD_FTP.FTPFile;
import com.taobao.pac.sdk.cp.dataobject.response.STANDARD_FTP.StandardFtpResponse;
import com.taobao.pac.sdk.cp.ftp.FileInfo;
import com.taobao.pac.sdk.cp.ftp.FtpBizKeyHelper;
import com.taobao.pac.sdk.cp.ftp.FtpResult;
import com.taobao.pac.sdk.cp.sar.ServiceFactory;
import com.taobao.pac.sdk.cp.services.CodeService;
import java.util.ArrayList;
import java.util.List;

public class FtpClient {
    private final PacClient pacClient;
    private CodeService codeService;
    private static final String SAVE_TEXT = "save";
    private static final String SAVE_BINARY = "save_binary";
    private static final String LOAD_TEXT = "load";
    private static final String LOAD_BINARY = "load_binary";
    private static final String LIST = "list";
    private static final String DELETE = "delete";
    private static final String RENAME = "rename";
    private static final String CHARSET = "utf-8";

    public FtpClient(String appkey, String secretKey, String url) {
        this.pacClient = new PacClient(appkey, secretKey, url);
        this.init();
    }

    private synchronized void init() {
        ServiceFactory.init();
        this.codeService = ServiceFactory.getService(CodeService.class);
        if (this.codeService == null) {
            throw new IllegalArgumentException("\u7f16\u7801\u63a5\u53e3\uff08codeService\uff09\u4e0d\u80fd\u4e3anull");
        }
    }

    public FtpResult<String> loadTextFile(SendSysParams sendSysParams, String fileName) {
        String bizKey = FtpBizKeyHelper.getBizKey();
        StandardFtpRequest request2 = new StandardFtpRequest();
        request2.setOperationType(LOAD_TEXT);
        request2.setFileName(fileName);
        request2.setBizKey(bizKey);
        StandardFtpResponse response2 = this.pacClient.send(request2, sendSysParams);
        FtpResult<String> result2 = new FtpResult<String>();
        if (!response2.isSuccess()) {
            this.convertErrorResponse2FtpResult(result2, response2);
            return result2;
        }
        result2.setSuccess(true);
        result2.setContent(response2.getContent());
        return result2;
    }

    public FtpResult<byte[]> loadBinaryFile(SendSysParams sendSysParams, String fileName) {
        String bizKey = FtpBizKeyHelper.getBizKey();
        StandardFtpRequest request2 = new StandardFtpRequest();
        request2.setOperationType(LOAD_BINARY);
        request2.setFileName(fileName);
        request2.setBizKey(bizKey);
        StandardFtpResponse response2 = this.pacClient.send(request2, sendSysParams);
        FtpResult<byte[]> result2 = new FtpResult<byte[]>();
        if (!response2.isSuccess()) {
            this.convertErrorResponse2FtpResult(result2, response2);
            return result2;
        }
        String content = response2.getContent();
        try {
            byte[] bytes = content.getBytes(CHARSET);
            result2.setSuccess(true);
            result2.setContent(this.codeService.decodeBase64(bytes));
        }
        catch (Exception e) {
            result2.setSuccess(false);
            result2.setErrorMsg(e.getMessage());
        }
        return result2;
    }

    public FtpResult<Boolean> storeTextFile(SendSysParams sendSysParams, String fileName, String content) {
        String bizKey = FtpBizKeyHelper.getBizKey();
        StandardFtpRequest request2 = new StandardFtpRequest();
        request2.setOperationType(SAVE_TEXT);
        request2.setFileName(fileName);
        request2.setContent(content);
        request2.setBizKey(bizKey);
        StandardFtpResponse response2 = this.pacClient.send(request2, sendSysParams);
        return this.generateBooleanFtpResultFromResponse(response2);
    }

    public FtpResult<Boolean> storeBinaryFile(SendSysParams sendSysParams, String fileName, byte[] content) {
        String bizKey = FtpBizKeyHelper.getBizKey();
        StandardFtpRequest request2 = new StandardFtpRequest();
        request2.setOperationType(SAVE_BINARY);
        request2.setFileName(fileName);
        request2.setBizKey(bizKey);
        try {
            byte[] base64Content = this.codeService.base64(content);
            request2.setContent(new String(base64Content, CHARSET));
        }
        catch (Exception e) {
            FtpResult<Boolean> result2 = new FtpResult<Boolean>();
            result2.setSuccess(false);
            result2.setErrorMsg(e.getMessage());
            return result2;
        }
        StandardFtpResponse response2 = this.pacClient.send(request2, sendSysParams);
        return this.generateBooleanFtpResultFromResponse(response2);
    }

    public FtpResult<List<FileInfo>> listFiles(SendSysParams sendSysParams, String path) {
        String bizKey = FtpBizKeyHelper.getBizKey();
        StandardFtpRequest request2 = new StandardFtpRequest();
        request2.setOperationType(LIST);
        request2.setPath(path);
        request2.setBizKey(bizKey);
        StandardFtpResponse response2 = this.pacClient.send(request2, sendSysParams);
        FtpResult<List<FileInfo>> result2 = new FtpResult<List<FileInfo>>();
        if (!response2.isSuccess()) {
            this.convertErrorResponse2FtpResult(result2, response2);
            return result2;
        }
        result2.setSuccess(true);
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        for (FTPFile ftpFile : response2.getFiles()) {
            FileInfo fileInfo = new FileInfo();
            fileInfo.setName(ftpFile.getName());
            fileInfo.setDirectory(ftpFile.isIsDirectory());
            fileInfo.setTimestamp(ftpFile.getTimestamp());
            fileInfos.add(fileInfo);
        }
        result2.setContent(fileInfos);
        return result2;
    }

    public FtpResult<Boolean> deleteFile(SendSysParams sendSysParams, String fileName) {
        String bizKey = FtpBizKeyHelper.getBizKey();
        StandardFtpRequest request2 = new StandardFtpRequest();
        request2.setOperationType(DELETE);
        request2.setFileName(fileName);
        request2.setBizKey(bizKey);
        StandardFtpResponse response2 = this.pacClient.send(request2, sendSysParams);
        return this.generateBooleanFtpResultFromResponse(response2);
    }

    public FtpResult<Boolean> renameFile(SendSysParams sendSysParams, String oldFileName, String newFileName) {
        String bizKey = FtpBizKeyHelper.getBizKey();
        StandardFtpRequest request2 = new StandardFtpRequest();
        request2.setOperationType(RENAME);
        request2.setFileName(oldFileName);
        request2.setContent(newFileName);
        request2.setBizKey(bizKey);
        StandardFtpResponse response2 = this.pacClient.send(request2, sendSysParams);
        return this.generateBooleanFtpResultFromResponse(response2);
    }

    public int getConnectTimeout() {
        return this.pacClient.getConnectTimeout();
    }

    public void setConnectTimeout(int connectTimeout) {
        this.pacClient.setConnectTimeout(connectTimeout);
    }

    public int getSocketTimeout() {
        return this.pacClient.getSockTimeout();
    }

    public void setSocketTimeout(int socketTimeout) {
        this.pacClient.setSockTimeout(socketTimeout);
    }

    private FtpResult<Boolean> generateBooleanFtpResultFromResponse(StandardFtpResponse response2) {
        FtpResult<Boolean> result2 = new FtpResult<Boolean>();
        if (!response2.isSuccess()) {
            this.convertErrorResponse2FtpResult(result2, response2);
        } else {
            result2.setSuccess(true);
            result2.setContent(true);
        }
        return result2;
    }

    private <T> void convertErrorResponse2FtpResult(FtpResult<T> result2, StandardFtpResponse response2) {
        if (response2.isSuccess()) {
            throw new IllegalStateException();
        }
        result2.setSuccess(false);
        result2.setErrorMsg(response2.getErrorMsg());
        result2.setErrorCode(response2.getErrorCode());
    }
}

