/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pac.sdk.cp.pull;

import com.taobao.pac.sdk.cp.ErrorCode;
import com.taobao.pac.sdk.cp.PacClient;
import com.taobao.pac.sdk.cp.PacLogger;
import com.taobao.pac.sdk.cp.RemoteRequestResult;
import com.taobao.pac.sdk.cp.RequestDataObject;
import com.taobao.pac.sdk.cp.SignStrategy;
import com.taobao.pac.sdk.cp.pull.ConfirmResponse;
import com.taobao.pac.sdk.cp.pull.PullMsg;
import com.taobao.pac.sdk.cp.pull.PullResponse;
import com.taobao.pac.sdk.cp.sar.ServiceFactory;
import com.taobao.pac.sdk.cp.services.CodeService;
import com.taobao.pac.sdk.cp.services.HttpService;
import com.taobao.pac.sdk.cp.services.MappingService;
import com.taobao.pac.sdk.cp.services.dto.HttpResult;
import com.taobao.pac.sdk.cp.util.DocUtils;
import com.taobao.pac.sdk.cp.util.Sign;
import java.io.FileInputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BatchPullService {
    public static PacLogger logger = PacLogger.instance;
    private static final int defaultMaxCount = 30;
    private HttpService httpService = ServiceFactory.getService(HttpService.class);
    private MappingService mappingService = ServiceFactory.getService(MappingService.class);
    private CodeService codeService = ServiceFactory.getService(CodeService.class);
    private String pullUrl = null;
    private String confirmUrl;
    private String appkey;
    private String secretKey;
    private String charset;
    private SignStrategy signStrategy;
    private int sockTimeout;
    private int connectTimeout;
    private PacClient pacClient;

    public BatchPullService() {
    }

    public BatchPullService(String pullUrl, String confirmUrl, String appkey, String secretKey, String charset, SignStrategy signStrategy, int sockTimeout, int connectTimeout, PacClient pacClient) {
        this.pullUrl = pullUrl;
        this.confirmUrl = confirmUrl;
        this.appkey = appkey;
        this.secretKey = secretKey;
        this.charset = charset;
        this.signStrategy = signStrategy;
        this.sockTimeout = sockTimeout;
        this.connectTimeout = connectTimeout;
        this.pacClient = pacClient;
    }

    public PullResponse dataBatchPull(String apiId, String outMsgId, long maxCount) {
        PullResponse response2 = new PullResponse();
        if (apiId == null || apiId.isEmpty()) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u63a5\u53e3apiId\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (outMsgId == null || outMsgId.isEmpty()) {
            throw new IllegalArgumentException("outMsgId\u7528\u6765\u8bb0\u65e5\u5fd7\u7684,\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (maxCount < 0L) {
            response2.setSuccess(false);
            response2.setErrorCode("S13");
            response2.setErrorMsg("maxCount\u4e0d\u80fd\u5c0f\u4e8e0!,\u8bf7\u91cd\u65b0\u4fee\u6539!");
            return response2;
        }
        if (logger.isLogEnable()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\u8c03\u7528\u4e3b\u52a8\u62c9\u53d6\u63a5\u53e3:").append("outMsgId:").append(outMsgId).append(";").append("apiId:").append(apiId).append(";").append("maxCount:").append(maxCount).append(";");
            logger.error(sb.toString());
        }
        HttpResult httpResult = null;
        RemoteRequestResult result2 = new RemoteRequestResult();
        List<PullMsg> pullMsgList = null;
        try {
            Map<String, String> params = this.getPullParams(apiId, outMsgId, maxCount);
            httpResult = this.httpService.request(null, this.pullUrl, this.getCharset(), this.getSockTimeout(), this.getConnectTimeout(), params, this.pacClient.getOutHttpParams(), this.pacClient.getHttpProxy());
            if (200 == httpResult.getStatus()) {
                result2.setSuccess(true);
                String resContent = httpResult.getContent();
                result2.setContent(resContent);
            } else {
                result2.setSuccess(false);
                result2.setErrorMsg("status:" + httpResult.getStatus() + ",body=" + httpResult.getErrorMsg());
            }
        }
        catch (Exception e) {
            result2.setSuccess(false);
            result2.setErrorMsg(ErrorCode.other.getDesc() + ":" + e.getMessage());
            return response2;
        }
        if (!result2.isSuccess()) {
            response2.setSuccess(result2.isSuccess());
            response2.setErrorMsg(result2.getErrorMsg());
            return response2;
        }
        try {
            pullMsgList = this.deserializePullMsg(result2.getContent());
        }
        catch (Exception e) {
            response2.setSuccess(false);
            response2.setErrorCode(ErrorCode.dealDataError.getAlias());
            response2.setErrorMsg(ErrorCode.dealDataError.getDesc() + ":" + result2.getContent());
            return response2;
        }
        response2.setSuccess(true);
        response2.setPullMsgList(pullMsgList);
        if (maxCount > 30L) {
            response2.setErrorMsg("maxCount\u53ea\u80fd\u652f\u6301\u6700\u5927\u503c:30!");
        }
        return response2;
    }

    public ConfirmResponse dataBatchConfirm(List<String> msgIdList, String outMsgId) {
        if (outMsgId == null || outMsgId.isEmpty()) {
            throw new IllegalArgumentException("outMsgId\u7528\u6765\u8bb0\u65e5\u5fd7\u7684,\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (msgIdList == null || msgIdList.size() == 0) {
            throw new IllegalArgumentException("msgIdList\u7528\u6765\u786e\u8ba4\u5904\u7406\u7ed3\u679c,\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (logger.isLogEnable()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\u8c03\u7528\u6d88\u606f\u786e\u8ba4\u63a5\u53e3:").append("outMsgId:").append(outMsgId).append(";");
            sb.append("msgId:");
            for (String msgId : msgIdList) {
                sb.append(msgId).append(",");
            }
            sb.append(";");
            logger.error(sb.toString());
        }
        ConfirmResponse response2 = new ConfirmResponse();
        RemoteRequestResult result2 = new RemoteRequestResult();
        try {
            Map<String, String> params = this.getConfrimParams(msgIdList, outMsgId);
            HttpResult httpResult = this.httpService.request(null, this.confirmUrl, this.getCharset(), this.getSockTimeout(), this.getConnectTimeout(), params, this.pacClient.getOutHttpParams(), this.pacClient.getHttpProxy());
            if (200 == httpResult.getStatus()) {
                result2.setSuccess(true);
                String resContent = httpResult.getContent();
                result2.setContent(resContent);
            } else {
                result2.setSuccess(false);
                result2.setErrorMsg("status:" + httpResult.getStatus() + ",body=" + httpResult.getErrorMsg());
            }
        }
        catch (Exception e) {
            response2.setSuccess(false);
            response2.setErrorCode(ErrorCode.other.getAlias());
            response2.setErrorMsg(ErrorCode.other.getDesc() + ":" + result2.getContent());
        }
        try {
            List<String> confirmMsgIdList = this.deserializeConfirmMsg(result2.getContent());
            List<String> notConfirmMsgIdList = this.getNotConfirmMsgIdList(msgIdList, confirmMsgIdList);
            if (notConfirmMsgIdList != null) {
                response2.setConfirmAllSuccess(false);
                response2.setNotConfirmMsgIdList(notConfirmMsgIdList);
            } else {
                response2.setConfirmAllSuccess(true);
            }
        }
        catch (Exception e) {
            response2.setSuccess(false);
            response2.setErrorCode(ErrorCode.dealDataError.getAlias());
            response2.setErrorMsg(ErrorCode.dealDataError.getDesc() + ":" + result2.getContent());
        }
        response2.setSuccess(true);
        return response2;
    }

    public List<String> getNotConfirmMsgIdList(List<String> originMsgIdList, List<String> confirmMsgIdList) {
        ArrayList<String> notConfirmMsgIdList = null;
        for (String originMsgId : originMsgIdList) {
            boolean flag = true;
            for (String confirmMsgId : confirmMsgIdList) {
                if (!originMsgId.equals(confirmMsgId)) continue;
                flag = false;
                confirmMsgIdList.remove(confirmMsgId);
                break;
            }
            if (!flag) continue;
            if (notConfirmMsgIdList == null) {
                notConfirmMsgIdList = new ArrayList<String>();
            }
            notConfirmMsgIdList.add(originMsgId);
        }
        return notConfirmMsgIdList;
    }

    private Map<String, String> getPullParams(String apiId, String outMsgId, long maxCount) throws UnsupportedEncodingException {
        HashMap<String, String> params = new HashMap<String, String>();
        String dataDigest = Sign.sign(this.codeService, this.getSignStrategy(), (outMsgId + this.getSecretKey()).getBytes(this.getCharset()), this.getCharset());
        params.put("appkey", this.getAppkey());
        params.put("api_id", apiId);
        params.put("out_msg_id", outMsgId);
        params.put("sign", dataDigest);
        params.put("count", "" + maxCount);
        return params;
    }

    private Map<String, String> getConfrimParams(List<String> msgIdList, String outMsgId) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < msgIdList.size() - 1; ++i) {
            sb.append(msgIdList.get(i)).append(",");
        }
        sb.append(msgIdList.get(msgIdList.size() - 1));
        String msg_id_s = sb.toString();
        HashMap<String, String> params = new HashMap<String, String>();
        String dataDigest = Sign.sign(this.codeService, this.getSignStrategy(), (outMsgId + this.getSecretKey()).getBytes(this.getCharset()), this.getCharset());
        params.put("appkey", this.getAppkey());
        params.put("out_msg_id", outMsgId);
        params.put("msg_id_s", msg_id_s);
        params.put("sign", dataDigest);
        return params;
    }

    public List<PullMsg> deserializePullMsg(String content) throws Exception {
        ArrayList<PullMsg> pullMsgList = new ArrayList<PullMsg>();
        Document doc = DocUtils.stringToDom(content);
        Element rootNode = doc.getDocumentElement();
        NodeList elmentList = rootNode.getChildNodes();
        String apiId = null;
        if (elmentList != null) {
            for (int i = 0; i < elmentList.getLength(); ++i) {
                Node node = elmentList.item(i);
                if (!node.getNodeName().equals("msg")) continue;
                PullMsg pullMsg = new PullMsg();
                NodeList elmentChild = node.getChildNodes();
                for (int j = 0; j < elmentChild.getLength(); ++j) {
                    Node nodeChild = elmentChild.item(j);
                    if (nodeChild.getNodeName().equals("msgId")) {
                        pullMsg.setMsgId(nodeChild.getTextContent());
                        continue;
                    }
                    if (nodeChild.getNodeName().equals("apiId")) {
                        apiId = nodeChild.getTextContent();
                        pullMsg.setApiId(nodeChild.getTextContent());
                        continue;
                    }
                    if (nodeChild.getNodeName().equals("fromCode")) {
                        pullMsg.setFromCode(nodeChild.getTextContent());
                        continue;
                    }
                    if (nodeChild.getNodeName().equals("toCode")) {
                        pullMsg.setToCode(nodeChild.getTextContent());
                        continue;
                    }
                    if (!nodeChild.getNodeName().equals("content")) continue;
                    NodeList aaList = nodeChild.getChildNodes();
                    Node nodeChildChild = aaList.item(0);
                    TransformerFactory tf = TransformerFactory.newInstance();
                    Transformer transformer = tf.newTransformer();
                    DOMSource source = new DOMSource(nodeChildChild);
                    StringWriter sw = new StringWriter();
                    StreamResult result2 = new StreamResult(sw);
                    transformer.transform(source, result2);
                    String requestString = sw.toString();
                    RequestDataObject request2 = (RequestDataObject)this.mappingService.deserializeRequest(apiId, requestString);
                    pullMsg.setRequest(request2);
                }
                pullMsgList.add(pullMsg);
            }
        }
        return pullMsgList;
    }

    private List<String> deserializeConfirmMsg(String content) {
        ArrayList<String> msgIdList = new ArrayList<String>();
        Document doc = DocUtils.stringToDom(content);
        Element rootNode = doc.getDocumentElement();
        NodeList elmentList = rootNode.getChildNodes();
        if (elmentList == null) {
            return null;
        }
        for (int i = 0; i < elmentList.getLength(); ++i) {
            Node node = elmentList.item(i);
            if (!node.getNodeName().equals("response")) continue;
            NodeList elmentChild = node.getChildNodes();
            for (int j = 0; j < elmentChild.getLength(); ++j) {
                Node nodeChild = elmentChild.item(j);
                if (!nodeChild.getNodeName().equals("msgId")) continue;
                msgIdList.add(nodeChild.getTextContent());
            }
        }
        return msgIdList;
    }

    public String getPullUrl() {
        return this.pullUrl;
    }

    public void setPullUrl(String pullUrl) {
        this.pullUrl = pullUrl;
    }

    public String getConfirmUrl() {
        return this.confirmUrl;
    }

    public void setConfirmUrl(String confirmUrl) {
        this.confirmUrl = confirmUrl;
    }

    public String getAppkey() {
        return this.appkey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getCharset() {
        return this.charset;
    }

    public SignStrategy getSignStrategy() {
        return this.signStrategy;
    }

    public int getSockTimeout() {
        return this.sockTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public static void main(String[] args) throws Exception {
        FileInputStream inStream = new FileInputStream("d:/ztomsg.txt");
        byte[] retbyte = new byte[inStream.available()];
        inStream.read(retbyte);
        String content = new String(retbyte, "utf-8");
        Document doc = DocUtils.stringToDom(content);
        Element rootNode = doc.getDocumentElement();
        NodeList elmentList = rootNode.getChildNodes();
        Element aa = doc.createElement("aaa");
    }

    public static String doc2String(Document doc) {
        try {
            DOMSource source = new DOMSource(doc);
            StringWriter stringWriter = new StringWriter();
            StreamResult result2 = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result2);
            return stringWriter.getBuffer().toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

