/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pac.sdk.cp.sar;

import com.taobao.pac.sdk.cp.Logger;
import com.taobao.pac.sdk.cp.sar.CompoundEnumeration;
import com.taobao.pac.sdk.cp.sar.OpenClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Properties;

public class IClassLoader
extends URLClassLoader {
    private static final String version = "1.0.0.5";
    private static IClassLoader instance;
    private OpenClassLoader parent;
    private static final boolean isForceUpdate = false;
    private static final String standardClasspathConfigFile = "/sar/sar.properties";
    private static final String standardClasspathDir = "/sar/jars/";
    private static String workDir;

    private IClassLoader(URL[] urls) {
        this(urls, IClassLoader.class.getClassLoader());
    }

    private IClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, (ClassLoader)null);
        this.parent = new OpenClassLoader(parent);
    }

    public static synchronized IClassLoader getInstance() throws IOException {
        if (instance != null) {
            return instance;
        }
        instance = IClassLoader.getInstance(standardClasspathConfigFile);
        return instance;
    }

    private static IClassLoader getInstance(String classpathConfigFile) throws IOException {
        Class<IClassLoader> clazz = IClassLoader.class;
        InputStream in = clazz.getResourceAsStream(classpathConfigFile);
        Properties config = new Properties();
        String sarDir = workDir + standardClasspathDir.replace("/", File.separator) + version + File.separator;
        File sarDirFile = new File(sarDir);
        if (!sarDirFile.exists() && !sarDirFile.mkdirs()) {
            throw new RuntimeException("create sar dir fail:" + sarDir);
        }
        Logger.error("\u521d\u59cb\u5316sar\u76ee\u5f55\uff1a" + sarDirFile);
        try {
            config.load(in);
            String content = config.getProperty("jars");
            Logger.error("sar\u4e2djar\u5305\u5217\u8868\u5982\u4e0b\uff1a" + content);
            String[] jars = content.split(";");
            URL[] urls = new URL[jars.length];
            for (int i = 0; i < jars.length; ++i) {
                String jarName = jars[i];
                jarName = jarName.trim();
                String resource = standardClasspathDir + jarName;
                URL url = clazz.getResource(resource);
                if (url == null) {
                    throw new RuntimeException("can't found resources:" + resource);
                }
                String urlStr = url.toString();
                if (urlStr.startsWith("wsjar:")) {
                    String jarUrl = urlStr.substring(2);
                    url = new URL(jarUrl);
                }
                if (url.getProtocol().equals("jar")) {
                    String jarFileName = sarDir + jarName;
                    File jarFile = new File(jarFileName);
                    if (!jarFile.exists()) {
                        jarFile.createNewFile();
                        InputStream jarIn = null;
                        OutputStream jarOut = null;
                        try {
                            jarIn = clazz.getResourceAsStream(resource);
                            jarOut = new FileOutputStream(jarFile);
                            IClassLoader.transfer(jarIn, jarOut);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            if (jarIn != null) {
                                jarIn.close();
                            }
                            if (jarOut != null) {
                                jarOut.flush();
                                jarOut.close();
                            }
                        }
                        Logger.error("jar\u5305\u521d\u59cb\u5316\u6210\u529f\uff1a" + jarFileName);
                    } else {
                        Logger.error("jar\u5305\u5df2\u7ecf\u5b58\u5728\uff1a" + jarFileName);
                    }
                    url = jarFile.toURI().toURL();
                } else {
                    Logger.error("\u52a0\u8f7d\u6587\u4ef6\u534f\u8bae\u8d44\u6e90\uff1a" + resource);
                }
                Logger.error("\u52a0\u8f7durl\uff1a" + url);
                urls[i] = url;
            }
            IClassLoader iClassLoader = new IClassLoader(urls);
            return iClassLoader;
        }
        catch (IOException e) {
            Logger.error("\u52a0\u8f7d\u6587\u4ef6\u534f\u8bae\u8d44\u6e90\u5f02\u5e38", e);
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private static void transfer(InputStream is, OutputStream os) throws IOException {
        int count;
        byte[] buf = new byte[4096];
        while ((count = is.read(buf)) >= 0) {
            os.write(buf, 0, count);
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return this.parent.loadClass(name);
        }
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            return this.parent.loadClass(name, resolve);
        }
    }

    @Override
    public URL getResource(String name) {
        URL url = super.getResource(name);
        if (url == null) {
            url = this.parent.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> resources;
        Enumeration[] tmp = new Enumeration[2];
        tmp[0] = resources = super.getResources(name);
        if (this.parent != null) {
            Enumeration<URL> parentResources;
            tmp[1] = parentResources = this.parent.getResources(name);
        }
        return new CompoundEnumeration<URL>(tmp);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream in = super.getResourceAsStream(name);
        if (in != null) {
            return in;
        }
        return this.parent.getResourceAsStream(name);
    }

    public static void setWorkDir(String workDir) {
        if (workDir == null || workDir.trim().length() < 1) {
            throw new RuntimeException("\u975e\u6cd5sar\u5305\u5de5\u4f5c\u76ee\u5f55");
        }
        if (workDir.endsWith(File.separator)) {
            workDir = workDir.substring(0, workDir.length() - 1);
        }
        IClassLoader.workDir = workDir;
    }

    static {
        workDir = System.getProperty("user.home");
    }

    static interface ConfigKey {
        public static final String jars = "jars";
    }
}

