/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pac.sdk.cp.sar;

import com.taobao.pac.sdk.cp.sar.IClassLoader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ServiceFactory {
    private static IClassLoader classLoader;
    private static Properties services;
    private static String servicesConfig;
    private static Map<Class, Object> servicesCache;

    public static synchronized void init() {
        if (classLoader != null && services != null) {
            return;
        }
        try {
            classLoader = IClassLoader.getInstance();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        services = new Properties();
        Class<ServiceFactory> clazz = ServiceFactory.class;
        try {
            services.load(clazz.getResourceAsStream(servicesConfig));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getService(Class<T> clazz) {
        Class<T> clazz2 = clazz;
        synchronized (clazz2) {
            Class<?> serviceImplClass;
            Object o = servicesCache.get(clazz);
            if (o != null) {
                return (T)o;
            }
            String className = clazz.getName();
            String serviceImpl = services.getProperty(className);
            if (serviceImpl == null || serviceImpl.trim().length() == 0) {
                throw new RuntimeException("\u63a5\u53e3\u6ca1\u6709\u6ce8\u518c\uff1a" + className);
            }
            try {
                serviceImplClass = classLoader.loadClass(serviceImpl);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            T t = null;
            try {
                t = (T)serviceImplClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (t != null) {
                servicesCache.put(clazz, t);
            }
            return t;
        }
    }

    static {
        servicesConfig = "/sar/services.properties";
        servicesCache = new HashMap<Class, Object>();
    }
}

