/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pac.sdk.cp.tenant;

import com.taobao.pac.sdk.cp.ErrorCode;
import com.taobao.pac.sdk.cp.Logger;
import com.taobao.pac.sdk.cp.PacFileItem;
import com.taobao.pac.sdk.cp.PacLogger;
import com.taobao.pac.sdk.cp.RemoteRequestResult;
import com.taobao.pac.sdk.cp.RequestDataObject;
import com.taobao.pac.sdk.cp.ResponseDataObject;
import com.taobao.pac.sdk.cp.SendResult;
import com.taobao.pac.sdk.cp.SendSysParams;
import com.taobao.pac.sdk.cp.SignStrategy;
import com.taobao.pac.sdk.cp.sar.ServiceFactory;
import com.taobao.pac.sdk.cp.services.CodeService;
import com.taobao.pac.sdk.cp.services.HttpService;
import com.taobao.pac.sdk.cp.services.MappingService;
import com.taobao.pac.sdk.cp.services.dto.HttpProxy;
import com.taobao.pac.sdk.cp.services.dto.HttpResult;
import com.taobao.pac.sdk.cp.tenant.LinkLightReceiveListener;
import com.taobao.pac.sdk.cp.tenant.domain.LinkLightReceiveSysParams;
import com.taobao.pac.sdk.cp.tenant.domain.LinkLightSendSysParams;
import com.taobao.pac.sdk.cp.util.Sign;
import com.taobao.pac.sdk.cp.util.ThreadLocalCache;
import com.taobao.pac.sdk.cp.util.ThrowableUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class LinkLightClient {
    private String pacUrl;
    private int sockTimeout = 2000;
    private int fileSockTimeout = 5000;
    private int connectTimeout = 3000;
    private String charset = "utf-8";
    private String secretKey;
    private SignStrategy signStrategy = SignStrategy.md5;
    private String appkey;
    private CodeService codeService;
    private MappingService mappingService;
    private HttpService httpService;
    private Map<String, Object> outHttpParams = null;
    private HttpProxy httpProxy;
    private PacLogger logger = PacLogger.instance;
    private final Map<String, LinkLightReceiveListener> receiveListeners = new HashMap<String, LinkLightReceiveListener>();
    private boolean monitorFlag = false;

    public LinkLightClient(String appkey, String secretKey, String pacUrl) {
        this.appkey = appkey;
        this.secretKey = secretKey;
        this.pacUrl = pacUrl;
        this.init();
    }

    private void init() {
        ServiceFactory.init();
        if (this.appkey == null) {
            throw new IllegalArgumentException("\u5e94\u7528ID\u7684appkey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.secretKey == null) {
            throw new IllegalArgumentException("\u7269\u6d41\u5408\u4f5c\u4f19\u4f34\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7asecretKey");
        }
        if (this.pacUrl == null) {
            throw new IllegalArgumentException("PAC\u7684\u8bbf\u95ee\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7apacUrl");
        }
        this.mappingService = ServiceFactory.getService(MappingService.class);
        if (this.mappingService == null) {
            throw new IllegalArgumentException("Mapping\u63a5\u53e3\uff08mappingService\uff09\u4e0d\u80fd\u4e3anull");
        }
        this.codeService = ServiceFactory.getService(CodeService.class);
        if (this.codeService == null) {
            throw new IllegalArgumentException("\u7f16\u7801\u63a5\u53e3\uff08codeService\uff09\u4e0d\u80fd\u4e3anull");
        }
        this.httpService = ServiceFactory.getService(HttpService.class);
        if (this.httpService == null) {
            throw new IllegalArgumentException("\u7f16\u7801\u63a5\u53e3\uff08httpService\uff09\u4e0d\u80fd\u4e3anull");
        }
    }

    public void registerReceiveListener(String api, LinkLightReceiveListener listener) {
        this.receiveListeners.put(api, listener);
    }

    public <R extends ResponseDataObject> R send(RequestDataObject<R> request2, LinkLightSendSysParams sendSysParams) {
        String content;
        if (request2 == null) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u6570\u636e\u5bf9\u8c61request\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.validate(sendSysParams);
        }
        catch (Exception e) {
            return this.getErrorResponseInstance(request2.getResponseClass(), ErrorCode.illegalParams, e.getMessage());
        }
        try {
            content = this.serializeRequest(request2.getApi(), request2);
        }
        catch (Exception e) {
            SendResult result2 = new SendResult(ErrorCode.other, "request data object serialize exception." + ThrowableUtil.getStackPrint(e));
            return this.getErrorResponseInstance(request2.getResponseClass(), result2.getErrorCode(), result2.getErrorMsg());
        }
        Map<String, String> params = this.getParams(request2.getApi(), content, sendSysParams, request2);
        SendResult<R> result3 = this.sendByGateway(request2, params, sendSysParams.isQllFlag());
        if (!result3.isSuccess()) {
            return this.getErrorResponseInstance(request2.getResponseClass(), result3.getErrorCode(), result3.getErrorMsg());
        }
        return result3.getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends ResponseDataObject> R send(boolean enablePooling, RequestDataObject<R> request2, LinkLightSendSysParams sendSysParams) {
        ThreadLocalCache.put(ThreadLocalCache.Key.ENABLE_POOLING, enablePooling);
        try {
            R r = this.send(request2, sendSysParams);
            return r;
        }
        finally {
            ThreadLocalCache.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R extends ResponseDataObject> SendResult<R> sendByGateway(RequestDataObject<R> request2, Map<String, String> params, boolean qllFlag) {
        R response2;
        String api = request2.getApi();
        try {
            this.serializeRequest(api, request2);
        }
        catch (Exception e) {
            return new SendResult(ErrorCode.other, "request data object serialize exception." + ThrowableUtil.getStackPrint(e));
        }
        if (this.logger.isInfoEnable()) {
            this.logger.info(api + "|sending content:" + params.get("content"));
        }
        RemoteRequestResult remoteRequestResult = null;
        try {
            HttpResult httpResult;
            remoteRequestResult = new RemoteRequestResult();
            String url = this.getPacUrl();
            if (qllFlag) {
                if (!url.contains("?")) {
                    url = url + "?";
                }
                url = url + "&tb_eagleeyex_t=1";
            }
            if (200 == (httpResult = this.httpService.request("post", url, this.getCharset(), this.getSockTimeout(), this.getConnectTimeout(), params, this.outHttpParams, this.httpProxy)).getStatus()) {
                remoteRequestResult.setSuccess(true);
                remoteRequestResult.setContent(httpResult.getContent());
            } else {
                remoteRequestResult.setSuccess(false);
                remoteRequestResult.setErrorMsg("status:" + httpResult.getStatus() + ",body=" + httpResult.getErrorMsg());
            }
        }
        catch (Exception e) {
            SendResult url = new SendResult(ErrorCode.other, ThrowableUtil.getStackPrint(e));
            return url;
        }
        finally {
            if (this.logger.isLogEnable() && remoteRequestResult != null) {
                String sb = "\u76f8\u5173\u53c2\u6570\uff1acharset=" + this.getCharset() + ",secretKey=" + this.getSecretKey() + ",\u8bf7\u6c42\u53c2\u6570\uff1a" + params + ",\u8fd4\u56de\u7ed3\u679c\uff1aresult=" + remoteRequestResult.isSuccess() + ",errorMsg=" + remoteRequestResult.getErrorMsg() + ",content=" + remoteRequestResult.getContent();
                this.logger.error(sb);
            }
        }
        if (!remoteRequestResult.isSuccess()) {
            return new SendResult(ErrorCode.other, remoteRequestResult.getErrorMsg());
        }
        try {
            response2 = this.deserializeResponse(api, remoteRequestResult.getContent());
        }
        catch (Exception e) {
            this.logger.error("Deserialize response error", e);
            return new SendResult(ErrorCode.formatError, remoteRequestResult.getContent());
        }
        if (response2 == null) {
            return new SendResult(ErrorCode.formatError, "\u8fd4\u56de\u62a5\u6587\u8f6c\u5316\u4e3a\u5bf9\u8c61\u7ed3\u679c\u4e3anull\uff0c\u539f\u62a5\u6587\uff1a" + remoteRequestResult.getContent());
        }
        SendResult<R> sendResult = new SendResult<R>();
        sendResult.setSuccess(true);
        sendResult.setResponse(response2);
        return sendResult;
    }

    private Map<String, String> getParams(String api, String content, LinkLightSendSysParams sendSysParams, RequestDataObject request2) {
        HashMap<String, String> params = new HashMap<String, String>();
        String dataDigest = Sign.sign(this.codeService, this.getSecretKey(), this.getCharset(), this.getSignStrategy(), content, request2);
        String fromAppkey = sendSysParams.getFromAppKey();
        if (fromAppkey == null) {
            fromAppkey = this.getAppkey();
        }
        params.put("api_name", api);
        params.put("content", content);
        params.put("data_digest", dataDigest);
        params.put("from_code", sendSysParams.getFromCode());
        params.put("to_code", sendSysParams.getToCode());
        params.put("from_appkey", fromAppkey);
        params.put("to_appkey", sendSysParams.getToAppKey());
        return params;
    }

    private void validate(SendSysParams sendSysParams) throws IllegalArgumentException {
        if (sendSysParams == null) {
            throw new IllegalArgumentException("SendSysParams \u4e3a\u7a7a");
        }
        if (sendSysParams.getFromCode() == null) {
            throw new IllegalArgumentException("fromCode \u4e3a\u7a7a");
        }
    }

    public String receive(LinkLightReceiveSysParams receiveSysParams) {
        Object response2;
        RequestDataObject request2;
        String api = receiveSysParams.getApiName();
        String dataDigest = receiveSysParams.getDataDigest();
        String content = receiveSysParams.getContent();
        LinkLightReceiveListener listener = this.receiveListeners.get(api);
        if (listener == null) {
            return this.getSysErrorResponse(ErrorCode.other, "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u76d1\u542c\u5904\u7406\u5668\uff1aapi=" + api);
        }
        try {
            request2 = this.deserializeRequest(api, content);
        }
        catch (Exception e) {
            return this.getSysErrorResponse(ErrorCode.formatError, "\u6570\u636e\u62a5\u6587\u53cd\u5e8f\u5217\u5316\u5931\u8d25\uff0c" + e.getMessage());
        }
        try {
            String differentSign = this.verify(content, dataDigest, request2);
            if (differentSign != null) {
                return this.getSysErrorResponse(ErrorCode.illegalSign, "\u7cfb\u7edf\u7b7e\u540d\uff1a" + differentSign + "\uff0c\u5916\u90e8\u7b7e\u540d\uff1a" + dataDigest);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.getSysErrorResponse(ErrorCode.illegalSign, "\u9a8c\u7b7e\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38...");
        }
        try {
            response2 = listener.execute(receiveSysParams, request2);
        }
        catch (Exception e) {
            return this.getSysErrorResponse(ErrorCode.partnerDealException, "\u8c03\u7528\u7269\u6d41\u5408\u4f5c\u5408\u4f5c\u4f19\u4f34\u7684\u76d1\u542c\u5904\u7406\u5668\u65f6\u5f02\u5e38\uff0c" + e.getMessage());
        }
        try {
            return this.serializeResponse(api, (ResponseDataObject)response2);
        }
        catch (Exception e) {
            return this.getSysErrorResponse(ErrorCode.formatError, "\u8fd4\u56de\u5bf9\u8c61\u5e8f\u5217\u5316\u5f02\u5e38\uff0c" + e.getMessage());
        }
    }

    private String verify(String content, String dataDigest, RequestDataObject request2) throws Exception {
        String sign = request2 == null ? Sign.sign(this.codeService, this.getSignStrategy(), (content + this.getSecretKey()).getBytes(this.getCharset()), this.getCharset()) : Sign.sign(this.codeService, this.getSecretKey(), this.getCharset(), this.getSignStrategy(), content, request2);
        if (dataDigest.equals(sign)) {
            return null;
        }
        return "\u7b7e\u540d\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u7cfb\u7edf\u7b7e\u540d\uff1a" + sign + "\uff0c\u5916\u90e8\u7b7e\u540d\uff1a" + dataDigest;
    }

    public String getSysErrorResponse(ErrorCode errorCode, String errorMsg) {
        return "<response><success>false</success><errorCode>" + errorCode.getAlias() + "</errorCode><errorMsg><![CDATA[" + errorCode.getDesc() + ":" + errorMsg + "]]></errorMsg></response>";
    }

    public <R extends ResponseDataObject> String serializeRequest(String api, RequestDataObject<R> request2) throws Exception {
        return this.mappingService.serializeRequest(api, request2);
    }

    public <R extends ResponseDataObject> R deserializeResponse(String api, String responseContent) throws Exception {
        return (R)((ResponseDataObject)this.mappingService.deserializeResponse(api, responseContent));
    }

    public RequestDataObject deserializeRequest(String api, String content) throws Exception {
        return (RequestDataObject)this.mappingService.deserializeRequest(api, content);
    }

    public String serializeResponse(String api, ResponseDataObject response2) {
        try {
            return this.mappingService.serializeResponse(api, response2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, PacFileItem> parseFileRequest(HttpServletRequest req, Map<String, String> params) {
        return this.httpService.parseFileRequest(req, params);
    }

    public int getSockTimeout() {
        return this.sockTimeout;
    }

    public void setSockTimeout(int sockTimeout) {
        this.sockTimeout = sockTimeout;
    }

    public int getFileSockTimeout() {
        return this.fileSockTimeout;
    }

    public void setFileSockTimeout(int fileSockTimeout) {
        this.fileSockTimeout = fileSockTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public CodeService getCodeService() {
        return this.codeService;
    }

    public MappingService getMappingService() {
        return this.mappingService;
    }

    public String getPacUrl() {
        return this.pacUrl;
    }

    public void setPacUrl(String pacUrl) {
        this.pacUrl = pacUrl;
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public SignStrategy getSignStrategy() {
        return this.signStrategy;
    }

    public void setSignStrategy(SignStrategy signStrategy) {
        this.signStrategy = signStrategy;
    }

    public void setPacLogger(PacLogger logger) {
        this.logger = logger;
        Logger.logger = logger;
    }

    public PacLogger getLogger() {
        return this.logger;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getAppkey() {
        return this.appkey;
    }

    public HttpService getHttpService() {
        return this.httpService;
    }

    public boolean isMonitorFlag() {
        return this.monitorFlag;
    }

    public Map<String, Object> getOutHttpParams() {
        return this.outHttpParams;
    }

    public void setOutHttpParams(Map<String, Object> outHttpParams) {
        this.outHttpParams = outHttpParams;
    }

    public void setMonitorFlag(boolean monitorFlag) {
        this.monitorFlag = monitorFlag;
    }

    private <R extends ResponseDataObject> R getErrorResponseInstance(Class<R> clazz, ErrorCode errorCode, String errorMsg) {
        return this.getErrorResponseInstance(clazz, errorCode.getAlias(), errorMsg);
    }

    private <R extends ResponseDataObject> R getErrorResponseInstance(Class<R> clazz, String errorCode, String errorMsg) {
        ResponseDataObject response2;
        try {
            response2 = (ResponseDataObject)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        response2.setSuccess(false);
        response2.setErrorCode(errorCode);
        response2.setErrorMsg(errorMsg);
        return (R)response2;
    }

    public HttpProxy getHttpProxy() {
        return this.httpProxy;
    }

    public void setHttpProxy(HttpProxy httpProxy) {
        this.httpProxy = httpProxy;
    }
}

