/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pac.sdk.cp.tenant;

import com.taobao.pac.sdk.cp.ErrorCode;
import com.taobao.pac.sdk.cp.PacLogger;
import com.taobao.pac.sdk.cp.tenant.LinkLightClient;
import com.taobao.pac.sdk.cp.tenant.domain.LinkLightReceiveSysParams;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LinkLightServlet
extends HttpServlet {
    private static final long serialVersionUID = -6562702371933707885L;
    private String sysCharset;
    private PacLogger logger;
    private LinkLightClient lightClient;
    private String responseContentType;

    public void init() {
        if (this.lightClient == null) {
            throw new RuntimeException("lightClient can't be null in LinkLightServlet");
        }
        this.sysCharset = this.lightClient.getCharset();
        this.logger = this.lightClient.getLogger();
        this.responseContentType = "text/html;charset=" + this.sysCharset;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        long startTime = System.currentTimeMillis();
        String ip = req.getRemoteHost();
        req.setCharacterEncoding(this.sysCharset);
        resp.setCharacterEncoding(this.sysCharset);
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration enumeration = req.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = req.getParameter(key);
            params.put(key, value);
        }
        String qllTag = (String)params.get("t");
        if (qllTag != null) {
            this.eagleEyeTag("1".equals(qllTag));
        }
        qllTag = (String)params.get("tb_eagleeyex_t");
        boolean qllFlag = false;
        if (qllTag != null && "1".equals(qllTag)) {
            qllFlag = true;
            this.eagleEyeTag(qllFlag);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\u8fdc\u7a0bIP::");
        sb.append(ip);
        sb.append(" \u63a5\u6536\u8bf7\u6c42\u53c2\u6570::").append(params);
        String msgId = (String)params.get("msg_id");
        String api = (String)params.get("api_name");
        String dataDigest = (String)params.get("data_digest");
        String content = (String)params.get("content");
        String toCode = (String)params.get("to_code");
        String fromCode = (String)params.get("from_code");
        String fromAppKey = (String)params.get("from_appkey");
        String toAppKey = (String)params.get("to_appkey");
        Throwable isThrow = null;
        try {
            String result2;
            if (api == null || api.trim().length() == 0) {
                String errorMsg = "\u7cfb\u7edf\u53c2\u6570api_name\u4e3a\u7a7a";
                this.print(sb, resp, this.getSysErrorResponse(ErrorCode.illegalParams, errorMsg));
                return;
            }
            if (dataDigest == null || dataDigest.trim().length() == 0) {
                String errorMsg = "\u7cfb\u7edf\u53c2\u6570data_digest\u4e3a\u7a7a";
                this.print(sb, resp, this.getSysErrorResponse(ErrorCode.illegalParams, errorMsg));
                return;
            }
            if (content == null || content.trim().length() == 0) {
                String errorMsg = "\u7cfb\u7edf\u53c2\u6570content\u4e3a\u7a7a";
                this.print(sb, resp, this.getSysErrorResponse(ErrorCode.illegalParams, errorMsg));
                return;
            }
            if (toCode == null || toCode.trim().length() == 0) {
                String errorMsg = "\u7cfb\u7edf\u53c2\u6570to_code\u4e3a\u7a7a";
                this.print(sb, resp, this.getSysErrorResponse(ErrorCode.illegalParams, errorMsg));
                return;
            }
            if (fromAppKey == null || fromAppKey.trim().length() == 0) {
                String errorMsg = "\u7cfb\u7edf\u53c2\u6570from_appkey\u4e3a\u7a7a";
                this.print(sb, resp, this.getSysErrorResponse(ErrorCode.illegalParams, errorMsg));
                return;
            }
            if (toAppKey == null || toAppKey.trim().length() == 0) {
                String errorMsg = "\u7cfb\u7edf\u53c2\u6570to_appkey\u4e3a\u7a7a";
                this.print(sb, resp, this.getSysErrorResponse(ErrorCode.illegalParams, errorMsg));
                return;
            }
            try {
                LinkLightReceiveSysParams receiveSysParams = new LinkLightReceiveSysParams();
                receiveSysParams.setMsgId(msgId);
                receiveSysParams.setApiName(api);
                receiveSysParams.setDataDigest(dataDigest);
                receiveSysParams.setContent(content);
                receiveSysParams.setToCode(toCode);
                receiveSysParams.setFromCode(fromCode);
                receiveSysParams.setToAppKey(toAppKey);
                receiveSysParams.setFromAppKey(fromAppKey);
                receiveSysParams.setQllFlag(qllFlag);
                result2 = this.lightClient.receive(receiveSysParams);
            }
            catch (Exception e) {
                String errorMsg = "\u53d1\u751f\u4e0d\u9884\u671f\u7684\u5f02\u5e38\uff1a" + e.getMessage();
                this.print(sb, resp, this.getSysErrorResponse(ErrorCode.other, errorMsg));
                long endTime = System.currentTimeMillis();
                sb.append(" \u8017\u65f6::" + (endTime - startTime));
                if (isThrow != null) {
                    this.logger.error(sb.toString());
                } else if (this.logger.isLogEnable() && this.logger.isInfoEnable()) {
                    this.logger.info(sb.toString());
                }
                return;
            }
            this.print(sb, resp, result2);
        }
        catch (Throwable e) {
            isThrow = e;
            if (this.logger.isLogEnable()) {
                this.logger.error("\u5f02\u5e38", e);
            }
            sb.append(" [ERROR]\u5f02\u5e38::" + e.getMessage());
            this.print(resp, sb.toString());
        }
        finally {
            long endTime = System.currentTimeMillis();
            sb.append(" \u8017\u65f6::" + (endTime - startTime));
            if (isThrow != null) {
                this.logger.error(sb.toString());
            } else if (this.logger.isLogEnable() && this.logger.isInfoEnable()) {
                this.logger.info(sb.toString());
            }
        }
    }

    private String getSysErrorResponse(ErrorCode errorCode, String errorMsg) {
        return this.lightClient.getSysErrorResponse(errorCode, errorMsg);
    }

    private void print(StringBuilder sb, HttpServletResponse resp, String msg) throws IOException {
        sb.append(" \u8fd4\u56de\uff1a" + msg);
        this.print(resp, msg);
    }

    private void print(HttpServletResponse resp, String msg) throws IOException {
        resp.setHeader("Content-type", this.responseContentType);
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(msg);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public void setLightClient(LinkLightClient lightClient) {
        this.lightClient = lightClient;
    }

    private void eagleEyeTag(boolean qllTag) {
        if (qllTag) {
            try {
                Class<?> eagleEyleClass = Class.forName("com.taobao.eagleeye.EagleEye");
                Method putMethod = eagleEyleClass.getDeclaredMethod("putUserData", String.class, String.class);
                putMethod.invoke(eagleEyleClass, "t", "1");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

