/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pac.sdk.cp.util;

import com.taobao.pac.sdk.cp.FileUploadRequest;
import com.taobao.pac.sdk.cp.PacFileItem;
import com.taobao.pac.sdk.cp.RequestDataObject;
import com.taobao.pac.sdk.cp.SignStrategy;
import com.taobao.pac.sdk.cp.services.CodeService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Sign {
    public static String sign(CodeService codeService, SignStrategy signStrategy, byte[] binaryData, String charset) {
        if (signStrategy == null) {
            signStrategy = SignStrategy.md5;
        }
        if (signStrategy.equals((Object)SignStrategy.md5)) {
            try {
                return new String(codeService.base64(codeService.md5(binaryData)), charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("exception where sign.", e);
            }
        }
        if (signStrategy.equals((Object)SignStrategy.md54wlb)) {
            try {
                return new String(codeService.base64(codeService.md54wlb(binaryData)), charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("exception where sign.", e);
            }
        }
        throw new RuntimeException("Not support sign strategy :" + (Object)((Object)signStrategy));
    }

    public static String sign(CodeService codeService, String secretKey, String charset, SignStrategy signStrategy, String content, RequestDataObject request2) {
        String dataDigest;
        if (request2 instanceof FileUploadRequest) {
            List<PacFileItem> fileList = ((FileUploadRequest)request2).getListFile();
            Collections.sort(fileList, new Comparator<PacFileItem>(){

                @Override
                public int compare(PacFileItem arg0, PacFileItem arg1) {
                    int i = arg0.getFileName().compareToIgnoreCase(arg1.getFileName());
                    if (i != 0) {
                        return i;
                    }
                    try {
                        int size0 = arg0.getContent() == null ? 0 : arg0.getContent().length;
                        int size1 = arg1.getContent() == null ? 0 : arg1.getContent().length;
                        return size0 - size1;
                    }
                    catch (Exception e) {
                        return 0;
                    }
                }
            });
            try {
                byte[] byteToDigest = content.getBytes(charset);
                for (PacFileItem file : fileList) {
                    try {
                        byteToDigest = Sign.byteMerger(byteToDigest, file.getContent());
                    }
                    catch (IOException e) {
                        throw new RuntimeException("exception where sign.", e);
                    }
                }
                byteToDigest = Sign.byteMerger(byteToDigest, secretKey.getBytes(charset));
                dataDigest = Sign.sign(codeService, signStrategy, byteToDigest, charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("exception where sign.", e);
            }
            finally {
                Object byteToDigest = null;
            }
        }
        try {
            dataDigest = Sign.sign(codeService, signStrategy, (content + secretKey).getBytes(charset), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("exception where sign.", e);
        }
        return dataDigest;
    }

    private static byte[] byteMerger(byte[] byte_1, byte[] byte_2) {
        if (byte_1 == null || byte_1.length == 0) {
            return byte_2;
        }
        if (byte_2 == null || byte_2.length == 0) {
            return byte_1;
        }
        byte[] byte_3 = new byte[byte_1.length + byte_2.length];
        System.arraycopy(byte_1, 0, byte_3, 0, byte_1.length);
        System.arraycopy(byte_2, 0, byte_3, byte_1.length, byte_2.length);
        return byte_3;
    }
}

