/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pac.sdk.cp.util;

import java.util.HashMap;
import java.util.Map;

public class ThreadLocalCache {
    private static final ThreadLocal<Map<Key, Object>> CACHE = new ThreadLocal<Map<Key, Object>>(){

        @Override
        protected Map<Key, Object> initialValue() {
            return new HashMap<Key, Object>();
        }
    };

    public static Object put(Key key, Object value) {
        return CACHE.get().put(key, value);
    }

    public static Object get(Key key) {
        return CACHE.get().get((Object)key);
    }

    public static <T> T get(Key key, Class<T> valueClass) {
        return valueClass.cast(ThreadLocalCache.get(key));
    }

    public static void remove() {
        CACHE.remove();
    }

    public static void clear() {
        CACHE.get().clear();
    }

    public static enum Key {
        ENABLE_POOLING;

    }
}

