/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.process.api.factory;

import com.f2bpm.base.core.app.AppConfig;
import com.f2bpm.base.core.utils.AppUtil;
import com.f2bpm.base.core.utils.CollectionUtil;
import com.f2bpm.base.core.utils.string.StringUtil;
import com.f2bpm.process.engine.api.enums.FindRelationLabelStopType;
import com.f2bpm.process.engine.api.wapi.IWorkflowWAPIService;
import com.f2bpm.process.org.api.enums.GroupType;
import com.f2bpm.process.org.api.integrate.imodel.IGroup;
import com.f2bpm.process.org.api.integrate.imodel.IUser;
import com.f2bpm.system.security.factory.OrgEngineFactory;
import java.util.ArrayList;
import java.util.List;

public class OrganizationHelper {
    public static IUser getLoginUserByAccount(String tenantId, String account, String loginOrgId) {
        IUser loginUser = null;
        if (!StringUtil.isNullOrWhiteSpace((String)account)) {
            IUser user = OrgEngineFactory.getOrgEngine().getUserService().getUserByAccount(tenantId, account);
            if (StringUtil.isNotEmpty((String)loginOrgId)) {
                IGroup orgGroup = OrgEngineFactory.getOrgEngine().getGroupService().getGroupById(tenantId, loginOrgId, GroupType.org.toString());
                user.setOrgId(orgGroup.getGroupId());
                user.setOrgCode(orgGroup.getGroupCode());
                user.setOrgName(orgGroup.getGroupName());
                user.setOrgFullName(orgGroup.getGroupFullName());
            }
            loginUser = user;
        }
        return loginUser;
    }

    public static IUser getLoginUserByUserId(String userId, String orgId) {
        IUser loginUser = null;
        loginUser = StringUtil.isNotEmpty((String)userId) && StringUtil.isNotEmpty((String)orgId) ? OrgEngineFactory.getOrgEngine().getUserService().getUserByIdOrgId(userId, orgId) : OrgEngineFactory.getOrgEngine().getUserService().getUserById(userId);
        return loginUser;
    }

    public static IUser getIUserByAccount(String tenantId, String account) {
        IUser user = null;
        if (!StringUtil.isNullOrWhiteSpace((String)account)) {
            user = OrgEngineFactory.getOrgEngine().getUserService().getUserByAccount(tenantId, account);
        }
        return user;
    }

    public static IUser getIUserByUserId(String userId) {
        IUser user = null;
        if (!StringUtil.isNullOrWhiteSpace((String)userId)) {
            user = OrgEngineFactory.getOrgEngine().getUserService().getUserById(userId);
        }
        return user;
    }

    public static boolean haveOrgLevels(String tenantId, String orgId, List<String> orgLevelList) {
        boolean canExcute = false;
        if (StringUtil.isNullOrWhiteSpace((String)orgId) || CollectionUtil.isNullOrWhiteSpace(orgLevelList)) {
            return false;
        }
        IWorkflowWAPIService wapi = (IWorkflowWAPIService)AppUtil.getBean((String)"WorkflowAPI");
        IGroup group = wapi.getOrgEngineManager().getGroupService().getGroupById(tenantId, orgId, GroupType.org.toString());
        String currOrgLevels = group.getLevels();
        List currlevelList = CollectionUtil.stringToIList((String)currOrgLevels);
        for (String levelflag : orgLevelList) {
            if (!currlevelList.contains(levelflag)) continue;
            canExcute = true;
            break;
        }
        return canExcute;
    }

    public static List<IGroup> getLatHaveOrgLevelsInAllParentOrgs(String orgId, String orgFullCode, String tenantId, List<String> orgLevelList, String findRelationLabelStopType, boolean isContainerMySelf) {
        IWorkflowWAPIService wapi = (IWorkflowWAPIService)AppUtil.getBean((String)"WorkflowAPI");
        String startIdValue = orgId;
        String searchFieldName = "levels";
        List listAll = null;
        String idFileName = "groupId";
        String parentFieldName = "parentId";
        if (StringUtil.isNotEmpty((String)orgFullCode)) {
            String orgFullCodeSeparator = AppConfig.getApp((String)"orgFullCodeSeparator");
            List listCode = CollectionUtil.stringToIList((String)orgFullCode, (String)orgFullCodeSeparator, (boolean)false);
            ArrayList<String> listCode2 = new ArrayList<String>();
            ArrayList<String> listInCode = new ArrayList<String>();
            for (String code : listCode) {
                if (!StringUtil.isNotEmpty((String)code)) continue;
                listCode2.add(code);
            }
            int n = listCode2.size();
            for (int i = 0; i < n; ++i) {
                StringBuilder itemStr = new StringBuilder();
                itemStr.append(orgFullCodeSeparator);
                for (int j = 0; j <= i; ++j) {
                    itemStr.append((String)listCode2.get(j));
                    itemStr.append(orgFullCodeSeparator);
                }
                listInCode.add(itemStr.toString());
            }
            String inOrgFullCodes = CollectionUtil.list2StringAndSinglequote(listInCode);
            listAll = wapi.getOrgEngineManager().getGroupService().getGroupListByInFullCode(tenantId, inOrgFullCodes, GroupType.org.toString());
            if (StringUtil.isNotEmpty((String)findRelationLabelStopType) && findRelationLabelStopType.equalsIgnoreCase(FindRelationLabelStopType.allOrgUserInRoles.toString())) {
                return listAll;
            }
        } else {
            listAll = wapi.getOrgEngineManager().getGroupService().getAllGroup(tenantId, GroupType.org.toString());
            if (StringUtil.isNotEmpty((String)findRelationLabelStopType) && findRelationLabelStopType.equalsIgnoreCase(FindRelationLabelStopType.allOrgUserInRoles.toString())) {
                ArrayList<IGroup> listResult = new ArrayList<IGroup>();
                CollectionUtil.getParentList((List)listAll, (String)startIdValue, (boolean)isContainerMySelf, (String)idFileName, (String)parentFieldName, listResult);
                return listResult;
            }
        }
        String searchFieldValue = CollectionUtil.list2String(orgLevelList);
        boolean isLikeSearch = false;
        boolean searchValueIsDotSplit = true;
        boolean stopIffound = StringUtil.isEmpty((String)findRelationLabelStopType) || findRelationLabelStopType.equalsIgnoreCase(FindRelationLabelStopType.first.toString());
        ArrayList<IGroup> listResult = new ArrayList<IGroup>();
        CollectionUtil.getParentListSearch((List)listAll, (String)startIdValue, (String)searchFieldName, (String)searchFieldValue, (boolean)isLikeSearch, (boolean)searchValueIsDotSplit, (boolean)stopIffound, (String)idFileName, (String)parentFieldName, listResult);
        return listResult;
    }

    public static List<IGroup> getLatHaveOrgLevelsInAllChildOrgs(String orgId, String orgFullCode, String tenantId, List<String> orgLevelList, String findRelationLabelStopType, boolean isContainerMySelf) {
        IWorkflowWAPIService wapi = (IWorkflowWAPIService)AppUtil.getBean((String)"WorkflowAPI");
        String idFileName = "groupId";
        String parentFieldName = "parentId";
        String startIdValue = orgId;
        List listAll = null;
        if (StringUtil.isNotEmpty((String)orgFullCode)) {
            listAll = wapi.getOrgEngineManager().getGroupService().getGroupListByLikeFullCode(tenantId, orgFullCode, GroupType.org.toString());
            if (StringUtil.isNotEmpty((String)findRelationLabelStopType) && findRelationLabelStopType.equalsIgnoreCase(FindRelationLabelStopType.allOrgUserInRoles.toString())) {
                return listAll;
            }
        } else {
            listAll = wapi.getOrgEngineManager().getGroupService().getAllGroup(tenantId, GroupType.org.toString());
            if (StringUtil.isNotEmpty((String)findRelationLabelStopType) && findRelationLabelStopType.equalsIgnoreCase(FindRelationLabelStopType.allOrgUserInRoles.toString())) {
                ArrayList<IGroup> listResult = new ArrayList<IGroup>();
                CollectionUtil.getChildList((List)listAll, (String)startIdValue, (boolean)isContainerMySelf, (String)idFileName, (String)parentFieldName, listResult);
                return listResult;
            }
        }
        String searchFieldName = "levels";
        String searchFieldValue = CollectionUtil.list2String(orgLevelList);
        boolean isLikeSearch = false;
        boolean searchValueIsDotSplit = true;
        boolean stopIffound = StringUtil.isEmpty((String)findRelationLabelStopType) || findRelationLabelStopType.equalsIgnoreCase(FindRelationLabelStopType.first.toString());
        ArrayList<IGroup> listResult = new ArrayList<IGroup>();
        CollectionUtil.getChidlListSearch((List)listAll, (String)startIdValue, (String)searchFieldName, (String)searchFieldValue, (boolean)isLikeSearch, (boolean)searchValueIsDotSplit, (boolean)stopIffound, (String)idFileName, (String)parentFieldName, listResult);
        return listResult;
    }
}

