/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.process.api.factory;

import com.f2bpm.base.core.entity.KeyValue;
import com.f2bpm.base.core.entity.TreeNode;
import com.f2bpm.base.core.enums.NameValueItem;
import com.f2bpm.base.core.utils.AppUtil;
import com.f2bpm.base.core.utils.CollectionUtil;
import com.f2bpm.base.core.utils.JsonHelper;
import com.f2bpm.base.core.utils.string.StringUtil;
import com.f2bpm.base.core.utils.time.DateUtil;
import com.f2bpm.process.engine.api.entity.WorkflowContext;
import com.f2bpm.process.engine.api.enums.WorkflowInstanceState;
import com.f2bpm.process.engine.api.iservices.IProcessVarInstService;
import com.f2bpm.process.engine.api.iservices.ISimulationParamsService;
import com.f2bpm.process.engine.api.model.ProcessVarInst;
import com.f2bpm.process.engine.api.model.SimulationParams;
import com.f2bpm.process.smartForm.api.entity.BusObjectData;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TranslateHelper {
    public static ArrayList<TreeNode> getWfContextVarsTreeNodeList() {
        Map<String, String> dic = TranslateHelper.getWfContextVars();
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        TreeNode node = new TreeNode();
        node.setId("WfContextVars");
        node.setPid("Root");
        node.setState("open");
        node.setAttributes("");
        node.setText("\u6d41\u7a0b\u4e0a\u4e0b\u6587\u53d8\u91cf");
        list.add(node);
        for (String key : dic.keySet()) {
            String text = dic.get(key);
            node = new TreeNode();
            node.setId(key);
            node.setPid("WfContextVars");
            node.setText(StringUtil.format((String)"{0}[{1}]", (Object[])new Object[]{key, text}));
            node.setAttributes(StringUtil.format((String)"{varName:'{0}',varText:'{1}',dataType:'{2}',sourceType:'{3}'}", (Object[])new Object[]{key, text, "String", "WfContextVars"}));
            list.add(node);
        }
        return list;
    }

    public static Map<String, String> getWfContextVars() {
        HashMap<String, String> dic = new HashMap<String, String>();
        dic.put("SheetId", "\u6d41\u7a0b\u5355\u53f7");
        dic.put("Wiid", "\u6d41\u7a0b\u5b9e\u4f8bID");
        dic.put("TaskId", "\u4efb\u52a1\u5b9e\u4f8bID");
        dic.put("BusinessKey", "\u4e1a\u52a1\u952e");
        dic.put("FormId", "\u8868\u5355\u5b9a\u4e49ID");
        dic.put("Aiid", "\u5f53\u524d\u6d3b\u52a8\u5b9e\u4f8bID");
        dic.put("CurrentActivityId", "\u5f53\u524d\u8282\u70b9ID");
        dic.put("CurrentActivityName", "\u5f53\u524d\u8282\u70b9\u540d\u79f0");
        dic.put("CurrentActivityCode", "\u5f53\u524d\u8282\u70b9\u7f16\u7801");
        dic.put("AppId", "\u6d41\u7a0b\u5e94\u7528ID");
        dic.put("WorkflowName", "\u6d41\u7a0b\u540d\u79f0");
        dic.put("ProcInstCreatorId", "\u6d41\u7a0b\u53d1\u8d77\u4eba\u7684UserId");
        dic.put("ProcInstCreatorRealName", "\u6d41\u7a0b\u53d1\u8d77\u4eba\u59d3\u540d");
        dic.put("StartedTime", "\u53d1\u8d77\u65f6\u95f4");
        dic.put("FinishedTime", "\u7ed3\u675f\u65f6\u95f4");
        dic.put("CurrentUserId", "\u5f53\u524d\u767b\u5f55\u4ebaID");
        dic.put("CurrentAccount", "\u5f53\u524d\u767b\u5f55\u4eba\u8d26\u53f7");
        dic.put("CurrentRealname", "\u5f53\u524d\u767b\u5f55\u4eba\u59d3\u540d");
        dic.put("CurrentOrgId", "\u5f53\u524d\u767b\u4eba\u90e8\u95e8ID");
        dic.put("CurrentOrgName", "\u5f53\u524d\u767b\u4eba\u90e8\u95e8\u540d\u79f0");
        dic.put("CurrentDate", "\u5f53\u524d\u65e5\u671f");
        dic.put("CurrentDateTime", "\u5f53\u524d\u65e5\u671f\u65f6\u95f4");
        return dic;
    }

    public static String getWfContextVarValue(String varName, WorkflowContext wfContext) {
        if (varName.equals("Wiid")) {
            return wfContext.getCurrentWorkflowInstinceId();
        }
        if (varName.equals("TaskId")) {
            return wfContext.getCurrentTaskId();
        }
        if (varName.equals("Aiid")) {
            return wfContext.getCurrentActivityInstance().getActivityInstanceId();
        }
        if (varName.equals("CurrentActivityId")) {
            return wfContext.getCurrentActivity().getActivityId();
        }
        if (varName.equals("BusinessKey")) {
            return wfContext.getCurrentProcessInstance().getBusinessKey();
        }
        if (varName.equals("FormId")) {
            return wfContext.getCurrentProcessInstance().getFormId();
        }
        if (varName.equals("CurrentActivityName")) {
            return wfContext.getCurrentActivity().getActivityName();
        }
        if (varName.equals("CurrentActivityCode")) {
            return wfContext.getCurrentActivity().getActivityCode();
        }
        if (varName.equals("StartedTime")) {
            return DateUtil.formatDateTime((Date)wfContext.getCurrentProcessInstance().getStartedTime());
        }
        if (varName.equals("FinishedTime")) {
            return wfContext.getCurrentProcessInstance().getWorkflowInstanceState() == WorkflowInstanceState.Completed.getIntValue() ? DateUtil.getDateTimeString((Date)wfContext.getCurrentProcessInstance().getFinishedTime()) : "";
        }
        if (varName.equals("ProcInstCreatorId")) {
            return wfContext.getCurrentProcessInstance().getCreatorId();
        }
        if (varName.equals("ProcInstCreatorRealName")) {
            return wfContext.getCurrentProcessInstance().getCreatorRealName();
        }
        if (varName.equals("AppId")) {
            return wfContext.getAppId();
        }
        if (varName.equals("AppName") || varName.equalsIgnoreCase("WorkflowName")) {
            String appName = wfContext.getCurrentWorkflowInfo().getAppName();
            return appName;
        }
        if (varName.equals("SheetId")) {
            return wfContext.getCurrentSheetId();
        }
        if (varName.equals("CurrentTenantId")) {
            return wfContext.getCurrentUser().getTenantId();
        }
        if (varName.equals("CurrentUserId")) {
            return wfContext.getCurrentUser().getUserId();
        }
        if (varName.equals("CurrentAccount")) {
            return wfContext.getCurrentUser().getAccount();
        }
        if (varName.equals("CurrentRealname")) {
            return wfContext.getCurrentUser().getRealName();
        }
        if (varName.equals("CurrentUserOrgId")) {
            return wfContext.getCurrentUser().getOrgId();
        }
        if (varName.equals("CurrentUserOrgName")) {
            return wfContext.getCurrentUser().getOrgName();
        }
        if (varName.equals("CurrentDate")) {
            return DateUtil.getCurrentDateStr();
        }
        if (varName.equals("CurrentDateTime")) {
            return DateUtil.getCurrentDateTime((String)"yyyy-MM-dd HH:mm:ss");
        }
        Map otherProperty = wfContext.getCurrentUser().getOtherProperty();
        if (otherProperty != null && otherProperty.size() > 0 && otherProperty.keySet().contains(varName)) {
            return (String)otherProperty.get(varName);
        }
        return "";
    }

    public static String translateByWfContextVariables(String content, WorkflowContext wfContext) {
        return TranslateHelper.translateByWfContextVariables(content, wfContext, "\"");
    }

    public static String translateByWfContextVariablesUnsigned(String content, WorkflowContext wfContext) {
        return TranslateHelper.translateByWfContextVariables(content, wfContext, "");
    }

    public static String translateByWfContextVariables(String content, WorkflowContext wfContext, String symbolsChar) {
        if (StringUtil.isNotContainVarParams((String)content)) {
            return content;
        }
        Map<String, String> contextsMap = TranslateHelper.getWfContextVars();
        Map varsMap = StringUtil.getPatternsVariable((String)content);
        for (String key : varsMap.keySet()) {
            if (!contextsMap.containsKey(key)) continue;
            String value = TranslateHelper.getWfContextVarValue(key, wfContext);
            String var = (String)varsMap.get(key);
            if (!StringUtil.isNotContainVarParams((String)(content = StringUtil.replaceParams((String)content, (String)var, (String)value, (String)symbolsChar)))) continue;
            break;
        }
        return content;
    }

    public static String translateByProcessVariablesJson(String content, String processVariablesJson, String symbolsChar) {
        if (StringUtil.isEmpty((String)content)) {
            return content;
        }
        if (StringUtil.isEmpty((String)processVariablesJson)) {
            return content;
        }
        HashMap<String, Object> mapVars = new HashMap<String, Object>();
        List list = JsonHelper.jsonArrToObject((String)processVariablesJson, KeyValue.class);
        for (KeyValue kv : list) {
            mapVars.put(kv.getKey(), kv.getValue());
        }
        String expressContent = content;
        if (mapVars != null && mapVars.size() > 0 && !TranslateHelper.ExpressIsOk(expressContent)) {
            for (String key : mapVars.keySet()) {
                String keyVar = StringUtil.format((String)"#{0}#", (Object[])new Object[]{key});
                String keyVVar = StringUtil.format((String)"${0}$", (Object[])new Object[]{key});
                if (mapVars.get(key) == null) continue;
                if (expressContent.indexOf(keyVVar) > -1) {
                    expressContent = expressContent.replace(keyVVar, mapVars.get(key).toString());
                    continue;
                }
                expressContent = StringUtil.replaceParams((String)expressContent, (String)keyVar, (String)mapVars.get(key).toString(), (String)symbolsChar);
            }
        }
        return expressContent;
    }

    public static boolean ExpressIsOk(String expressContent) {
        return expressContent.indexOf("#") <= -1 && expressContent.indexOf("$") <= -1;
    }

    public static String translateByProcInstVariables(String content, String wiid) {
        return TranslateHelper.translateByProcInstVariables(content, wiid, "\"");
    }

    public static String translateByProcInstVariables(String content, String wiid, String symbolsChar) {
        if (StringUtil.isNotContainVarParams((String)content)) {
            return content;
        }
        List<ProcessVarInst> listInstVar = ((IProcessVarInstService)AppUtil.getBean(IProcessVarInstService.class)).getListByProcInstId(wiid);
        if (CollectionUtil.isNullOrWhiteSpace(listInstVar)) {
            return content;
        }
        Map varsMap = StringUtil.getPatternsVariable((String)content);
        for (ProcessVarInst varInst : listInstVar) {
            String value;
            String key = varInst.getVarName();
            if (!varsMap.containsKey(key)) continue;
            String string = value = varInst.getVarValue() == null ? "" : varInst.getVarValue().toString();
            String var = (String)varsMap.get(key);
            if (!StringUtil.isNotContainVarParams((String)(content = StringUtil.replaceParams((String)content, (String)var, (String)value, (String)symbolsChar)))) continue;
            break;
        }
        return content;
    }

    public static String translateBySimulationVariables(String content, String appId, String tenantId, String symbolsChar) {
        if (StringUtil.isNotContainVarParams((String)content)) {
            return content;
        }
        SimulationParams simulationParams = ((ISimulationParamsService)AppUtil.getBean(ISimulationParamsService.class)).getModelByAppId(tenantId, appId);
        if (simulationParams == null || StringUtil.isEmpty((String)simulationParams.getVars())) {
            return content;
        }
        Map varsMap = StringUtil.getPatternsVariable((String)content);
        ArrayList listAll = new ArrayList();
        List listInstVar = JsonHelper.jsonArrToObject((String)simulationParams.getVars(), KeyValue.class);
        List listFormFieldVar = JsonHelper.jsonArrToObject((String)simulationParams.getFormFieldParms(), KeyValue.class);
        ArrayList listAllVars = new ArrayList();
        listAllVars.addAll(listInstVar);
        listAllVars.addAll(listFormFieldVar);
        if (CollectionUtil.isNullOrWhiteSpace(listAllVars)) {
            return content;
        }
        for (KeyValue varInst : listAll) {
            String value;
            String key = varInst.getKey();
            if (!varsMap.containsKey(key)) continue;
            String string = value = varInst.getValue() == null ? "" : varInst.getValue().toString();
            String var = (String)varsMap.get(key);
            if (!StringUtil.isNotContainVarParams((String)(content = StringUtil.replaceParams((String)content, (String)var, (String)value, (String)symbolsChar)))) continue;
            break;
        }
        return content;
    }

    public static String translateByMainBusObjectData(String content, List<BusObjectData> busObjectDataList) {
        return TranslateHelper.translateByMainBusObjectData(content, busObjectDataList, "\"");
    }

    public static String translateByMainBusObjectData(String content, List<BusObjectData> busObjectDataList, String symbolsChar) {
        if (StringUtil.isNotContainVarParams((String)content)) {
            return content;
        }
        if (CollectionUtil.isNullOrWhiteSpace(busObjectDataList)) {
            return content;
        }
        Map varsMap = StringUtil.getPatternsVariable((String)content);
        boolean isCompleted = false;
        for (BusObjectData bust : busObjectDataList) {
            String mainTableName = bust.getMainTable();
            List<NameValueItem> list = bust.getData();
            boolean isHaveTableName = true;
            for (NameValueItem item : list) {
                String value;
                String key;
                if (isHaveTableName && item.getName().indexOf(46) == -1) {
                    isHaveTableName = false;
                }
                if (!varsMap.containsKey(key = isHaveTableName ? item.getName() : StringUtil.format((String)"{0}.{1}", (Object[])new Object[]{mainTableName, item.getName()}))) continue;
                String string = value = item.getValue() == null ? "" : item.getValue().toString();
                String var = (String)varsMap.get(key);
                if (!StringUtil.isNotContainVarParams((String)(content = StringUtil.replaceParams((String)content, (String)var, (String)value, (String)symbolsChar)))) continue;
                isCompleted = true;
                break;
            }
            if (!isCompleted) continue;
            break;
        }
        return content;
    }
}

