/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.process.engine.api.enums;

import java.util.HashMap;
import java.util.Map;

public enum WorkflowInstanceState {
    NoInstance(0, "\u62df\u7a3f"),
    Draft(1, "\u8349\u7a3f"),
    Running(2, "\u5ba1\u6838\u4e2d"),
    Completed(3, "\u5df2\u5b8c\u6210"),
    Suspend(4, "\u5df2\u6302\u8d77"),
    ReturnDraft(5, "\u9a73\u56de\u7533\u8bf7\u4eba"),
    ReturnActivity(6, "\u9a73\u56de"),
    Canceled(99, "\u5df2\u4f5c\u5e9f"),
    Deleted(100, "\u5df2\u5220\u9664"),
    All(10000, "\u5168\u90e8");

    private int intValue;
    private String description;

    public static Map<Integer, String> getKeyDescriptionMappings() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (WorkflowInstanceState item : WorkflowInstanceState.values()) {
            map.put(item.getIntValue(), item.getDescription());
        }
        return map;
    }

    public static Map<String, String> getNameDescriptionMappings() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (WorkflowInstanceState item : WorkflowInstanceState.values()) {
            map.put(item.name(), item.getDescription());
        }
        return map;
    }

    public static HashMap<Integer, WorkflowInstanceState> getMappings() {
        HashMap<Integer, WorkflowInstanceState> mappings = new HashMap<Integer, WorkflowInstanceState>();
        for (WorkflowInstanceState item : WorkflowInstanceState.values()) {
            mappings.put(item.getIntValue(), item);
        }
        return mappings;
    }

    private WorkflowInstanceState(int value, String description) {
        this.intValue = value;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public static WorkflowInstanceState forValue(int value) {
        return WorkflowInstanceState.getMappings().get(value);
    }
}

