/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.process.engine.api.options;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.f2bpm.base.core.utils.string.StringUtil;
import com.f2bpm.process.engine.api.options.advance.ApprovalActionOption;
import com.f2bpm.process.engine.api.options.advance.AutoCirculatedOption;
import com.f2bpm.process.engine.api.options.advance.DynamicsignOption;
import com.f2bpm.process.engine.api.options.advance.FreeWhileOption;
import com.f2bpm.process.engine.api.options.advance.FreeflowOption;
import com.f2bpm.process.engine.api.options.advance.FreejumpOption;
import com.f2bpm.process.engine.api.options.expirationRule.TimeLimitOption;
import com.f2bpm.process.engine.api.options.expirationRule.TimeOutWarningOption;
import com.f2bpm.process.engine.api.options.expirationRule.TimeoutDealWithOption;
import com.f2bpm.process.engine.api.options.notify.TaskNotifyOption;
import com.f2bpm.process.engine.api.options.onlineformOpts.FieldTitlePositionOption;
import com.f2bpm.process.engine.api.options.onlineformOpts.WhereConditionOption;
import com.f2bpm.system.security.ioptions.IOption;
import com.f2bpm.system.security.ioptions.Impl.GeneralOption;
import com.f2bpm.system.security.ioptions.OptionParam;
import com.f2bpm.system.security.ioptions.OptionType;
import java.util.ArrayList;
import java.util.List;

public class OptionUtil {
    public static List<OptionParam> GetListOptionParam(String optionsjsonArr) {
        if (StringUtil.isEmpty((String)optionsjsonArr) || optionsjsonArr.equals("[]")) {
            return new ArrayList<OptionParam>();
        }
        ArrayList<OptionParam> optionList = new ArrayList<OptionParam>();
        JSONArray jsonArray = JSONArray.parseArray((String)optionsjsonArr);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            OptionParam param = new OptionParam();
            param.setOpttype(jsonObject.getString("opttype"));
            param.setParams(jsonObject.getJSONObject("params").toString());
            optionList.add(param);
        }
        return optionList;
    }

    public static OptionParam ParseOption(OptionType optionType, String actAdOptionsjson) {
        if (StringUtil.isEmpty((String)actAdOptionsjson) || actAdOptionsjson.equals("[]") || actAdOptionsjson.length() < 10) {
            return null;
        }
        List<OptionParam> list = OptionUtil.GetListOptionParam(actAdOptionsjson);
        for (OptionParam OptionParam2 : list) {
            if (!OptionParam2.getOpttype().equalsIgnoreCase(optionType.toString())) continue;
            return OptionParam2;
        }
        return null;
    }

    public static IOption getImplOption(OptionType optionType, String allOptionsjson) {
        if (StringUtil.isEmpty((String)allOptionsjson) || allOptionsjson.equals("[]")) {
            return null;
        }
        OptionParam OptionParam2 = OptionUtil.ParseOption(optionType, allOptionsjson);
        return OptionUtil.getImplOption(OptionParam2);
    }

    public static IOption getImplOption(OptionParam OptionParam2) {
        if (OptionParam2 == null) {
            return null;
        }
        if (OptionParam2.getOpttype().equalsIgnoreCase(OptionType.freejump.toString())) {
            FreejumpOption opt = new FreejumpOption(OptionParam2);
            return opt.resolve();
        }
        if (OptionParam2.getOpttype().equalsIgnoreCase(OptionType.freeflow.toString())) {
            FreeflowOption opt = new FreeflowOption(OptionParam2);
            return opt.resolve();
        }
        if (OptionParam2.getOpttype().equalsIgnoreCase(OptionType.dynamicsign.toString())) {
            DynamicsignOption opt = new DynamicsignOption(OptionParam2);
            return opt.resolve();
        }
        if (OptionParam2.getOpttype().equalsIgnoreCase(OptionType.approvalAction.toString())) {
            ApprovalActionOption opt = new ApprovalActionOption(OptionParam2);
            return opt.resolve();
        }
        if (OptionParam2.getOpttype().equalsIgnoreCase(OptionType.autoCirculated.toString())) {
            AutoCirculatedOption opt = new AutoCirculatedOption(OptionParam2);
            return opt.resolve();
        }
        if (OptionParam2.getOpttype().equalsIgnoreCase(OptionType.general.toString())) {
            GeneralOption opt = new GeneralOption(OptionParam2);
            return opt.resolve();
        }
        if (OptionParam2.getOpttype().equals(OptionType.fieldTitlePosition.toString())) {
            FieldTitlePositionOption opt = new FieldTitlePositionOption(OptionParam2);
            return opt.resolve();
        }
        if (OptionParam2.getOpttype().equalsIgnoreCase(OptionType.whereCondition.toString())) {
            WhereConditionOption opt = new WhereConditionOption(OptionParam2);
            return opt.resolve();
        }
        if (OptionParam2.getOpttype().equalsIgnoreCase(OptionType.taskNotify.toString())) {
            TaskNotifyOption opt = new TaskNotifyOption(OptionParam2);
            return opt.resolve();
        }
        if (OptionParam2.getOpttype().equalsIgnoreCase(OptionType.timeLimit.toString())) {
            TimeLimitOption opt = new TimeLimitOption(OptionParam2);
            return opt.resolve();
        }
        if (OptionParam2.getOpttype().equals(OptionType.timeOutWarning.toString())) {
            TimeOutWarningOption opt = new TimeOutWarningOption(OptionParam2);
            return opt.resolve();
        }
        if (OptionParam2.getOpttype().equalsIgnoreCase(OptionType.timeOutDealWith.toString())) {
            TimeoutDealWithOption opt = new TimeoutDealWithOption(OptionParam2);
            return opt.resolve();
        }
        if (OptionParam2.getOpttype().equalsIgnoreCase(OptionType.freeWhile.toString())) {
            FreeWhileOption opt = new FreeWhileOption(OptionParam2);
            return opt.resolve();
        }
        return null;
    }
}

