/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.process.engine.api.options.onlineformOpts;

import com.f2bpm.base.core.app.AppConfig;
import com.f2bpm.base.core.enums.DalType;
import com.f2bpm.base.core.utils.JsonHelper;
import com.f2bpm.base.core.utils.SqlUtil;
import com.f2bpm.base.core.utils.string.StringUtil;
import com.f2bpm.base.core.utils.time.DateUtil;
import com.f2bpm.process.engine.api.entity.ConditionItem;
import com.f2bpm.process.org.api.integrate.imodel.IUser;
import com.f2bpm.system.security.ioptions.IOption;
import com.f2bpm.system.security.ioptions.OptionParam;
import com.f2bpm.system.security.web.WebHelper;
import java.util.HashMap;
import java.util.List;

public class WhereConditionOption
extends IOption {
    private List<ConditionItem> listCondition;

    public WhereConditionOption() {
    }

    public WhereConditionOption(OptionParam OptionParam2) {
        this.setOpttype(OptionParam2.getOpttype());
        this.setParams(OptionParam2.getParams());
    }

    public List<ConditionItem> getListCondition() {
        return this.listCondition;
    }

    public void setListCondition(List<ConditionItem> listCondition) {
        this.listCondition = listCondition;
    }

    public String getWhereSql(IUser iUser) {
        StringBuilder whereStr = new StringBuilder();
        int n = this.listCondition.size();
        int index = 0;
        for (ConditionItem item : this.listCondition) {
            ++index;
            String sqloperator = item.operator;
            String comparValue = item.comparValue;
            if (sqloperator.equalsIgnoreCase("==")) {
                sqloperator = " = ";
            } else if (sqloperator.equalsIgnoreCase("contain")) {
                sqloperator = " like ";
            } else if (sqloperator.equalsIgnoreCase("uncontain")) {
                sqloperator = " not like ";
            }
            if ((comparValue.equalsIgnoreCase("#CurrentDate#") || comparValue.equalsIgnoreCase("#CurrentDateTime#")) && AppConfig.getDbType().equalsIgnoreCase(DalType.oracle.toString())) {
                whereStr.append(StringUtil.format((String)" {0} {1} {2} ", (Object[])new Object[]{item.fieldName, sqloperator, comparValue.equalsIgnoreCase("#CurrentDate#") ? SqlUtil.convertToOracleDateValue((String)DateUtil.getCurrentDateStr()) : SqlUtil.convertToOracleDateTimeValue((String)DateUtil.getCurrentDateTime())}));
            } else {
                whereStr.append(StringUtil.format((String)" {0} {1} '{2}' ", (Object[])new Object[]{item.fieldName, sqloperator, sqloperator.contains("like") ? "%" + comparValue + "%" : comparValue}));
            }
            if (index == n) continue;
            whereStr.append(item.getAndOrChar());
        }
        String result = WebHelper.translationCurrentUserVarsUnSymbol((String)whereStr.toString(), (IUser)iUser);
        return result;
    }

    public IOption resolve() {
        HashMap<String, Class<ConditionItem>> classMap = new HashMap<String, Class<ConditionItem>>();
        classMap.put("listCondition", ConditionItem.class);
        WhereConditionOption option = (WhereConditionOption)((Object)JsonHelper.jsonToObject((String)this.getParams(), WhereConditionOption.class, classMap));
        this.listCondition = option.getListCondition();
        return this;
    }
}

