/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.process.engine.api.utils;

import com.f2bpm.base.core.entity.TextValue;
import com.f2bpm.base.core.utils.ArrayUtil;
import com.f2bpm.base.core.utils.XmlEntityUtil;
import com.f2bpm.base.core.utils.XmlUtil;
import com.f2bpm.base.core.utils.string.StringUtil;
import com.f2bpm.process.engine.api.model.Activity;
import com.f2bpm.process.engine.api.model.ActivityInfo;
import com.f2bpm.process.engine.api.model.Transition;
import com.f2bpm.process.engine.api.model.TransitionInfo;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class ActivityXmlHelper {
    public static List<TextValue> getExtendedPropertyToEntity(String xmlStr) {
        return ActivityXmlHelper.getTextValueEntityXmlToEntity(xmlStr);
    }

    public static List<TextValue> getTextValueEntityXmlToEntity(String xmlStr) {
        ArrayList<TextValue> dic = new ArrayList<TextValue>();
        if (!StringUtil.isNullOrWhiteSpace((String)xmlStr)) {
            StringBuilder xml = new StringBuilder();
            if (xmlStr.indexOf("<?xml") == -1) {
                xml.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
            }
            xml.append("<ExtendedProperty>");
            xml.append(xmlStr);
            xml.append("</ExtendedProperty>");
            Document document = XmlUtil.getDocumentByXmlStr((String)xml.toString());
            Element root = document.getRootElement();
            List data = root.elements("Item");
            for (Element item : data) {
                TextValue entity = new TextValue();
                entity.setText(item.attributeValue("Text"));
                entity.setValue(item.attributeValue("Value"));
                dic.add(entity);
            }
        }
        return dic;
    }

    public static String getExtendedPropertyXml(List<TextValue> list, boolean isContainXmlHead) {
        StringBuilder xml = new StringBuilder();
        if (isContainXmlHead) {
            xml.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
        }
        xml.append("<ExtendedProperty>");
        for (TextValue item : list) {
            xml.append(String.format("<Item text=\"{0}\" value=\"{1}\"/>", item.getText(), item.getValue()));
        }
        xml.append("</ExtendedProperty>");
        return xml.toString();
    }

    public static String geActivitytStartXml(Activity activity) throws IllegalAccessException, NoSuchFieldException {
        StringBuilder xml = new StringBuilder();
        xml.append(XmlEntityUtil.entityConvertToStartXml((Object)((Object)activity), Activity.class, (boolean)true));
        return xml.toString();
    }

    public static String getTransitionListXml(ActivityInfo info) throws IllegalAccessException, NoSuchFieldException {
        StringBuilder xml = new StringBuilder();
        xml.append("<TransitionList Description=\"\u8fc1\u79fb\u5217\u8868\" >");
        if (info.getListNextTransition() != null) {
            for (TransitionInfo set : info.getListNextTransition()) {
                Object[] exceptProperty = new String[]{"TransitionCondition"};
                String transitionName = set.getTransitionName().replace("\\", "/");
                set.setTransitionName(transitionName);
                String xmlSetHead = XmlEntityUtil.entityConvertToStartXml((Object)((Object)set), Transition.class, (List)ArrayUtil.convertList((Object[])exceptProperty));
                String xmlContent = StringUtil.format((String)"<TransitionCondition Description=\"\u8fc1\u79fb\u6761\u4ef6\"><![CDATA[{0}]]></TransitionCondition>", (Object[])new Object[]{set.getTransitionCondition()});
                String xmlEnd = "</Transition>";
                xml.append(xmlSetHead);
                xml.append(xmlContent);
                xml.append(xmlEnd);
            }
        }
        xml.append("</TransitionList>");
        return xml.toString();
    }

    public static String getActivitySetXml(Transition set) throws IllegalAccessException, NoSuchFieldException {
        StringBuilder xml = new StringBuilder();
        xml.append(XmlEntityUtil.entityConvertToXml((Object)((Object)set), Transition.class, null, (boolean)true));
        return xml.toString();
    }
}

