/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.process.smartForm.api.busObjectOption;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.f2bpm.base.core.utils.string.StringUtil;
import com.f2bpm.process.smartForm.api.busObjectOption.BoRuleCode;
import com.f2bpm.process.smartForm.api.busObjectOption.IBoOption;
import com.f2bpm.process.smartForm.api.busObjectOption.ruleImpl.BusObjectGeneralOption;
import com.f2bpm.process.smartForm.api.busObjectOption.ruleImpl.FormCustButtonOption;
import com.f2bpm.process.smartForm.api.busObjectOption.ruleImpl.FormGeneralOption;
import com.f2bpm.process.smartForm.api.busObjectOption.ruleImpl.GeneralKeyValueOption;
import com.f2bpm.process.smartForm.api.busObjectOption.ruleImpl.OrderByOption;
import com.f2bpm.process.smartForm.api.busObjectOption.ruleImpl.WhereQueryOption;
import java.util.ArrayList;
import java.util.List;

public class BoOptionUtil {
    public static List<IBoOption> GetListIOption(String ruleOptionsJson) {
        if (StringUtil.isEmpty((String)ruleOptionsJson) || ruleOptionsJson.equals("[]")) {
            return new ArrayList<IBoOption>();
        }
        ArrayList<IBoOption> optionList = new ArrayList<IBoOption>();
        JSONArray jsonArray = JSONArray.parseArray((String)ruleOptionsJson);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String ruleCode = jsonObject.getString("ruleCode");
            String ruleType = jsonObject.getString("ruleType");
            IBoOption option = BoOptionUtil.getEmptyImplOption(ruleCode);
            option.setRuleType(ruleType);
            option.setRuleTitle(jsonObject.getString("ruleTitle").toString());
            option.setRuleCode(jsonObject.getString("ruleCode").toString());
            option.setWhenExcute(jsonObject.getString("whenExcute").toString());
            option.setRuleParams(jsonObject.getString("ruleParams").toString());
            optionList.add(option.resolve());
        }
        return optionList;
    }

    private static IBoOption getEmptyImplOption(String ruleCode) {
        if (StringUtil.isEmpty((String)ruleCode)) {
            return null;
        }
        if (ruleCode.equals(BoRuleCode.orderBy.toString())) {
            OrderByOption opt = new OrderByOption();
            return opt;
        }
        if (ruleCode.equals(BoRuleCode.whereQuery.toString())) {
            WhereQueryOption opt = new WhereQueryOption();
            return opt;
        }
        if (ruleCode.equals(BoRuleCode.formGeneral.toString())) {
            FormGeneralOption opt = new FormGeneralOption();
            return opt;
        }
        if (ruleCode.equals(BoRuleCode.formCustButton.toString())) {
            FormCustButtonOption opt = new FormCustButtonOption();
            return opt;
        }
        if (ruleCode.equals(BoRuleCode.formSubTableCustButton.toString())) {
            FormCustButtonOption opt = new FormCustButtonOption();
            return opt;
        }
        if (ruleCode.equals(BoRuleCode.formSubTableToolbarCustButton.toString())) {
            FormCustButtonOption opt = new FormCustButtonOption();
            return opt;
        }
        if (ruleCode.equals(BoRuleCode.busObjectGeneral.toString())) {
            BusObjectGeneralOption opt = new BusObjectGeneralOption();
            return opt;
        }
        if (ruleCode.equals(BoRuleCode.general.toString())) {
            GeneralKeyValueOption opt = new GeneralKeyValueOption();
            return opt;
        }
        return null;
    }

    public static IBoOption getImplOption(BoRuleCode code, String ruleOptionsJson) {
        if (StringUtil.isEmpty((String)ruleOptionsJson) || ruleOptionsJson.equals("[]")) {
            return null;
        }
        JSONArray jsonArray = JSONArray.parseArray((String)ruleOptionsJson);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String ruleCode = jsonObject.getString("ruleCode");
            if (!ruleCode.equals(code.toString())) continue;
            IBoOption option = BoOptionUtil.getEmptyImplOption(ruleCode);
            String ruleType = jsonObject.getString("ruleType");
            option.setRuleType(ruleType);
            option.setRuleTitle(jsonObject.getString("ruleTitle").toString());
            option.setRuleCode(ruleCode);
            option.setWhenExcute(jsonObject.getString("whenExcute").toString());
            option.setRuleParams(jsonObject.getString("ruleParams").toString());
            return option.resolve();
        }
        return null;
    }
}

