/*
 * Decompiled with CFR 0.152.
 */
package com.f2bpm.process.smartForm.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.f2bpm.base.core.enums.NameValueItem;
import com.f2bpm.base.core.utils.JsonHelper;
import com.f2bpm.base.core.utils.string.StringUtil;
import com.f2bpm.process.smartForm.api.entity.BusObjectData;
import com.f2bpm.process.smartForm.api.entity.SubBusObjectData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BusObjectDataUtil {
    public static BusObjectData convertJsonToBusObjectData(String json) {
        return (BusObjectData)JsonHelper.jsonToObject((String)json, BusObjectData.class);
    }

    public static List<BusObjectData> convertJsonToBusObjectDatas(String jsons) {
        ArrayList<BusObjectData> list = new ArrayList<BusObjectData>();
        JSONArray jsonArray = JSONArray.parseArray((String)jsons);
        int n = jsonArray.size();
        for (int i = 0; i < n; ++i) {
            BusObjectData busObjectData = new BusObjectData();
            JSONObject jobject = jsonArray.getJSONObject(i);
            String mainTable = jobject.getString("mainTable");
            busObjectData.setMainTable(mainTable);
            JSONArray dataArray = jobject.getJSONArray("data");
            ArrayList<NameValueItem> listDataItems = new ArrayList<NameValueItem>();
            for (int j = 0; j < dataArray.size(); ++j) {
                JSONObject item = dataArray.getJSONObject(j);
                String name = item.getString("name");
                String value = item.getString("value");
                NameValueItem nv = new NameValueItem(name, (Object)value);
                listDataItems.add(nv);
            }
            busObjectData.setData(listDataItems);
            JSONArray subTableArray = jobject.containsKey((Object)"subTables") ? jobject.getJSONArray("subTables") : null;
            List<SubBusObjectData> listSubData = new ArrayList<SubBusObjectData>();
            if (subTableArray != null) {
                listSubData = BusObjectDataUtil.getBuindSubData(subTableArray);
            }
            busObjectData.setSubTables(listSubData);
            list.add(busObjectData);
        }
        return list;
    }

    public static List<SubBusObjectData> getBuindSubData(JSONArray subTableArray) {
        ArrayList<SubBusObjectData> listSubData = new ArrayList<SubBusObjectData>();
        int n = subTableArray.size();
        if (n <= 0) {
            return null;
        }
        for (int j = 0; j < n; ++j) {
            SubBusObjectData subDataItem = new SubBusObjectData();
            JSONObject sub = subTableArray.getJSONObject(j);
            String subTable = sub.getString("subTable");
            subDataItem.setSubTable(subTable);
            JSONArray deleteDataArray = sub.getJSONArray("deleteData");
            if (deleteDataArray == null) {
                deleteDataArray = new JSONArray();
            }
            ArrayList<NameValueItem> deleteData = new ArrayList<NameValueItem>();
            for (int d = 0; d < deleteDataArray.size(); ++d) {
                JSONObject delItem = deleteDataArray.getJSONObject(d);
                String name = delItem.getString("name");
                String value = delItem.getString("value");
                NameValueItem nv = new NameValueItem(name, (Object)value);
                deleteData.add(nv);
            }
            subDataItem.setDeleteData(deleteData);
            JSONArray rowsArr = sub.getJSONArray("data");
            if (rowsArr == null) {
                rowsArr = new JSONArray();
            }
            ArrayList<List<NameValueItem>> rows = new ArrayList<List<NameValueItem>>();
            for (int k = 0; k < rowsArr.size(); ++k) {
                JSONArray rowArr = rowsArr.getJSONArray(k);
                ArrayList<NameValueItem> row = new ArrayList<NameValueItem>();
                for (int l = 0; l < rowArr.size(); ++l) {
                    JSONObject column = rowArr.getJSONObject(l);
                    String name = column.getString("name");
                    String value = column.getString("value");
                    if (name.equalsIgnoreCase("subTables")) {
                        String subTablesJsonString = value;
                        if (StringUtil.isEmpty((String)subTablesJsonString)) continue;
                        JSONArray sunTablesArray = JSONArray.parseArray((String)subTablesJsonString);
                        List<SubBusObjectData> sunBusObjectDataList = BusObjectDataUtil.getBuindSubData(sunTablesArray);
                        NameValueItem nv = new NameValueItem("subTables", sunBusObjectDataList);
                        row.add(nv);
                        continue;
                    }
                    NameValueItem nv = new NameValueItem(name, (Object)value);
                    row.add(nv);
                }
                rows.add(row);
            }
            subDataItem.setData(rows);
            listSubData.add(subDataItem);
        }
        return listSubData;
    }

    public static List<BusObjectData> convertJsonToBusObjectDatasByAutoEntity(String jsons) {
        HashMap<String, Class> classMap = new HashMap<String, Class>();
        classMap.put("data", NameValueItem.class);
        classMap.put("deleteData", NameValueItem.class);
        classMap.put("subTables", SubBusObjectData.class);
        List list = JsonHelper.jsonArrToObject((String)jsons, BusObjectData.class, classMap);
        return list;
    }

    public static String convertBusObjectDataListToJson(List<BusObjectData> buObjectList) {
        return JsonHelper.objectToJSON(buObjectList);
    }

    public static String convertBusObjectDataToJson(BusObjectData busObjectData) {
        return JsonHelper.objectToJSON((Object)busObjectData);
    }
}

