/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbeans;

import com.googlecode.openbeans.FeatureDescriptor;
import com.googlecode.openbeans.IntrospectionException;
import com.googlecode.openbeans.MethodDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.TooManyListenersException;
import org.apache.harmony.beans.internal.nls.Messages;

public class EventSetDescriptor
extends FeatureDescriptor {
    private Class<?> listenerType;
    private ArrayList<MethodDescriptor> listenerMethodDescriptors;
    private Method[] listenerMethods;
    private Method getListenerMethod;
    private Method addListenerMethod;
    private Method removeListenerMethod;
    private boolean unicast;
    private boolean inDefaultEventSet = true;

    public EventSetDescriptor(Class<?> sourceClass, String eventSetName, Class<?> listenerType, String listenerMethodName) throws IntrospectionException {
        this.checkNotNull(sourceClass, eventSetName, listenerType, listenerMethodName);
        this.setName(eventSetName);
        this.listenerType = listenerType;
        Method method = this.findListenerMethodByName(listenerMethodName);
        EventSetDescriptor.checkEventType(eventSetName, method);
        this.listenerMethodDescriptors = new ArrayList();
        this.listenerMethodDescriptors.add(new MethodDescriptor(method));
        this.addListenerMethod = this.findMethodByPrefix(sourceClass, "add", "");
        this.removeListenerMethod = this.findMethodByPrefix(sourceClass, "remove", "");
        if (this.addListenerMethod == null || this.removeListenerMethod == null) {
            throw new IntrospectionException(Messages.getString("beans.38"));
        }
        this.getListenerMethod = this.findMethodByPrefix(sourceClass, "get", "s");
        this.unicast = EventSetDescriptor.isUnicastByDefault(this.addListenerMethod);
    }

    public EventSetDescriptor(Class<?> sourceClass, String eventSetName, Class<?> listenerType, String[] listenerMethodNames, String addListenerMethodName, String removeListenerMethodName) throws IntrospectionException {
        this(sourceClass, eventSetName, listenerType, listenerMethodNames, addListenerMethodName, removeListenerMethodName, null);
    }

    public EventSetDescriptor(Class<?> sourceClass, String eventSetName, Class<?> listenerType, String[] listenerMethodNames, String addListenerMethodName, String removeListenerMethodName, String getListenerMethodName) throws IntrospectionException {
        this.checkNotNull(sourceClass, eventSetName, listenerType, listenerMethodNames);
        this.setName(eventSetName);
        this.listenerType = listenerType;
        this.listenerMethodDescriptors = new ArrayList();
        String[] stringArray = listenerMethodNames;
        int n = listenerMethodNames.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            Method m = this.findListenerMethodByName(element);
            this.listenerMethodDescriptors.add(new MethodDescriptor(m));
            ++n2;
        }
        if (addListenerMethodName != null) {
            this.addListenerMethod = this.findAddRemoveListenerMethod(sourceClass, addListenerMethodName);
        }
        if (removeListenerMethodName != null) {
            this.removeListenerMethod = this.findAddRemoveListenerMethod(sourceClass, removeListenerMethodName);
        }
        if (getListenerMethodName != null) {
            this.getListenerMethod = this.findGetListenerMethod(sourceClass, getListenerMethodName);
        }
        this.unicast = EventSetDescriptor.isUnicastByDefault(this.addListenerMethod);
    }

    private Method findListenerMethodByName(String listenerMethodName) throws IntrospectionException {
        Method[] methods;
        Method result = null;
        Method[] methodArray = methods = this.listenerType.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] paramTypes;
            Method method = methodArray[n2];
            if (listenerMethodName.equals(method.getName()) && (paramTypes = method.getParameterTypes()).length == 1 && paramTypes[0].getName().endsWith("Event")) {
                result = method;
                break;
            }
            ++n2;
        }
        if (result == null) {
            throw new IntrospectionException(Messages.getString("beans.31", listenerMethodName, this.listenerType.getName()));
        }
        return result;
    }

    public EventSetDescriptor(String eventSetName, Class<?> listenerType, Method[] listenerMethods, Method addListenerMethod, Method removeListenerMethod) throws IntrospectionException {
        this(eventSetName, listenerType, listenerMethods, addListenerMethod, removeListenerMethod, null);
    }

    public EventSetDescriptor(String eventSetName, Class<?> listenerType, Method[] listenerMethods, Method addListenerMethod, Method removeListenerMethod, Method getListenerMethod) throws IntrospectionException {
        this.setName(eventSetName);
        this.listenerType = listenerType;
        this.listenerMethods = listenerMethods;
        if (listenerMethods != null) {
            this.listenerMethodDescriptors = new ArrayList();
            Method[] methodArray = listenerMethods;
            int n = listenerMethods.length;
            int n2 = 0;
            while (n2 < n) {
                Method element = methodArray[n2];
                this.listenerMethodDescriptors.add(new MethodDescriptor(element));
                ++n2;
            }
        }
        this.addListenerMethod = addListenerMethod;
        this.removeListenerMethod = removeListenerMethod;
        this.getListenerMethod = getListenerMethod;
        this.unicast = EventSetDescriptor.isUnicastByDefault(addListenerMethod);
    }

    public EventSetDescriptor(String eventSetName, Class<?> listenerType, MethodDescriptor[] listenerMethodDescriptors, Method addListenerMethod, Method removeListenerMethod) throws IntrospectionException {
        this(eventSetName, listenerType, null, addListenerMethod, removeListenerMethod, null);
        if (listenerMethodDescriptors != null) {
            this.listenerMethodDescriptors = new ArrayList();
            MethodDescriptor[] methodDescriptorArray = listenerMethodDescriptors;
            int n = listenerMethodDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                MethodDescriptor element = methodDescriptorArray[n2];
                this.listenerMethodDescriptors.add(element);
                ++n2;
            }
        }
    }

    private void checkNotNull(Object sourceClass, Object eventSetName, Object alistenerType, Object listenerMethodName) {
        if (sourceClass == null) {
            throw new NullPointerException(Messages.getString("beans.0C"));
        }
        if (eventSetName == null) {
            throw new NullPointerException(Messages.getString("beans.53"));
        }
        if (alistenerType == null) {
            throw new NullPointerException(Messages.getString("beans.54"));
        }
        if (listenerMethodName == null) {
            throw new NullPointerException(Messages.getString("beans.52"));
        }
    }

    private static void checkEventType(String eventSetName, Method listenerMethod) throws IntrospectionException {
        Class<?>[] params = listenerMethod.getParameterTypes();
        String firstParamTypeName = null;
        String eventTypeName = EventSetDescriptor.prepareEventTypeName(eventSetName);
        if (params.length > 0) {
            firstParamTypeName = EventSetDescriptor.extractShortClassName(params[0].getName());
        }
        if (firstParamTypeName == null || !firstParamTypeName.equals(eventTypeName)) {
            throw new IntrospectionException(Messages.getString("beans.51", listenerMethod.getName(), eventTypeName));
        }
    }

    private static String extractShortClassName(String fullClassName) {
        int k = fullClassName.lastIndexOf(36);
        k = k == -1 ? fullClassName.lastIndexOf(46) : k;
        return fullClassName.substring(k + 1);
    }

    private static String prepareEventTypeName(String eventSetName) {
        StringBuilder sb = new StringBuilder();
        if (eventSetName != null && eventSetName.length() > 0) {
            sb.append(Character.toUpperCase(eventSetName.charAt(0)));
            if (eventSetName.length() > 1) {
                sb.append(eventSetName.substring(1));
            }
        }
        sb.append("Event");
        return sb.toString();
    }

    public Method[] getListenerMethods() {
        if (this.listenerMethods != null) {
            return this.listenerMethods;
        }
        if (this.listenerMethodDescriptors != null) {
            this.listenerMethods = new Method[this.listenerMethodDescriptors.size()];
            int index = 0;
            for (MethodDescriptor md : this.listenerMethodDescriptors) {
                this.listenerMethods[index++] = md.getMethod();
            }
            return this.listenerMethods;
        }
        return null;
    }

    public MethodDescriptor[] getListenerMethodDescriptors() {
        return this.listenerMethodDescriptors == null ? null : this.listenerMethodDescriptors.toArray(new MethodDescriptor[0]);
    }

    public Method getRemoveListenerMethod() {
        return this.removeListenerMethod;
    }

    public Method getGetListenerMethod() {
        return this.getListenerMethod;
    }

    public Method getAddListenerMethod() {
        return this.addListenerMethod;
    }

    public Class<?> getListenerType() {
        return this.listenerType;
    }

    public void setUnicast(boolean unicast) {
        this.unicast = unicast;
    }

    public void setInDefaultEventSet(boolean inDefaultEventSet) {
        this.inDefaultEventSet = inDefaultEventSet;
    }

    public boolean isUnicast() {
        return this.unicast;
    }

    public boolean isInDefaultEventSet() {
        return this.inDefaultEventSet;
    }

    private Method findAddRemoveListenerMethod(Class<?> sourceClass, String methodName) throws IntrospectionException {
        try {
            return sourceClass.getMethod(methodName, this.listenerType);
        }
        catch (NoSuchMethodException e) {
            return this.findAddRemoveListnerMethodWithLessCheck(sourceClass, methodName);
        }
        catch (Exception e) {
            throw new IntrospectionException(Messages.getString("beans.31", methodName, this.listenerType.getName()));
        }
    }

    private Method findAddRemoveListnerMethodWithLessCheck(Class<?> sourceClass, String methodName) throws IntrospectionException {
        Method[] methods = sourceClass.getMethods();
        Method result = null;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] paramTypes;
            Method method = methodArray[n2];
            if (method.getName().equals(methodName) && (paramTypes = method.getParameterTypes()).length == 1) {
                result = method;
                break;
            }
            ++n2;
        }
        if (result == null) {
            throw new IntrospectionException(Messages.getString("beans.31", methodName, this.listenerType.getName()));
        }
        return result;
    }

    private Method findGetListenerMethod(Class<?> sourceClass, String methodName) {
        try {
            return sourceClass.getMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Method findMethodByPrefix(Class<?> sourceClass, String prefix, String postfix) {
        String shortName = this.listenerType.getName();
        if (this.listenerType.getPackage() != null) {
            shortName = shortName.substring(this.listenerType.getPackage().getName().length() + 1);
        }
        String methodName = String.valueOf(prefix) + shortName + postfix;
        try {
            if ("get".equals(prefix)) {
                return sourceClass.getMethod(methodName, new Class[0]);
            }
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
        Method[] methods = sourceClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            Class<?>[] paramTypes;
            if (methods[i].getName().equals(methodName) && (paramTypes = methods[i].getParameterTypes()).length == 1) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    private static boolean isUnicastByDefault(Method addMethod) {
        if (addMethod != null) {
            Class<?>[] exceptionTypes;
            Class<?>[] classArray = exceptionTypes = addMethod.getExceptionTypes();
            int n = exceptionTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> element = classArray[n2];
                if (element.equals(TooManyListenersException.class)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    void merge(EventSetDescriptor event) {
        super.merge(event);
        if (this.addListenerMethod == null) {
            this.addListenerMethod = event.addListenerMethod;
        }
        if (this.getListenerMethod == null) {
            this.getListenerMethod = event.getListenerMethod;
        }
        if (this.listenerMethodDescriptors == null) {
            this.listenerMethodDescriptors = event.listenerMethodDescriptors;
        }
        if (this.listenerMethods == null) {
            this.listenerMethods = event.listenerMethods;
        }
        if (this.listenerType == null) {
            this.listenerType = event.listenerType;
        }
        if (this.removeListenerMethod == null) {
            this.removeListenerMethod = event.removeListenerMethod;
        }
        this.inDefaultEventSet &= event.inDefaultEventSet;
    }
}

