/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbeans;

import com.googlecode.openbeans.BeanDescriptor;
import com.googlecode.openbeans.BeanInfo;
import com.googlecode.openbeans.EventSetDescriptor;
import com.googlecode.openbeans.IndexedPropertyDescriptor;
import com.googlecode.openbeans.IntrospectionException;
import com.googlecode.openbeans.Introspector;
import com.googlecode.openbeans.MethodDescriptor;
import com.googlecode.openbeans.PropertyChangeListener;
import com.googlecode.openbeans.PropertyDescriptor;
import com.googlecode.openbeans.PropertyVetoException;
import com.googlecode.openbeans.SimpleBeanInfo;
import java.awt.Image;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.TooManyListenersException;

class StandardBeanInfo
extends SimpleBeanInfo {
    private static final String PREFIX_IS = "is";
    private static final String PREFIX_GET = "get";
    private static final String PREFIX_SET = "set";
    private static final String PREFIX_ADD = "add";
    private static final String PREFIX_REMOVE = "remove";
    private static final String SUFFIX_LISTEN = "Listener";
    private static final String STR_NORMAL = "normal";
    private static final String STR_INDEXED = "indexed";
    private static final String STR_VALID = "valid";
    private static final String STR_INVALID = "invalid";
    private static final String STR_PROPERTY_TYPE = "PropertyType";
    private static final String STR_IS_CONSTRAINED = "isConstrained";
    private static final String STR_SETTERS = "setters";
    private static final String STR_GETTERS = "getters";
    private boolean explicitMethods = false;
    private boolean explicitProperties = false;
    private boolean explicitEvents = false;
    private BeanInfo explicitBeanInfo = null;
    private EventSetDescriptor[] events = null;
    private MethodDescriptor[] methods = null;
    private PropertyDescriptor[] properties = null;
    private BeanDescriptor beanDescriptor = null;
    BeanInfo[] additionalBeanInfo = null;
    private Class<?> beanClass;
    private int defaultEventIndex = -1;
    private int defaultPropertyIndex = -1;
    private static PropertyComparator comparator = new PropertyComparator();
    private Object[] icon = new Object[4];
    private boolean canAddPropertyChangeListener;
    private boolean canRemovePropertyChangeListener;

    StandardBeanInfo(Class<?> beanClass, BeanInfo explicitBeanInfo, Class<?> stopClass) throws IntrospectionException {
        this.beanClass = beanClass;
        if (explicitBeanInfo != null) {
            this.explicitBeanInfo = explicitBeanInfo;
            this.events = explicitBeanInfo.getEventSetDescriptors();
            this.methods = explicitBeanInfo.getMethodDescriptors();
            this.properties = explicitBeanInfo.getPropertyDescriptors();
            this.defaultEventIndex = explicitBeanInfo.getDefaultEventIndex();
            if (this.defaultEventIndex < 0 || this.defaultEventIndex >= this.events.length) {
                this.defaultEventIndex = -1;
            }
            this.defaultPropertyIndex = explicitBeanInfo.getDefaultPropertyIndex();
            if (this.defaultPropertyIndex < 0 || this.defaultPropertyIndex >= this.properties.length) {
                this.defaultPropertyIndex = -1;
            }
            this.additionalBeanInfo = explicitBeanInfo.getAdditionalBeanInfo();
            int i = 0;
            while (i < 4) {
                this.icon[i] = explicitBeanInfo.getIcon(i + 1);
                ++i;
            }
            if (this.events != null) {
                this.explicitEvents = true;
            }
            if (this.methods != null) {
                this.explicitMethods = true;
            }
            if (this.properties != null) {
                this.explicitProperties = true;
            }
        }
        if (this.methods == null) {
            this.methods = this.introspectMethods();
        }
        if (this.properties == null) {
            this.properties = this.introspectProperties(stopClass);
        }
        if (this.events == null) {
            this.events = this.introspectEvents();
        }
    }

    @Override
    public BeanInfo[] getAdditionalBeanInfo() {
        return null;
    }

    @Override
    public EventSetDescriptor[] getEventSetDescriptors() {
        return this.events;
    }

    @Override
    public MethodDescriptor[] getMethodDescriptors() {
        return this.methods;
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.properties;
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        if (this.beanDescriptor == null) {
            if (this.explicitBeanInfo != null) {
                this.beanDescriptor = this.explicitBeanInfo.getBeanDescriptor();
            }
            if (this.beanDescriptor == null) {
                this.beanDescriptor = new BeanDescriptor(this.beanClass);
            }
        }
        return this.beanDescriptor;
    }

    @Override
    public int getDefaultEventIndex() {
        return this.defaultEventIndex;
    }

    @Override
    public int getDefaultPropertyIndex() {
        return this.defaultPropertyIndex;
    }

    @Override
    public Image getIcon(int iconKind) {
        return (Image)this.icon[iconKind - 1];
    }

    void mergeBeanInfo(BeanInfo beanInfo, boolean force) throws IntrospectionException {
        EventSetDescriptor[] superEvents;
        MethodDescriptor[] superMethods;
        PropertyDescriptor[] superDescs;
        if ((force || !this.explicitProperties) && (superDescs = beanInfo.getPropertyDescriptors()) != null) {
            if (this.getPropertyDescriptors() != null) {
                this.properties = this.mergeProps(superDescs, beanInfo.getDefaultPropertyIndex());
            } else {
                this.properties = superDescs;
                this.defaultPropertyIndex = beanInfo.getDefaultPropertyIndex();
            }
        }
        if ((force || !this.explicitMethods) && (superMethods = beanInfo.getMethodDescriptors()) != null) {
            this.methods = this.methods != null ? this.mergeMethods(superMethods) : superMethods;
        }
        if ((force || !this.explicitEvents) && (superEvents = beanInfo.getEventSetDescriptors()) != null) {
            if (this.events != null) {
                this.events = this.mergeEvents(superEvents, beanInfo.getDefaultEventIndex());
            } else {
                this.events = superEvents;
                this.defaultEventIndex = beanInfo.getDefaultEventIndex();
            }
        }
    }

    private PropertyDescriptor[] mergeProps(PropertyDescriptor[] superDescs, int superDefaultIndex) throws IntrospectionException {
        HashMap<String, PropertyDescriptor> subMap = StandardBeanInfo.internalAsMap(this.properties);
        String defaultPropertyName = null;
        if (this.defaultPropertyIndex >= 0 && this.defaultPropertyIndex < this.properties.length) {
            defaultPropertyName = this.properties[this.defaultPropertyIndex].getName();
        } else if (superDefaultIndex >= 0 && superDefaultIndex < superDescs.length) {
            defaultPropertyName = superDescs[superDefaultIndex].getName();
        }
        int i = 0;
        while (i < superDescs.length) {
            PropertyDescriptor superDesc = superDescs[i];
            String propertyName = superDesc.getName();
            if (!subMap.containsKey(propertyName)) {
                subMap.put(propertyName, superDesc);
            } else {
                Method method;
                PropertyDescriptor subDesc;
                PropertyDescriptor value = subMap.get(propertyName);
                Method subGet = value.getReadMethod();
                Method subSet = value.getWriteMethod();
                Method superGet = superDesc.getReadMethod();
                Method superSet = superDesc.getWriteMethod();
                Class<?> superType = superDesc.getPropertyType();
                Class<?> superIndexedType = null;
                Class<?> subType = value.getPropertyType();
                Class<?> subIndexedType = null;
                if (value instanceof IndexedPropertyDescriptor) {
                    subIndexedType = ((IndexedPropertyDescriptor)value).getIndexedPropertyType();
                }
                if (superDesc instanceof IndexedPropertyDescriptor) {
                    superIndexedType = ((IndexedPropertyDescriptor)superDesc).getIndexedPropertyType();
                }
                if (superIndexedType == null) {
                    subDesc = value;
                    if (subIndexedType == null) {
                        if (subType != null && superType != null && subType.getName() != null && subType.getName().equals(superType.getName())) {
                            if (superGet != null && (subGet == null || superGet.equals(subGet))) {
                                subDesc.setReadMethod(superGet);
                            }
                            if (superSet != null && (subSet == null || superSet.equals(subSet))) {
                                subDesc.setWriteMethod(superSet);
                            }
                            if (subType == Boolean.TYPE && subGet != null && superGet != null && superGet.getName().startsWith(PREFIX_IS)) {
                                subDesc.setReadMethod(superGet);
                            }
                        } else if ((subGet == null || subSet == null) && superGet != null) {
                            subDesc = new PropertyDescriptor(propertyName, superGet, superSet);
                            if (subGet != null) {
                                MethodDescriptor[] introspectMethods;
                                String subGetName = subGet.getName();
                                method = null;
                                MethodDescriptor[] methodDescriptorArray = introspectMethods = this.introspectMethods();
                                int n = introspectMethods.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    MethodDescriptor methodDesc = methodDescriptorArray[n2];
                                    method = methodDesc.getMethod();
                                    if (method != subGet && subGetName.equals(method.getName()) && method.getParameterTypes().length == 0 && method.getReturnType() == superType) {
                                        subDesc.setReadMethod(method);
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                        }
                    } else {
                        if (superType != null && superType.isArray() && superType.getComponentType().getName().equals(subIndexedType.getName())) {
                            if (subGet == null && superGet != null) {
                                subDesc.setReadMethod(superGet);
                            }
                            if (subSet == null && superSet != null) {
                                subDesc.setWriteMethod(superSet);
                            }
                        }
                        if (subIndexedType == Boolean.TYPE && superType == Boolean.TYPE) {
                            Method subIndexedSet = ((IndexedPropertyDescriptor)subDesc).getIndexedWriteMethod();
                            if (subGet == null && subSet == null && subIndexedSet != null && superGet != null) {
                                try {
                                    subSet = this.beanClass.getDeclaredMethod(subIndexedSet.getName(), Boolean.TYPE);
                                }
                                catch (Exception method2) {
                                    // empty catch block
                                }
                                if (subSet != null) {
                                    subDesc = new PropertyDescriptor(propertyName, superGet, subSet);
                                }
                            }
                        }
                    }
                    subMap.put(propertyName, subDesc);
                } else if (subIndexedType == null) {
                    if (subType != null && subType.isArray() && subType.getComponentType().getName().equals(superIndexedType.getName())) {
                        if (subGet != null) {
                            superDesc.setReadMethod(subGet);
                        }
                        if (subSet != null) {
                            superDesc.setWriteMethod(subSet);
                        }
                        subMap.put(propertyName, superDesc);
                    } else {
                        if (subGet == null || subSet == null) {
                            Class<?> beanSuperClass = this.beanClass.getSuperclass();
                            String methodSuffix = this.capitalize(propertyName);
                            method = null;
                            if (subGet == null) {
                                if (subType == Boolean.TYPE) {
                                    try {
                                        method = beanSuperClass.getDeclaredMethod(PREFIX_IS + methodSuffix, new Class[0]);
                                    }
                                    catch (Exception exception) {}
                                } else {
                                    try {
                                        method = beanSuperClass.getDeclaredMethod(PREFIX_GET + methodSuffix, new Class[0]);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (method != null && !Modifier.isStatic(method.getModifiers()) && method.getReturnType() == subType) {
                                    value.setReadMethod(method);
                                }
                            } else {
                                try {
                                    method = beanSuperClass.getDeclaredMethod(PREFIX_SET + methodSuffix, subType);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (method != null && !Modifier.isStatic(method.getModifiers()) && method.getReturnType() == Void.TYPE) {
                                    value.setWriteMethod(method);
                                }
                            }
                        }
                        subMap.put(propertyName, value);
                    }
                } else if (subIndexedType.getName().equals(superIndexedType.getName())) {
                    subDesc = (IndexedPropertyDescriptor)value;
                    if (subGet == null && superGet != null) {
                        subDesc.setReadMethod(superGet);
                    }
                    if (subSet == null && superSet != null) {
                        subDesc.setWriteMethod(superSet);
                    }
                    IndexedPropertyDescriptor superIndexedDesc = (IndexedPropertyDescriptor)superDesc;
                    if (((IndexedPropertyDescriptor)subDesc).getIndexedReadMethod() == null && superIndexedDesc.getIndexedReadMethod() != null) {
                        ((IndexedPropertyDescriptor)subDesc).setIndexedReadMethod(superIndexedDesc.getIndexedReadMethod());
                    }
                    if (((IndexedPropertyDescriptor)subDesc).getIndexedWriteMethod() == null && superIndexedDesc.getIndexedWriteMethod() != null) {
                        ((IndexedPropertyDescriptor)subDesc).setIndexedWriteMethod(superIndexedDesc.getIndexedWriteMethod());
                    }
                    subMap.put(propertyName, subDesc);
                }
                StandardBeanInfo.mergeAttributes(value, superDesc);
            }
            ++i;
        }
        PropertyDescriptor[] theDescs = new PropertyDescriptor[subMap.size()];
        subMap.values().toArray(theDescs);
        if (defaultPropertyName != null && !this.explicitProperties) {
            int i2 = 0;
            while (i2 < theDescs.length) {
                if (defaultPropertyName.equals(theDescs[i2].getName())) {
                    this.defaultPropertyIndex = i2;
                    break;
                }
                ++i2;
            }
        }
        return theDescs;
    }

    private String capitalize(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() == 0 || name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    private static void mergeAttributes(PropertyDescriptor subDesc, PropertyDescriptor superDesc) {
        subDesc.hidden |= superDesc.hidden;
        subDesc.expert |= superDesc.expert;
        subDesc.preferred |= superDesc.preferred;
        subDesc.bound |= superDesc.bound;
        subDesc.constrained |= superDesc.constrained;
        subDesc.name = superDesc.name;
        if (subDesc.shortDescription == null && superDesc.shortDescription != null) {
            subDesc.shortDescription = superDesc.shortDescription;
        }
        if (subDesc.displayName == null && superDesc.displayName != null) {
            subDesc.displayName = superDesc.displayName;
        }
    }

    private MethodDescriptor[] mergeMethods(MethodDescriptor[] superDescs) {
        HashMap<String, MethodDescriptor> subMap = StandardBeanInfo.internalAsMap(this.methods);
        MethodDescriptor[] methodDescriptorArray = superDescs;
        int n = superDescs.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDescriptor superMethod = methodDescriptorArray[n2];
            String methodName = StandardBeanInfo.getQualifiedName(superMethod.getMethod());
            MethodDescriptor method = subMap.get(methodName);
            if (method == null) {
                subMap.put(methodName, superMethod);
            } else {
                method.merge(superMethod);
            }
            ++n2;
        }
        MethodDescriptor[] theMethods = new MethodDescriptor[subMap.size()];
        subMap.values().toArray(theMethods);
        return theMethods;
    }

    private EventSetDescriptor[] mergeEvents(EventSetDescriptor[] otherEvents, int otherDefaultIndex) {
        HashMap<String, EventSetDescriptor> subMap = StandardBeanInfo.internalAsMap(this.events);
        String defaultEventName = null;
        if (this.defaultEventIndex >= 0 && this.defaultEventIndex < this.events.length) {
            defaultEventName = this.events[this.defaultEventIndex].getName();
        } else if (otherDefaultIndex >= 0 && otherDefaultIndex < otherEvents.length) {
            defaultEventName = otherEvents[otherDefaultIndex].getName();
        }
        EventSetDescriptor[] eventSetDescriptorArray = otherEvents;
        int n = otherEvents.length;
        int n2 = 0;
        while (n2 < n) {
            EventSetDescriptor event = eventSetDescriptorArray[n2];
            String eventName = event.getName();
            EventSetDescriptor subEvent = subMap.get(eventName);
            if (subEvent == null) {
                subMap.put(eventName, event);
            } else {
                subEvent.merge(event);
            }
            ++n2;
        }
        EventSetDescriptor[] theEvents = new EventSetDescriptor[subMap.size()];
        subMap.values().toArray(theEvents);
        if (defaultEventName != null && !this.explicitEvents) {
            int i = 0;
            while (i < theEvents.length) {
                if (defaultEventName.equals(theEvents[i].getName())) {
                    this.defaultEventIndex = i;
                    break;
                }
                ++i;
            }
        }
        return theEvents;
    }

    private static HashMap<String, PropertyDescriptor> internalAsMap(PropertyDescriptor[] propertyDescs) {
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        int i = 0;
        while (i < propertyDescs.length) {
            map.put(propertyDescs[i].getName(), propertyDescs[i]);
            ++i;
        }
        return map;
    }

    private static HashMap<String, MethodDescriptor> internalAsMap(MethodDescriptor[] theDescs) {
        HashMap<String, MethodDescriptor> map = new HashMap<String, MethodDescriptor>();
        int i = 0;
        while (i < theDescs.length) {
            String qualifiedName = StandardBeanInfo.getQualifiedName(theDescs[i].getMethod());
            map.put(qualifiedName, theDescs[i]);
            ++i;
        }
        return map;
    }

    private static HashMap<String, EventSetDescriptor> internalAsMap(EventSetDescriptor[] theDescs) {
        HashMap<String, EventSetDescriptor> map = new HashMap<String, EventSetDescriptor>();
        int i = 0;
        while (i < theDescs.length) {
            map.put(theDescs[i].getName(), theDescs[i]);
            ++i;
        }
        return map;
    }

    private static String getQualifiedName(Method method) {
        String qualifiedName = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes != null) {
            int i = 0;
            while (i < paramTypes.length) {
                qualifiedName = String.valueOf(qualifiedName) + "_" + paramTypes[i].getName();
                ++i;
            }
        }
        return qualifiedName;
    }

    private MethodDescriptor[] introspectMethods() {
        return this.introspectMethods(false, this.beanClass);
    }

    private MethodDescriptor[] introspectMethods(boolean includeSuper) {
        return this.introspectMethods(includeSuper, this.beanClass);
    }

    private MethodDescriptor[] introspectMethods(boolean includeSuper, Class<?> introspectorClass) {
        Method[] basicMethods;
        Method[] methodArray = basicMethods = includeSuper ? introspectorClass.getMethods() : introspectorClass.getDeclaredMethods();
        if (basicMethods == null || basicMethods.length == 0) {
            return null;
        }
        ArrayList<MethodDescriptor> methodList = new ArrayList<MethodDescriptor>(basicMethods.length);
        int i = 0;
        while (i < basicMethods.length) {
            int modifiers = basicMethods[i].getModifiers();
            if (Modifier.isPublic(modifiers)) {
                MethodDescriptor theDescriptor = new MethodDescriptor(basicMethods[i]);
                methodList.add(theDescriptor);
            }
            ++i;
        }
        int methodCount = methodList.size();
        MethodDescriptor[] theMethods = null;
        if (methodCount > 0) {
            theMethods = new MethodDescriptor[methodCount];
            theMethods = methodList.toArray(theMethods);
        }
        return theMethods;
    }

    private PropertyDescriptor[] introspectProperties(Class<?> stopClass) throws IntrospectionException {
        MethodDescriptor[] excludeMethods;
        MethodDescriptor[] methodDescriptors = this.introspectMethods();
        if (methodDescriptors == null) {
            return null;
        }
        ArrayList<MethodDescriptor> methodList = new ArrayList<MethodDescriptor>();
        int index = 0;
        while (index < methodDescriptors.length) {
            int modifiers = methodDescriptors[index].getMethod().getModifiers();
            if (!Modifier.isStatic(modifiers)) {
                methodList.add(methodDescriptors[index]);
            }
            ++index;
        }
        int methodCount = methodList.size();
        MethodDescriptor[] theMethods = null;
        if (methodCount > 0) {
            theMethods = new MethodDescriptor[methodCount];
            theMethods = methodList.toArray(theMethods);
        }
        if (theMethods == null) {
            return null;
        }
        HashMap<String, HashMap> propertyTable = new HashMap<String, HashMap>(theMethods.length);
        int i = 0;
        while (i < theMethods.length) {
            StandardBeanInfo.introspectGet(theMethods[i].getMethod(), propertyTable);
            StandardBeanInfo.introspectSet(theMethods[i].getMethod(), propertyTable);
            ++i;
        }
        this.fixGetSet(propertyTable);
        MethodDescriptor[] allMethods = this.introspectMethods(true);
        if (stopClass != null && (excludeMethods = this.introspectMethods(true, stopClass)) != null) {
            ArrayList<MethodDescriptor> tempMethods = new ArrayList<MethodDescriptor>();
            MethodDescriptor[] methodDescriptorArray = allMethods;
            int n = allMethods.length;
            int n2 = 0;
            while (n2 < n) {
                MethodDescriptor method = methodDescriptorArray[n2];
                if (!this.isInSuper(method, excludeMethods)) {
                    tempMethods.add(method);
                }
                ++n2;
            }
            allMethods = tempMethods.toArray(new MethodDescriptor[0]);
        }
        int i2 = 0;
        while (i2 < allMethods.length) {
            this.introspectPropertyListener(allMethods[i2].getMethod());
            ++i2;
        }
        ArrayList<PropertyDescriptor> propertyList = new ArrayList<PropertyDescriptor>();
        for (Map.Entry<String, HashMap> entry : propertyTable.entrySet()) {
            String propertyName = entry.getKey();
            HashMap table = entry.getValue();
            if (table == null) continue;
            String normalTag = (String)table.get(STR_NORMAL);
            String indexedTag = (String)table.get(STR_INDEXED);
            if (normalTag == null && indexedTag == null) continue;
            Method get = (Method)table.get("normalget");
            Method set = (Method)table.get("normalset");
            Method indexedGet = (Method)table.get("indexedget");
            Method indexedSet = (Method)table.get("indexedset");
            PropertyDescriptor propertyDesc = null;
            if (indexedTag == null) {
                propertyDesc = new PropertyDescriptor(propertyName, get, set);
            } else {
                try {
                    propertyDesc = new IndexedPropertyDescriptor(propertyName, get, set, indexedGet, indexedSet);
                }
                catch (IntrospectionException e) {
                    propertyDesc = new IndexedPropertyDescriptor(propertyName, null, null, indexedGet, indexedSet);
                }
            }
            if (this.canAddPropertyChangeListener && this.canRemovePropertyChangeListener) {
                propertyDesc.setBound(true);
            } else {
                propertyDesc.setBound(false);
            }
            if (table.get(STR_IS_CONSTRAINED) == Boolean.TRUE) {
                propertyDesc.setConstrained(true);
            }
            propertyList.add(propertyDesc);
        }
        PropertyDescriptor[] theProperties = new PropertyDescriptor[propertyList.size()];
        propertyList.toArray(theProperties);
        return theProperties;
    }

    private boolean isInSuper(MethodDescriptor method, MethodDescriptor[] excludeMethods) {
        MethodDescriptor[] methodDescriptorArray = excludeMethods;
        int n = excludeMethods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDescriptor m = methodDescriptorArray[n2];
            if (method.getMethod().equals(m.getMethod())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void introspectPropertyListener(Method theMethod) {
        String methodName = theMethod.getName();
        Class<?>[] param = theMethod.getParameterTypes();
        if (param.length != 1) {
            return;
        }
        if (methodName.equals("addPropertyChangeListener") && param[0].equals(PropertyChangeListener.class)) {
            this.canAddPropertyChangeListener = true;
        }
        if (methodName.equals("removePropertyChangeListener") && param[0].equals(PropertyChangeListener.class)) {
            this.canRemovePropertyChangeListener = true;
        }
    }

    private static void introspectGet(Method theMethod, HashMap<String, HashMap> propertyTable) {
        ArrayList<Method> getters;
        String methodName = theMethod.getName();
        int prefixLength = 0;
        if (methodName == null) {
            return;
        }
        if (methodName.startsWith(PREFIX_GET)) {
            prefixLength = PREFIX_GET.length();
        }
        if (methodName.startsWith(PREFIX_IS)) {
            prefixLength = PREFIX_IS.length();
        }
        if (prefixLength == 0) {
            return;
        }
        String propertyName = Introspector.decapitalize(methodName.substring(prefixLength));
        if (!StandardBeanInfo.isValidProperty(propertyName)) {
            return;
        }
        Class<?> propertyType = theMethod.getReturnType();
        if (propertyType == null || propertyType == Void.TYPE) {
            return;
        }
        if (prefixLength == 2 && propertyType != Boolean.TYPE) {
            return;
        }
        Class<?>[] paramTypes = theMethod.getParameterTypes();
        if (paramTypes.length > 1 || paramTypes.length == 1 && paramTypes[0] != Integer.TYPE) {
            return;
        }
        HashMap<String, ArrayList<Method>> table = propertyTable.get(propertyName);
        if (table == null) {
            table = new HashMap<String, ArrayList<Method>>();
            propertyTable.put(propertyName, table);
        }
        if ((getters = (ArrayList<Method>)table.get(STR_GETTERS)) == null) {
            getters = new ArrayList<Method>();
            table.put(STR_GETTERS, getters);
        }
        getters.add(theMethod);
    }

    private static void introspectSet(Method theMethod, HashMap<String, HashMap> propertyTable) {
        Class<?>[] exceptions;
        ArrayList<Method> setters;
        String methodName = theMethod.getName();
        if (methodName == null) {
            return;
        }
        Class<?> returnType = theMethod.getReturnType();
        if (returnType != Void.TYPE) {
            return;
        }
        if (methodName == null || !methodName.startsWith(PREFIX_SET)) {
            return;
        }
        String propertyName = Introspector.decapitalize(methodName.substring(PREFIX_SET.length()));
        if (!StandardBeanInfo.isValidProperty(propertyName)) {
            return;
        }
        Class<?>[] paramTypes = theMethod.getParameterTypes();
        if (paramTypes.length == 0 || paramTypes.length > 2 || paramTypes.length == 2 && paramTypes[0] != Integer.TYPE) {
            return;
        }
        HashMap<String, Serializable> table = propertyTable.get(propertyName);
        if (table == null) {
            table = new HashMap<String, Serializable>();
            propertyTable.put(propertyName, table);
        }
        if ((setters = (ArrayList<Method>)table.get(STR_SETTERS)) == null) {
            setters = new ArrayList<Method>();
            table.put(STR_SETTERS, setters);
        }
        Class<?>[] classArray = exceptions = theMethod.getExceptionTypes();
        int n = exceptions.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> e = classArray[n2];
            if (e.equals(PropertyVetoException.class)) {
                table.put(STR_IS_CONSTRAINED, Boolean.TRUE);
            }
            ++n2;
        }
        setters.add(theMethod);
    }

    private void fixGetSet(HashMap<String, HashMap> propertyTable) throws IntrospectionException {
        if (propertyTable == null) {
            return;
        }
        for (Map.Entry<String, HashMap> entry : propertyTable.entrySet()) {
            Class<?> propertyType;
            HashMap table = entry.getValue();
            ArrayList getters = (ArrayList)table.get(STR_GETTERS);
            ArrayList setters = (ArrayList)table.get(STR_SETTERS);
            Method normalGetter = null;
            Method indexedGetter = null;
            Object normalSetter = null;
            Object indexedSetter = null;
            Class<?> normalPropType = null;
            Class<?> indexedPropType = null;
            if (getters == null) {
                getters = new ArrayList();
            }
            if (setters == null) {
                setters = new ArrayList();
            }
            Class[] paramTypes = null;
            String methodName = null;
            for (Method getter : getters) {
                paramTypes = getter.getParameterTypes();
                methodName = getter.getName();
                if (!(paramTypes != null && paramTypes.length != 0 || normalGetter != null && !methodName.startsWith(PREFIX_IS))) {
                    normalGetter = getter;
                }
                if (paramTypes == null || paramTypes.length != 1 || paramTypes[0] != Integer.TYPE || indexedGetter != null && !methodName.startsWith(PREFIX_GET) && (!methodName.startsWith(PREFIX_IS) || indexedGetter.getName().startsWith(PREFIX_GET))) continue;
                indexedGetter = getter;
            }
            if (normalGetter != null) {
                propertyType = normalGetter.getReturnType();
                for (Object setter : setters) {
                    if (((Method)setter).getParameterTypes().length != 1 || !propertyType.equals(((Method)setter).getParameterTypes()[0])) continue;
                    normalSetter = setter;
                    break;
                }
            } else {
                Object setter;
                setter = setters.iterator();
                while (setter.hasNext()) {
                    Method setter2 = (Method)setter.next();
                    if (setter2.getParameterTypes().length != 1) continue;
                    normalSetter = setter2;
                }
            }
            if (indexedGetter != null) {
                propertyType = indexedGetter.getReturnType();
                for (Object setter : setters) {
                    if (((Method)setter).getParameterTypes().length != 2 || ((Method)setter).getParameterTypes()[0] != Integer.TYPE || !propertyType.equals(((Method)setter).getParameterTypes()[1])) continue;
                    indexedSetter = setter;
                    break;
                }
            } else {
                for (Method setter2 : setters) {
                    if (setter2.getParameterTypes().length != 2 || setter2.getParameterTypes()[0] != Integer.TYPE) continue;
                    indexedSetter = setter2;
                }
            }
            if (normalGetter != null) {
                normalPropType = normalGetter.getReturnType();
            } else if (normalSetter != null) {
                normalPropType = ((Method)normalSetter).getParameterTypes()[0];
            }
            if (indexedGetter != null) {
                indexedPropType = indexedGetter.getReturnType();
            } else if (indexedSetter != null) {
                indexedPropType = ((Method)indexedSetter).getParameterTypes()[1];
            }
            if (normalGetter != null) {
                normalGetter.getReturnType().isArray();
            }
            if (normalGetter != null && normalSetter != null && (indexedGetter == null || indexedSetter == null)) {
                table.put(STR_NORMAL, STR_VALID);
                table.put("normalget", normalGetter);
                table.put("normalset", normalSetter);
                table.put("normalPropertyType", normalPropType);
                continue;
            }
            if ((normalGetter != null || normalSetter != null) && indexedGetter == null && indexedSetter == null) {
                table.put(STR_NORMAL, STR_VALID);
                table.put("normalget", normalGetter);
                table.put("normalset", normalSetter);
                table.put("normalPropertyType", normalPropType);
                continue;
            }
            if (!(normalGetter == null && normalSetter == null || indexedGetter == null && indexedSetter == null)) {
                if (normalGetter != null && normalSetter != null && indexedGetter != null && indexedSetter != null) {
                    if (indexedGetter.getName().startsWith(PREFIX_GET)) {
                        table.put(STR_NORMAL, STR_VALID);
                        table.put("normalget", normalGetter);
                        table.put("normalset", normalSetter);
                        table.put("normalPropertyType", normalPropType);
                        table.put(STR_INDEXED, STR_VALID);
                        table.put("indexedget", indexedGetter);
                        table.put("indexedset", indexedSetter);
                        table.put("indexedPropertyType", indexedPropType);
                        continue;
                    }
                    if (normalPropType != Boolean.TYPE && normalGetter.getName().startsWith(PREFIX_IS)) {
                        table.put(STR_INDEXED, STR_VALID);
                        table.put("indexedset", indexedSetter);
                        table.put("indexedPropertyType", indexedPropType);
                        continue;
                    }
                    table.put(STR_NORMAL, STR_VALID);
                    table.put("normalget", normalGetter);
                    table.put("normalset", normalSetter);
                    table.put("normalPropertyType", normalPropType);
                    continue;
                }
                if (normalGetter != null && normalSetter == null && indexedGetter != null && indexedSetter != null) {
                    table.put(STR_NORMAL, STR_VALID);
                    table.put("normalget", normalGetter);
                    table.put("normalset", normalSetter);
                    table.put("normalPropertyType", normalPropType);
                    table.put(STR_INDEXED, STR_VALID);
                    if (indexedGetter.getName().startsWith(PREFIX_GET)) {
                        table.put("indexedget", indexedGetter);
                    }
                    table.put("indexedset", indexedSetter);
                    table.put("indexedPropertyType", indexedPropType);
                    continue;
                }
                if (normalGetter == null && normalSetter != null && indexedGetter != null && indexedSetter != null) {
                    table.put(STR_INDEXED, STR_VALID);
                    if (indexedGetter.getName().startsWith(PREFIX_GET)) {
                        table.put("indexedget", indexedGetter);
                    }
                    table.put("indexedset", indexedSetter);
                    table.put("indexedPropertyType", indexedPropType);
                    continue;
                }
                if (normalGetter != null && normalSetter == null && indexedGetter != null && indexedSetter == null) {
                    if (indexedGetter.getName().startsWith(PREFIX_GET)) {
                        table.put(STR_NORMAL, STR_VALID);
                        table.put("normalget", normalGetter);
                        table.put("normalset", normalSetter);
                        table.put("normalPropertyType", normalPropType);
                        table.put(STR_INDEXED, STR_VALID);
                        table.put("indexedget", indexedGetter);
                        table.put("indexedset", indexedSetter);
                        table.put("indexedPropertyType", indexedPropType);
                        continue;
                    }
                    table.put(STR_NORMAL, STR_VALID);
                    table.put("normalget", normalGetter);
                    table.put("normalset", normalSetter);
                    table.put("normalPropertyType", normalPropType);
                    continue;
                }
                if (normalGetter == null && normalSetter != null && indexedGetter != null && indexedSetter == null) {
                    if (indexedGetter.getName().startsWith(PREFIX_GET)) {
                        table.put(STR_NORMAL, STR_VALID);
                        table.put("normalget", normalGetter);
                        table.put("normalset", normalSetter);
                        table.put("normalPropertyType", normalPropType);
                        table.put(STR_INDEXED, STR_VALID);
                        table.put("indexedget", indexedGetter);
                        table.put("indexedset", indexedSetter);
                        table.put("indexedPropertyType", indexedPropType);
                        continue;
                    }
                    table.put(STR_NORMAL, STR_VALID);
                    table.put("normalget", normalGetter);
                    table.put("normalset", normalSetter);
                    table.put("normalPropertyType", normalPropType);
                    continue;
                }
                if (normalGetter != null && normalSetter == null && indexedGetter == null && indexedSetter != null) {
                    table.put(STR_INDEXED, STR_VALID);
                    table.put("indexedget", indexedGetter);
                    table.put("indexedset", indexedSetter);
                    table.put("indexedPropertyType", indexedPropType);
                    continue;
                }
                if (normalGetter == null && normalSetter != null && indexedGetter == null && indexedSetter != null) {
                    table.put(STR_INDEXED, STR_VALID);
                    table.put("indexedget", indexedGetter);
                    table.put("indexedset", indexedSetter);
                    table.put("indexedPropertyType", indexedPropType);
                    continue;
                }
            }
            if (normalSetter == null && normalGetter == null && (indexedGetter != null || indexedSetter != null)) {
                if (indexedGetter != null && indexedGetter.getName().startsWith(PREFIX_IS)) {
                    if (indexedSetter == null) continue;
                    table.put(STR_INDEXED, STR_VALID);
                    table.put("indexedset", indexedSetter);
                    table.put("indexedPropertyType", indexedPropType);
                    continue;
                }
                table.put(STR_INDEXED, STR_VALID);
                table.put("indexedget", indexedGetter);
                table.put("indexedset", indexedSetter);
                table.put("indexedPropertyType", indexedPropType);
                continue;
            }
            if ((normalSetter != null || normalGetter != null) && indexedGetter != null && indexedSetter != null) {
                table.put(STR_INDEXED, STR_VALID);
                table.put("indexedget", indexedGetter);
                table.put("indexedset", indexedSetter);
                table.put("indexedPropertyType", indexedPropType);
                continue;
            }
            table.put(STR_NORMAL, STR_INVALID);
            table.put(STR_INDEXED, STR_INVALID);
        }
    }

    private EventSetDescriptor[] introspectEvents() throws IntrospectionException {
        MethodDescriptor[] theMethods = this.introspectMethods();
        if (theMethods == null) {
            return null;
        }
        HashMap<String, HashMap> eventTable = new HashMap<String, HashMap>(theMethods.length);
        int i = 0;
        while (i < theMethods.length) {
            StandardBeanInfo.introspectListenerMethods(PREFIX_ADD, theMethods[i].getMethod(), eventTable);
            StandardBeanInfo.introspectListenerMethods(PREFIX_REMOVE, theMethods[i].getMethod(), eventTable);
            StandardBeanInfo.introspectGetListenerMethods(theMethods[i].getMethod(), eventTable);
            ++i;
        }
        ArrayList<EventSetDescriptor> eventList = new ArrayList<EventSetDescriptor>();
        for (Map.Entry entry : eventTable.entrySet()) {
            HashMap table = (HashMap)entry.getValue();
            Method add = (Method)table.get(PREFIX_ADD);
            Method remove = (Method)table.get(PREFIX_REMOVE);
            if (add == null || remove == null) continue;
            Method get = (Method)table.get(PREFIX_GET);
            Class listenerType = (Class)table.get("listenerType");
            Method[] listenerMethods = (Method[])table.get("listenerMethods");
            EventSetDescriptor eventSetDescriptor = new EventSetDescriptor(Introspector.decapitalize((String)entry.getKey()), listenerType, listenerMethods, add, remove, get);
            eventSetDescriptor.setUnicast(table.get("isUnicast") != null);
            eventList.add(eventSetDescriptor);
        }
        EventSetDescriptor[] theEvents = new EventSetDescriptor[eventList.size()];
        eventList.toArray(theEvents);
        return theEvents;
    }

    private static void introspectListenerMethods(String type, Method theMethod, HashMap<String, HashMap> methodsTable) {
        Class<?>[] exceptionTypes;
        String methodName = theMethod.getName();
        if (methodName == null) {
            return;
        }
        if (!methodName.startsWith(type) || !methodName.endsWith(SUFFIX_LISTEN)) {
            return;
        }
        String listenerName = methodName.substring(type.length());
        String eventName = listenerName.substring(0, listenerName.lastIndexOf(SUFFIX_LISTEN));
        if (eventName == null || eventName.length() == 0) {
            return;
        }
        Class<?>[] paramTypes = theMethod.getParameterTypes();
        if (paramTypes == null || paramTypes.length != 1) {
            return;
        }
        Class<?> listenerType = paramTypes[0];
        if (!EventListener.class.isAssignableFrom(listenerType)) {
            return;
        }
        if (!listenerType.getName().endsWith(listenerName)) {
            return;
        }
        HashMap<String, Object> table = methodsTable.get(eventName);
        if (table == null) {
            table = new HashMap<String, Object>();
        }
        if (table.get("listenerType") == null) {
            table.put("listenerType", listenerType);
            table.put("listenerMethods", StandardBeanInfo.introspectListenerMethods(listenerType));
        }
        table.put(type, theMethod);
        if (type.equals(PREFIX_ADD) && (exceptionTypes = theMethod.getExceptionTypes()) != null) {
            int i = 0;
            while (i < exceptionTypes.length) {
                if (exceptionTypes[i].getName().equals(TooManyListenersException.class.getName())) {
                    table.put("isUnicast", "true");
                    break;
                }
                ++i;
            }
        }
        methodsTable.put(eventName, table);
    }

    private static Method[] introspectListenerMethods(Class<?> listenerType) {
        Method[] methods = listenerType.getDeclaredMethods();
        ArrayList<Method> list = new ArrayList<Method>();
        int i = 0;
        while (i < methods.length) {
            Class<?>[] paramTypes = methods[i].getParameterTypes();
            if (paramTypes.length == 1 && EventObject.class.isAssignableFrom(paramTypes[0])) {
                list.add(methods[i]);
            }
            ++i;
        }
        Method[] matchedMethods = new Method[list.size()];
        list.toArray(matchedMethods);
        return matchedMethods;
    }

    private static void introspectGetListenerMethods(Method theMethod, HashMap<String, HashMap> methodsTable) {
        String type = PREFIX_GET;
        String methodName = theMethod.getName();
        if (methodName == null) {
            return;
        }
        if (!methodName.startsWith(type) || !methodName.endsWith("Listeners")) {
            return;
        }
        String listenerName = methodName.substring(type.length(), methodName.length() - 1);
        String eventName = listenerName.substring(0, listenerName.lastIndexOf(SUFFIX_LISTEN));
        if (eventName == null || eventName.length() == 0) {
            return;
        }
        Class<?>[] paramTypes = theMethod.getParameterTypes();
        if (paramTypes == null || paramTypes.length != 0) {
            return;
        }
        Class<?> returnType = theMethod.getReturnType();
        if (returnType.getComponentType() == null || !returnType.getComponentType().getName().endsWith(listenerName)) {
            return;
        }
        HashMap<String, Method> table = methodsTable.get(eventName);
        if (table == null) {
            table = new HashMap<String, Method>();
        }
        table.put(type, theMethod);
        methodsTable.put(eventName, table);
    }

    private static boolean isValidProperty(String propertyName) {
        return propertyName != null && propertyName.length() != 0;
    }

    void init() {
        if (this.events == null) {
            this.events = new EventSetDescriptor[0];
        }
        if (this.properties == null) {
            this.properties = new PropertyDescriptor[0];
        }
        if (this.properties != null) {
            String defaultPropertyName = this.defaultPropertyIndex != -1 ? this.properties[this.defaultPropertyIndex].getName() : null;
            Arrays.sort(this.properties, comparator);
            if (defaultPropertyName != null) {
                int i = 0;
                while (i < this.properties.length) {
                    if (defaultPropertyName.equals(this.properties[i].getName())) {
                        this.defaultPropertyIndex = i;
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private static class PropertyComparator
    implements Comparator<PropertyDescriptor> {
        private PropertyComparator() {
        }

        @Override
        public int compare(PropertyDescriptor object1, PropertyDescriptor object2) {
            return object1.getName().compareTo(object2.getName());
        }
    }
}

