/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.beans.editors;

import com.googlecode.openbeans.PropertyEditorSupport;

public final class BooleanEditor
extends PropertyEditorSupport {
    public BooleanEditor(Object source) {
        super(source);
    }

    public BooleanEditor() {
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            throw new NullPointerException();
        }
        if (!"true".equalsIgnoreCase(text) && !"false".equalsIgnoreCase(text)) {
            throw new IllegalArgumentException(text);
        }
        this.setValue(new Boolean(text));
    }

    @Override
    public String getAsText() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        return Boolean.TRUE.equals(value) ? "True" : "False";
    }

    @Override
    public String getJavaInitializationString() {
        return this.getValueAsString();
    }

    @Override
    public String[] getTags() {
        return new String[]{"True", "False"};
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Boolean) {
            super.setValue(value);
        }
    }

    private String getValueAsString() {
        Object value = this.getValue();
        if (value != null) {
            return ((Boolean)value).toString();
        }
        return null;
    }
}

