/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.infrastructure.invoker;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.alibaba.fastjson.util.TypeUtils;
import com.shiji.infrastructure.businessobject.ServiceResponse;
import com.shiji.infrastructure.businessobject.ServiceSession;
import com.shiji.infrastructure.exception.ServiceRuntimeException;
import com.shiji.infrastructure.invoker.InvokerHandlerExt;
import com.shiji.infrastructure.invoker.SpringContext;
import com.shiji.infrastructure.utils.tools.AESCBCUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.HttpHeaders;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class BaseContext {
    private static final Logger log;
    private static final String CR = " <br>          at ";
    private static boolean isDetailException;

    public static ServiceSession getSession(String method, String session, String versionCode, String entId, String userId, String userName, String locale) {
        ServiceSession response = new ServiceSession();
        if (!StringUtils.hasText((String)session)) {
            if (StringUtils.hasText((String)entId)) {
                if (StringUtils.hasText((String)entId)) {
                    response.setEnt_id(Long.parseLong(entId));
                }
            } else {
                response.setEnt_id(0L);
                response.setUser_id(0L);
            }
            if (StringUtils.hasText((String)userId)) {
                response.setUser_id(Long.parseLong(userId));
            }
            response.setUser_name(userName);
            response.setLocale(locale);
        } else if (session != null && !session.equals("")) {
            try {
                session = URLDecoder.decode(session, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u8f6c\u6362Session\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
                session = "{'ent_id':0,'user_id':0}";
            }
            response = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
        }
        return response;
    }

    public static String decrypt(String source, String encodingFormat, String encryptKey, String ivParameter) {
        String response = source;
        try {
            response = AESCBCUtils.decrypt(source, encodingFormat, encryptKey, ivParameter);
        }
        catch (Exception e) {
            log.error("AESCBCUtils.decrypt faiure\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return response;
    }

    public static String encrypt(String source, String encodingFormat, String encryptKey, String ivParameter) {
        String response = source;
        try {
            response = AESCBCUtils.encrypt(source, encodingFormat, encryptKey, ivParameter);
        }
        catch (Exception e) {
            log.error("AESCBCUtils.encrypt faiure\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return response;
    }

    private static JSONObject decrypt(ServiceSession session, String encrypt, String params) {
        JSONObject response = JSON.parseObject((String)params);
        encrypt = response.containsKey((Object)"encrypt") ? "1" : "0";
        Boolean isEncrypt = TypeUtils.castToBoolean((Object)encrypt);
        if (isEncrypt != null && isEncrypt.booleanValue()) {
            JSONObject paramsObject;
            String source = response.getString("encrypt");
            String paramsValue = BaseContext.decrypt(source, session.getEncodingformat(), session.getEncryptKey(), session.getIvparameter());
            response = paramsObject = JSON.parseObject((String)paramsValue);
        }
        if ("true".equals(SpringContext.getEnvironmentVar("request.params.enabled"))) {
            log.info("---->decrypt:{} to {}", (Object)(params + ""), (Object)JSON.toJSONString((Object)response, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        }
        return response;
    }

    public static Triple<ServiceSession, String, String> getActionSession(HttpServletRequest request) {
        String method = request.getParameter("method");
        String session = request.getParameter("session");
        String entId = request.getParameter("ent_id");
        String userId = request.getParameter("user_id");
        String userName = request.getParameter("user_name");
        String menuCode = request.getParameter("menuCode");
        String moduleCode = request.getParameter("moduleCode");
        String versionCode = request.getParameter("versionCode");
        String encrypt = request.getParameter("encrypt");
        String locale = request.getParameter("locale");
        ServiceSession contextSession = BaseContext.getSession(method, session, versionCode, entId, userId, userName, locale);
        contextSession.setMenuCode(menuCode + "");
        contextSession.setModuleCode(moduleCode + "");
        return Triple.of((Object)contextSession, (Object)method, (Object)encrypt);
    }

    public static String onAction(HttpServletRequest request, String params) {
        Triple<ServiceSession, String, String> triple = BaseContext.getActionSession(request);
        ServiceSession session = (ServiceSession)triple.getLeft();
        String method = (String)triple.getMiddle();
        String encrypt = (String)triple.getRight();
        return BaseContext.onActionSession(request, params, session, method, encrypt);
    }

    public static String onActionSession(HttpServletRequest request, String params, ServiceSession session, String method, String encrypt) {
        try {
            int index;
            SpringContext.putSession(session);
            SpringContext.removePageno();
            SpringContext.removePageSize();
            String requestURL = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getServletPath();
            if (request.getQueryString() != null) {
                requestURL = requestURL + "?" + request.getQueryString();
            }
            log.info("\u8bf7\u6c42\u5730\u5740:{} \u8bf7\u6c42\u53c2\u6570:{}", (Object)requestURL, (Object)params);
            String beanName = null;
            String methodName = null;
            if (StringUtils.hasText((String)method)) {
                index = method.lastIndexOf(".");
                if (index <= 0) {
                    ServiceResponse response = ServiceResponse.buildFailure(session, "10000", "\u8bf7\u6c42\u6620\u5c04\u65b9\u6cd5\u9519\u8bef");
                    return JSON.toJSONString((Object)response);
                }
            } else {
                ServiceResponse response = ServiceResponse.buildFailure(session, "10000", "\u672a\u627e\u5230\u8bf7\u6c42\u6620\u5c04\u65b9\u6cd5");
                return JSON.toJSONString((Object)response);
            }
            beanName = method.substring(0, index);
            methodName = method.substring(index + 1);
            String component = String.format("%1$s.%2$s", beanName, methodName);
            log.debug("\u8bf7\u6c42\u65b9\u6cd5\u4e3a:{}", (Object)component);
            JSONObject paramsObjec = BaseContext.decrypt(session, encrypt, params);
            InvokerHandlerExt invoker = SpringContext.getBean(InvokerHandlerExt.class, new Object[0]);
            Object response = invoker.invoke(component, paramsObjec);
            return JSON.toJSONString((Object)BaseContext.toNormalJSONObject(response));
        }
        catch (IllegalArgumentException e) {
            log.error(e.getMessage(), (Throwable)e);
            return JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "10000", e.getMessage()));
        }
        catch (ServiceRuntimeException ex) {
            return JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getCode(), ex.getMessage()));
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "10000", BaseContext.getLastExceptionMessage(ex)));
        }
    }

    public static String getLastExceptionMessage(Exception e) {
        return BaseContext.getLastExceptionMessage(e, isDetailException);
    }

    protected static String getLastExceptionMessage(Exception e, boolean all) {
        Throwable t = e;
        if (e instanceof InvocationTargetException) {
            t = ((InvocationTargetException)e).getTargetException();
        } else {
            while ((t = t.getCause()) != null && t.getCause() != null) {
            }
            if (t == null) {
                t = e;
            }
        }
        String errmsg = t.getClass().getName() + ": " + t.getMessage();
        StackTraceElement[] stes = t.getStackTrace();
        if (stes != null && stes.length > 0) {
            errmsg = errmsg + CR + stes[0].toString();
            if (all) {
                StringBuffer sb = new StringBuffer();
                for (int i = 1; i < stes.length; ++i) {
                    sb.append(CR + stes[i].toString());
                }
                errmsg = errmsg + sb.toString();
            } else {
                String privmsg = null;
                String currmsg = null;
                for (int i = 1; i < stes.length; ++i) {
                    privmsg = stes[i - 1].toString();
                    if (stes[i].toString().indexOf("com.efuture.omd") < 0) continue;
                    if (i == 1) {
                        privmsg = null;
                    }
                    currmsg = stes[i].toString();
                    break;
                }
                if (currmsg != null) {
                    if (privmsg != null) {
                        errmsg = errmsg + " <br>          at ... <br>          at " + privmsg;
                    }
                    errmsg = errmsg + CR + currmsg;
                }
            }
        }
        return errmsg;
    }

    public static Object toNormalJSONObject(Object data) {
        return BaseContext.toNormalJSONObject(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String toJSONStringWithDateFormat(Object object, String dateFormat, SerializerFeature ... features) {
        try (SerializeWriter out = new SerializeWriter();){
            JSON.DEFFAULT_DATE_FORMAT = dateFormat;
            String string = JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
            return string;
        }
    }

    public static Object toNormalJSONObject(Object data, Map<String, Object> config) {
        JSONObject jsondata = null;
        if (data instanceof JSONObject) {
            jsondata = (JSONObject)data;
        } else {
            try {
                if (config == null || config.size() < 1) {
                    jsondata = JSON.parseObject((String)BaseContext.toJSONStringWithDateFormat(data, "yyyy-MM-dd HH:mm:ss", new SerializerFeature[0]));
                } else {
                    final HashMap<String, SimpleDateFormat> params = new HashMap<String, SimpleDateFormat>();
                    Set<String> keySet = config.keySet();
                    for (String field : keySet) {
                        SimpleDateFormat format = new SimpleDateFormat(config.get(field).toString());
                        params.put(field, format);
                    }
                    jsondata = JSON.parseObject((String)JSON.toJSONString((Object)data, (SerializeFilter)new ValueFilter(){

                        public Object process(Object object, String name, Object value) {
                            if (params.containsKey(name)) {
                                DateFormat format = (DateFormat)params.get(name);
                                return format.format(value);
                            }
                            return value;
                        }
                    }, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
                }
            }
            catch (Exception ex) {
                return data;
            }
        }
        Set keys = jsondata.keySet();
        for (String key : keys) {
            if (jsondata.get((Object)key) instanceof Long) {
                jsondata.put(key, (Object)String.valueOf(jsondata.getLong(key)));
                continue;
            }
            if (jsondata.get((Object)key) instanceof Double || jsondata.get((Object)key) instanceof Float || jsondata.get((Object)key) instanceof BigDecimal) {
                double value;
                String xiaoShuValue2;
                String strValue = jsondata.getString(key);
                int index = strValue.indexOf(46);
                if (index < 0 || !strValue.endsWith("99999") && !strValue.endsWith("00001") || "".equals(xiaoShuValue2 = strValue.substring(index + 1)) || xiaoShuValue2.length() < 6) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("0.");
                for (int i = 0; i < xiaoShuValue2.length() - 1; ++i) {
                    sb.append("0");
                }
                sb.append("1");
                if (strValue.endsWith("99999")) {
                    value = Double.parseDouble(strValue) + Double.parseDouble(sb.toString());
                    jsondata.put(key, (Object)value);
                } else {
                    value = Double.parseDouble(strValue) - Double.parseDouble(sb.toString());
                }
                jsondata.put(key, (Object)value);
                continue;
            }
            if (jsondata.get((Object)key) instanceof JSONObject) {
                jsondata.put(key, BaseContext.toNormalJSONObject(jsondata.getJSONObject(key)));
                continue;
            }
            if (jsondata.get((Object)key) instanceof JSONArray) {
                JSONArray array = jsondata.getJSONArray(key);
                for (int i = 0; i < array.size(); ++i) {
                    Object o = array.get(i);
                    if (o instanceof Long || o instanceof Float || o instanceof Double) {
                        array.set(i, (Object)String.valueOf(o));
                        continue;
                    }
                    if (o instanceof Double || o instanceof Float || o instanceof BigDecimal) {
                        String xiaoShuValue2;
                        String strValue = o.toString();
                        int index = strValue.indexOf(46);
                        if (index < 0 || !strValue.endsWith("99999") && !strValue.endsWith("00001") || "".equals(xiaoShuValue2 = strValue.substring(index + 1)) || xiaoShuValue2.length() < 6) continue;
                        StringBuilder sb = new StringBuilder();
                        sb.append("0.");
                        for (int j = 0; j < xiaoShuValue2.length() - 1; ++j) {
                            sb.append("0");
                        }
                        sb.append("1");
                        double value = strValue.endsWith("99999") ? Double.parseDouble(strValue) + Double.parseDouble(sb.toString()) : Double.parseDouble(strValue) - Double.parseDouble(sb.toString());
                        array.set(i, (Object)value);
                        continue;
                    }
                    if (jsondata.get((Object)key) instanceof String) {
                        if (!jsondata.get((Object)key).equals("true") && !jsondata.get((Object)key).equals("false")) continue;
                        jsondata.put(key, (Object)TypeUtils.castToBoolean((Object)jsondata.get((Object)key)));
                        continue;
                    }
                    if (!(o instanceof JSONObject)) continue;
                    array.set(i, BaseContext.toNormalJSONObject(o));
                }
                continue;
            }
            if (!(jsondata.get((Object)key) instanceof String) || !jsondata.get((Object)key).equals("true") && !jsondata.get((Object)key).equals("false")) continue;
            jsondata.put(key, (Object)TypeUtils.castToBoolean((Object)jsondata.get((Object)key)));
        }
        return jsondata;
    }

    public static boolean stringArrayContainsKey(String[] array, String key, boolean ignoreCase) {
        if (array == null) {
            return false;
        }
        for (String k : array) {
            if (!(ignoreCase ? key.equalsIgnoreCase(k) : key.equals(k))) continue;
            return true;
        }
        return false;
    }

    public static String builderContentDispositionFileName(HttpHeaders headers, String filename) {
        String contentDisposition = "attachment;";
        try {
            String browser = headers.getRequestHeader("User-Agent").toString();
            contentDisposition = browser != null && browser.toLowerCase().indexOf("firefox") > 0 ? contentDisposition + "filename*=UTF-8''" + URLEncoder.encode(filename, "UTF-8") : contentDisposition + "filename=" + URLEncoder.encode(filename, "UTF-8");
        }
        catch (Exception ex) {
            contentDisposition = contentDisposition + "filename=" + filename;
        }
        return contentDisposition;
    }

    public static <T> List<T> toList(List<Map<String, Object>> dataList, Class<T> classzz) {
        ArrayList<Object> response = new ArrayList<Object>();
        for (Map<String, Object> itemRow : dataList) {
            Object value = TypeUtils.castToJavaBean(itemRow, classzz);
            response.add(value);
        }
        return response;
    }

    static {
        ServletContext sc;
        log = LoggerFactory.getLogger(BaseContext.class);
        isDetailException = false;
        WebApplicationContext cont = ContextLoader.getCurrentWebApplicationContext();
        if (cont != null && (sc = cont.getServletContext()) != null && "true".equalsIgnoreCase(sc.getInitParameter("detailException"))) {
            isDetailException = true;
        }
    }
}

