/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.infrastructure.repository.dataobject;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class TaskDO<T>
implements Delayed {
    private final T value;
    private final long expireTime;
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public TaskDO(T value, TimeUnit timeUnit, Long units) {
        this.value = value;
        Long delayInMillis = timeUnit.toMillis(units);
        this.expireTime = System.currentTimeMillis() + delayInMillis;
        System.out.println(String.format("Current: %1$s Action: %2$s", dateFormat.format(System.currentTimeMillis()), dateFormat.format(this.expireTime)));
    }

    @Override
    public int compareTo(Delayed o) {
        return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), o.getDelay(TimeUnit.MILLISECONDS));
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.expireTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public T getValue() {
        return this.value;
    }
}

