/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.infrastructure.repository.impl;

import com.shiji.infrastructure.repository.DelayQueueRepository;
import com.shiji.infrastructure.repository.dataobject.TaskDO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayQueueRepositoryImpl<T>
implements DelayQueueRepository<T> {
    private static final Logger log = LoggerFactory.getLogger(DelayQueueRepositoryImpl.class);
    private final DelayQueue<TaskDO<T>> delayQueue = new DelayQueue();

    @Override
    public void push(T value, TimeUnit unit, long delay) {
        this.delayQueue.put(new TaskDO<T>(value, unit, delay));
        log.info("\u4ee4\u724c\u5ef6\u8fdf\u961f\u5217\u5f00\u59cb\u65f6\u95f4:" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
    }

    @Override
    public void onAction(T value) {
        System.out.println("DelayQueueRepository::onAction->" + value.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onQueue() {
        try {
            while (true) {
                TaskDO task = (TaskDO)this.delayQueue.take();
                log.info("DelayQueueRepository::onQueue \u83b7\u53d6\u5230\u547d\u4ee4:{}", (Object)task.getValue().toString());
                DelayQueueRepositoryImpl delayQueueRepositoryImpl = this;
                synchronized (delayQueueRepositoryImpl) {
                    this.onAction(task.getValue());
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }
}

