/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.infrastructure.utils.statement.update;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class Update {
    private String tableName;
    private Map<String, String> setMap;
    private Map<String, String> whereMap;

    public static Update create(String tableName) {
        Update instance = new Update();
        instance.tableName = tableName;
        instance.setMap = new LinkedHashMap<String, String>();
        instance.whereMap = new LinkedHashMap<String, String>();
        return instance;
    }

    public Update set(String columnName) {
        this.set(columnName, columnName);
        return this;
    }

    public Update set(String columnName, String value) {
        this.setMap.put(columnName, value);
        return this;
    }

    public Update where(String columnName) {
        this.where(columnName, columnName);
        return this;
    }

    public Update where(String columnName, String value) {
        this.whereMap.put(columnName, value);
        return this;
    }

    public String generate() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(String.format("UPDATE %1$s", this.tableName));
        String setValue = this.setMap.entrySet().stream().map(p -> String.format("%1$s=:%2$s", p.getKey(), p.getValue())).collect(Collectors.joining(","));
        list.add(String.format("   SET %1$s", setValue));
        String whereValue = this.whereMap.entrySet().stream().map(p -> String.format("%1$s=:%2$s", p.getKey(), p.getValue())).collect(Collectors.joining(" AND "));
        list.add(String.format(" WHERE %1$s", whereValue));
        return list.stream().collect(Collectors.joining(" \n"));
    }
}

