/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.infrastructure.utils.string;

import com.shiji.infrastructure.utils.tools.MapAs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserUtils {
    private static final Logger log = LoggerFactory.getLogger(ParserUtils.class);

    public static String onChineseNumberConverter(String message) {
        Map<Character, Integer> charMap = MapAs.of(Character.valueOf('\u4e00'), 1, Character.valueOf('\u4e8c'), 2, Character.valueOf('\u4e09'), 3, Character.valueOf('\u56db'), 4, Character.valueOf('\u4e94'), 5, Character.valueOf('\u516d'), 6, Character.valueOf('\u4e03'), 7, Character.valueOf('\u516b'), 8, Character.valueOf('\u4e5d'), 9, Character.valueOf('\u96f6'), 0);
        return message.chars().mapToObj(c -> Character.valueOf((char)c)).map(c -> charMap.containsKey(c) ? String.valueOf(charMap.get(c)) : String.valueOf(c)).collect(Collectors.joining());
    }

    public static <T> T nullConvert(T value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static <T> T nullConvert(Map<String, Object> paramsMap, String keyName, T defaultValue) {
        Object value;
        if (paramsMap != null && paramsMap.containsKey(keyName) && (value = paramsMap.getOrDefault(keyName, defaultValue)) != null) {
            return (T)value;
        }
        return defaultValue;
    }

    public static String underlineToCamelCase(String underscoreName) {
        StringBuilder result = new StringBuilder();
        if (underscoreName != null && underscoreName.trim().length() > 0) {
            boolean flag = false;
            for (int i = 0; i < underscoreName.length(); ++i) {
                char ch = underscoreName.charAt(i);
                if ("_".charAt(0) == ch) {
                    flag = true;
                    continue;
                }
                if (flag) {
                    result.append(Character.toUpperCase(ch));
                    flag = false;
                    continue;
                }
                result.append(ch);
            }
        }
        return result.toString();
    }

    public static String upperCaseFirst(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String lowerCaseFirst(String str) {
        return str != null && str.length() > 1 ? str.substring(0, 1).toLowerCase() + str.substring(1) : "";
    }

    public static String parsePlaceHolder(String openToken, String closeToken, String text, Object ... args) {
        return ParserUtils.parseHolder(openToken, closeToken, text, null, null, args);
    }

    public static String parseNameHolderObject(String openToken, String closeToken, String text, Map<String, Object> paramsMap) {
        BiFunction<String, Map<String, Object>, Object> biFunction = (keyCode, nameMap) -> {
            if (nameMap.containsKey(keyCode)) {
                return nameMap.get(keyCode);
            }
            return "";
        };
        return ParserUtils.parseHolderObject(openToken, closeToken, text, biFunction, paramsMap, new Object[0]);
    }

    public static String parseNameHolder(String openToken, String closeToken, String text, Map<String, String> paramsMap) {
        BiFunction<String, Map<String, String>, String> biFunction = (keyCode, nameMap) -> {
            if (nameMap.containsKey(keyCode)) {
                return (String)nameMap.get(keyCode);
            }
            return "";
        };
        return ParserUtils.parseHolder(openToken, closeToken, text, biFunction, paramsMap, new Object[0]);
    }

    private static String parseHolderObject(String openToken, String closeToken, String text, BiFunction<String, Map<String, Object>, Object> function, Map<String, Object> paramsMap, Object ... args) {
        int argsIndex = 0;
        if (text == null || text.isEmpty()) {
            return "";
        }
        char[] src = text.toCharArray();
        int offset = 0;
        int start = text.indexOf(openToken, offset);
        if (start == -1) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        StringBuilder expression = null;
        while (start > -1) {
            if (start > 0 && src[start - 1] == '\\') {
                builder.append(src, offset, start - offset - 1).append(openToken);
                offset = start + openToken.length();
            } else {
                if (expression == null) {
                    expression = new StringBuilder();
                } else {
                    expression.setLength(0);
                }
                builder.append(src, offset, start - offset);
                offset = start + openToken.length();
                int end = text.indexOf(closeToken, offset);
                while (end > -1) {
                    if (end > offset && src[end - 1] == '\\') {
                        expression.append(src, offset, end - offset - 1).append(closeToken);
                        offset = end + closeToken.length();
                        end = text.indexOf(closeToken, offset);
                        continue;
                    }
                    expression.append(src, offset, end - offset);
                    offset = end + closeToken.length();
                    break;
                }
                if (end == -1) {
                    builder.append(src, start, src.length - start);
                    offset = src.length;
                } else {
                    String value;
                    String original = expression.toString();
                    log.debug("original value:{}", (Object)original);
                    String string = argsIndex <= args.length - 1 ? (args[argsIndex] == null ? "" : args[argsIndex].toString()) : (value = original);
                    if (function != null && paramsMap != null) {
                        value = function.apply(original, paramsMap).toString();
                    }
                    log.debug("original value:{} target value:{}", (Object)original, (Object)value);
                    builder.append(value);
                    offset = end + closeToken.length();
                    ++argsIndex;
                }
            }
            start = text.indexOf(openToken, offset);
        }
        if (offset < src.length) {
            builder.append(src, offset, src.length - offset);
        }
        return builder.toString();
    }

    public static String parseHolder(String openToken, String closeToken, String text, BiFunction<String, Map<String, String>, String> function, Map<String, String> paramsMap, Object ... args) {
        int argsIndex = 0;
        if (text == null || text.isEmpty()) {
            return "";
        }
        char[] src = text.toCharArray();
        int offset = 0;
        int start = text.indexOf(openToken, offset);
        if (start == -1) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        StringBuilder expression = null;
        while (start > -1) {
            if (start > 0 && src[start - 1] == '\\') {
                builder.append(src, offset, start - offset - 1).append(openToken);
                offset = start + openToken.length();
            } else {
                if (expression == null) {
                    expression = new StringBuilder();
                } else {
                    expression.setLength(0);
                }
                builder.append(src, offset, start - offset);
                offset = start + openToken.length();
                int end = text.indexOf(closeToken, offset);
                while (end > -1) {
                    if (end > offset && src[end - 1] == '\\') {
                        expression.append(src, offset, end - offset - 1).append(closeToken);
                        offset = end + closeToken.length();
                        end = text.indexOf(closeToken, offset);
                        continue;
                    }
                    expression.append(src, offset, end - offset);
                    offset = end + closeToken.length();
                    break;
                }
                if (end == -1) {
                    builder.append(src, start, src.length - start);
                    offset = src.length;
                } else {
                    String value;
                    String original = expression.toString();
                    log.debug("original value:{}", (Object)original);
                    String string = argsIndex <= args.length - 1 ? (args[argsIndex] == null ? "" : args[argsIndex].toString()) : (value = original);
                    if (function != null && paramsMap != null) {
                        value = function.apply(original, paramsMap);
                    }
                    log.debug("original value:{} target value:{}", (Object)original, (Object)value);
                    builder.append(value);
                    offset = end + closeToken.length();
                    ++argsIndex;
                }
            }
            start = text.indexOf(openToken, offset);
        }
        if (offset < src.length) {
            builder.append(src, offset, src.length - offset);
        }
        return builder.toString();
    }

    public static List<String> parseHolderStringList(String openToken, String closeToken, String text) {
        ArrayList<String> list = new ArrayList<String>();
        if (text == null || text.isEmpty()) {
            return list;
        }
        int startIndex = text.indexOf(openToken);
        while (startIndex != -1) {
            int endIndex = text.indexOf(closeToken, startIndex);
            if (endIndex != -1) {
                String substring = text.substring(startIndex + 2, endIndex);
                list.add(substring);
            }
            startIndex = text.indexOf(openToken, endIndex);
        }
        return list;
    }
}

