/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.infrastructure.utils.tools;

import com.alibaba.fastjson.parser.ParserConfig;
import com.shiji.infrastructure.annotation.KeepTransient;
import com.shiji.infrastructure.exception.BaseException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.annotation.Transient;

public class ReflectUtils {
    public static final boolean isJavaBean(Class<?> type) {
        if (null == type) {
            throw new NullPointerException();
        }
        return !ParserConfig.getGlobalInstance().isPrimitive(type);
    }

    public static final Class<?> getClass(Object obj) {
        Class<?> clazz = obj.getClass();
        String className = clazz.getName();
        if (className.contains("$$")) {
            String realClazzName = className.substring(0, className.indexOf("$$"));
            try {
                clazz = Class.forName(realClazzName);
            }
            catch (ClassNotFoundException e) {
                throw new BaseException("-1", e.getMessage(), e);
            }
        }
        return clazz;
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tempClass = clazz; tempClass != null; tempClass = tempClass.getSuperclass()) {
            Field[] tmpFieldList;
            for (Field field : tmpFieldList = tempClass.getDeclaredFields()) {
                String str = field.toString();
                if (str.contains("final ") || str.contains("static ")) continue;
                fieldList.add(field);
            }
        }
        return fieldList;
    }

    public static List<Field> getAllFieldsFilterTransient(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tempClass = clazz; tempClass != null; tempClass = tempClass.getSuperclass()) {
            Field[] tmpFieldList;
            for (Field field : tmpFieldList = tempClass.getDeclaredFields()) {
                String str = field.toString();
                if (Modifier.isStatic(field.getModifiers()) || str.contains("final ") || str.contains("static ") || field.getAnnotation(Transient.class) != null || field.getAnnotation(KeepTransient.class) != null) continue;
                fieldList.add(field);
            }
        }
        return fieldList;
    }
}

