/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.infrastructure.validation;

import com.shiji.infrastructure.utils.string.StringFormat;
import com.shiji.infrastructure.utils.tools.MapAs;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.metadata.ConstraintDescriptor;

public class BeanValidator {
    final Map<String, String> messageMap;
    Map<String, Object> normalMap;
    Map<Class<?>, BiFunction<Annotation, String, String>> functionMap;

    private BeanValidator(Map<String, String> messageMap) {
        this.messageMap = messageMap;
        this.init();
    }

    private void init() {
        this.normalMap = MapAs.of("javax.validation.constraints.NotNull.message", "{1}\u4e0d\u5141\u8bb8\u4e3a\u7a7a", "javax.validation.constraints.NotEmpty.message", "{1}\u5fc5\u987b\u6307\u5b9a\u503c", "org.hibernate.validator.constraints.NotEmpty.message", "{1}\u5fc5\u987b\u6307\u5b9a\u503c");
        this.functionMap = new LinkedHashMap();
        this.functionMap.put(NotEmpty.class, this::onNotEmpty);
        this.functionMap.put(NotNull.class, this::onNotNull);
        this.functionMap.put(org.hibernate.validator.constraints.NotEmpty.class, this::onHibernateNotEmpty);
    }

    public static Builder builder() {
        Builder builder = new Builder();
        return builder;
    }

    public static Builder builder(Map<String, String> messageMap) {
        Builder builder = new Builder(messageMap);
        return builder;
    }

    protected String onNotEmpty(Annotation annotation, String caption) {
        NotEmpty notEmpty = (NotEmpty)annotation;
        String value = notEmpty.message();
        value = StringFormat.namedFormat(value, this.normalMap);
        value = StringFormat.indexFormat("{", "}", value, caption);
        return value;
    }

    protected String onNotNull(Annotation annotation, String caption) {
        NotNull notNull = (NotNull)annotation;
        String value = notNull.message();
        value = StringFormat.namedFormat(value, this.normalMap);
        value = StringFormat.indexFormat("{", "}", value, caption);
        return value;
    }

    protected String onHibernateNotEmpty(Annotation annotation, String caption) {
        org.hibernate.validator.constraints.NotEmpty notEmpty = (org.hibernate.validator.constraints.NotEmpty)annotation;
        String value = notEmpty.message();
        value = StringFormat.namedFormat(value, this.normalMap);
        value = StringFormat.indexFormat("{", "}", value, caption);
        return value;
    }

    public <T> String validate(Set<ConstraintViolation<T>> violations, String prefix, boolean full) {
        ArrayList<String> responseList = new ArrayList<String>();
        for (ConstraintViolation<T> violation : violations) {
            ConstraintDescriptor constraintDescriptor;
            Annotation annotation;
            Class<? extends Annotation> annotationType;
            String propertyPath = violation.getPropertyPath().toString();
            String defaultMessage = violation.getMessage();
            String caption = propertyPath;
            if (this.messageMap.containsKey(propertyPath)) {
                caption = this.messageMap.get(propertyPath);
            }
            if (this.functionMap.containsKey(annotationType = (annotation = (constraintDescriptor = violation.getConstraintDescriptor()).getAnnotation()).annotationType())) {
                BiFunction<Annotation, String, String> handler = this.functionMap.get(annotationType);
                String value = handler.apply(annotation, caption);
                responseList.add(String.format("%1$s%2$s", prefix + "", value));
            } else {
                responseList.add(String.format("%1$s%2$s", prefix + "", defaultMessage));
            }
            if (full) continue;
            return (String)responseList.get(0);
        }
        return responseList.stream().collect(Collectors.joining("\u3001"));
    }

    public <T> Set<ConstraintViolation<T>> validate(T model) {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate(model, new Class[0]);
        return violations;
    }

    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> modelCls, String propertyName, Object propertyValue, Class<?> ... clsArgs) {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validateValue(modelCls, propertyName, propertyValue, (Class[])clsArgs);
        return violations;
    }

    public <T> String validateProperty(T model, String propertyName, String prefix, Class<?> ... clsArgs) {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validateProperty(model, propertyName, (Class[])clsArgs);
        return this.validate(violations, prefix, true);
    }

    public <T> String validate(T model, boolean full, String prefix, Class<?> ... clsArgs) {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate(model, (Class[])clsArgs);
        return this.validate(violations, prefix, full);
    }

    public static class Builder {
        private Map<String, String> conf;

        public Builder() {
            this.conf = new LinkedHashMap<String, String>();
        }

        public Builder(Map<String, String> conf) {
            this.conf = conf;
        }

        public Builder set(String dataKey, String value) {
            this.conf.put(dataKey, value);
            return this;
        }

        public BeanValidator build() {
            BeanValidator instance = new BeanValidator(this.conf);
            return instance;
        }
    }
}

