/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.infrastructure.validation;

import com.shiji.infrastructure.validation.ModelValidation;
import com.shiji.infrastructure.validation.ValidationFunction;
import java.lang.reflect.Field;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelValidator
implements ConstraintValidator<ModelValidation, Object> {
    private static final Logger log = LoggerFactory.getLogger(ModelValidator.class);
    private String fieldName;
    private String functionName;
    private boolean skipNull;

    public void initialize(ModelValidation constraintAnnotation) {
        this.fieldName = constraintAnnotation.fieldName();
        this.functionName = constraintAnnotation.functionName();
        this.skipNull = constraintAnnotation.skipNull();
        log.info("ModelValidator::initialize -> {}", (Object)this.fieldName);
    }

    private Object getValue(Object target, String fieldName) {
        try {
            Field field = target.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Object fieldValue = field.get(target);
            return fieldValue;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isValid(Object object, ConstraintValidatorContext context) {
        log.info("ModelValidator::initialize -> {}", (Object)this.fieldName);
        if (object == null) {
            return this.skipNull;
        }
        try {
            Object fieldValue = this.getValue(object, this.fieldName);
            Object functionValue = this.getValue(object, this.functionName);
            if (fieldValue == null || functionValue == null) {
                if (this.skipNull) {
                    log.info("ModelValidator::initialize skipNull -> {}", (Object)this.fieldName);
                    return true;
                }
                log.info("ModelValidator::initialize faiure of Null -> {}", (Object)this.fieldName);
                return false;
            }
            ValidationFunction function = (target, field, value) -> true;
            if (function instanceof ValidationFunction) {
                ValidationFunction handle = (ValidationFunction)functionValue;
                return handle.apply(object, this.fieldName, fieldValue);
            }
            log.error("ModelValidator::initialize {} is not an instance of Function", (Object)this.functionName);
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u6821\u9a8c\u5931\u8d25\uff0c\u539f\u56e0:{}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return false;
    }
}

