/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos;

import com.xuanwu.mos.common.util.CommonUtil;
import com.xuanwu.mos.common.util.StringUtils;

public class HostInfo {
    private String ip;
    private int port;
    private String username;
    private String password;
    private ConnectionType type = ConnectionType.DIRECT;
    private int retryTimes = -1;
    private int retryInterval = -1;
    private int bindLocalPort = -1;

    public HostInfo(String ip, int port) {
        this.setHost(ip, port);
    }

    public void setHost(String ip, int port) {
        if (StringUtils.isBlank(ip)) {
            throw new IllegalArgumentException("IP can't be empty");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port out of range:" + port);
        }
        this.ip = ip;
        this.port = port;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.ip + ":" + this.port;
    }

    public final boolean equals(Object anotherObj) {
        if (anotherObj == null || !(anotherObj instanceof HostInfo)) {
            return false;
        }
        HostInfo anotherHost = (HostInfo)anotherObj;
        boolean sameIP = false;
        sameIP = this.ip != null ? this.ip.equals(anotherHost.ip) : this.ip == null && anotherHost.ip == null;
        return sameIP && this.port == anotherHost.port;
    }

    public boolean needLogin() {
        return CommonUtil.isNotBlank(this.username);
    }

    public final int hashCode() {
        if (this.ip != null) {
            return this.ip.hashCode() + this.port;
        }
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ConnectionType getType() {
        return this.type;
    }

    public void setType(ConnectionType type) {
        this.type = type;
    }

    public void setIp(String ip) {
        if (!CommonUtil.isIP(ip)) {
            throw new IllegalArgumentException("Invalid IP Address");
        }
        this.ip = ip;
    }

    public void setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port out of range:" + port);
        }
        this.port = port;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public int getBindLocalPort() {
        return this.bindLocalPort;
    }

    public void setBindLocalPort(int bindLocalPort) {
        if (bindLocalPort < 1 || bindLocalPort > 65535) {
            throw new IllegalArgumentException("bindLocalPort out of range:" + bindLocalPort);
        }
        this.bindLocalPort = bindLocalPort;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionType {
        DIRECT(0),
        SOCKET4(1),
        SOCKET5(2);

        private final int index;

        private ConnectionType(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static ConnectionType getType(int index) {
            switch (index) {
                case 0: {
                    return DIRECT;
                }
                case 1: {
                    return SOCKET4;
                }
                case 2: {
                    return SOCKET5;
                }
            }
            return DIRECT;
        }
    }
}

