/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos;

import com.xuanwu.mos.HostInfo;
import com.xuanwu.mos.PostMsgBuilder;
import com.xuanwu.mos.ProxyServer;
import com.xuanwu.mos.common.MOSupport;
import com.xuanwu.mos.common.MTSupport;
import com.xuanwu.mos.common.entity.Account;
import com.xuanwu.mos.common.entity.AccountInfo;
import com.xuanwu.mos.common.entity.BusinessType;
import com.xuanwu.mos.common.entity.GsmsResponse;
import com.xuanwu.mos.common.entity.MOMsg;
import com.xuanwu.mos.common.entity.MTPack;
import com.xuanwu.mos.common.entity.MTReport;
import com.xuanwu.mos.common.entity.MTResponse;
import com.xuanwu.mos.common.entity.TicketInfo;
import com.xuanwu.mos.common.log.PostMsgLogger;
import com.xuanwu.mos.common.util.CommonUtil;
import com.xuanwu.mos.common.util.Interceptor;
import com.xuanwu.mos.config.ConfigControlCenter;
import com.xuanwu.mos.ha.HAMonitor;
import com.xuanwu.mos.ha.MoInvokeAdaptor;
import com.xuanwu.mos.ha.MtInvokeAdaptor;
import com.xuanwu.mos.msggate.protobuf.CommonItem;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostMsg {
    private volatile HostInfo gwHost = new HostInfo("211.147.239.62", 9080);
    private volatile HostInfo wsHost = new HostInfo("211.147.239.62", 9070);
    private ProxyServer proxy;
    private boolean autoConfirm = true;
    private static volatile boolean highAvailability = false;
    private static volatile HAMonitor haMonitor;
    private PostMsgBuilder builder;

    protected PostMsg(PostMsgBuilder builder) {
        this.builder = builder;
        this.proxy = new ProxyServer(this.gwHost, this.wsHost, builder.shortConnMode, builder.soTimeout, builder.mtMaxConn, builder.moMaxConn);
        ConfigControlCenter.initialize(this);
    }

    public HostInfo getGwHost() {
        return this.gwHost;
    }

    public HostInfo getWsHost() {
        return this.wsHost;
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    public GsmsResponse post(final Account account, final MTPack pack) throws Exception {
        MTSupport.verifyPack(pack);
        if (pack.getBatchID() == null) {
            pack.setBatchID(UUID.randomUUID());
        }
        return this.mtHAInvokeAdapt(new MtInvokeAdaptor(){

            public GsmsResponse invoke() throws Exception {
                return PostMsg.this.proxy.sendMessage(account, pack);
            }
        }, account, "post");
    }

    public void setInterceptor(Interceptor interceptor) {
        this.proxy.setInterceptor(interceptor);
    }

    public AccountInfo getAccountInfo(final Account account) throws Exception {
        return this.moHAInvokeAdapt(new MoInvokeAdaptor<AccountInfo>(){

            @Override
            public AccountInfo invoke() throws Exception {
                return PostMsg.this.proxy.getAccountInfo(account);
            }
        }, account, "getAccountInfo");
    }

    public List<MOMsg> getMOMsgs(final Account account, final int fetchSize) throws Exception {
        if (fetchSize <= 0) {
            return Collections.emptyList();
        }
        return this.moHAInvokeAdapt(new MoInvokeAdaptor<List<MOMsg>>(){

            @Override
            public List<MOMsg> invoke() throws Exception {
                return PostMsg.this.proxy.getMOMsgs(account, fetchSize);
            }
        }, account, "getMOMsgs");
    }

    public MTResponse[] getResps(final Account account, final int fetchSize) throws Exception {
        if (fetchSize <= 0) {
            return null;
        }
        return this.moHAInvokeAdapt(new MoInvokeAdaptor<MTResponse[]>(){

            @Override
            public MTResponse[] invoke() throws Exception {
                return PostMsg.this.proxy.getResps(account, fetchSize, 3);
            }
        }, account, "getResps");
    }

    @Deprecated
    public MTResponse[] findResps(final Account account, final int pageIndex, final UUID batchID, final String phone, final int method) throws Exception {
        if (pageIndex <= 0) {
            return null;
        }
        if (batchID == null && CommonUtil.isBlank(phone)) {
            throw new IllegalArgumentException("\u53c2\u6570\u65e0\u6548\uff08\u6279\u6b21ID\u548c\u624b\u673a\u53f7\u7801\u5176\u4e2d\u4e00\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff09");
        }
        return this.moHAInvokeAdapt(new MoInvokeAdaptor<MTResponse[]>(){

            @Override
            public MTResponse[] invoke() throws Exception {
                return PostMsg.this.proxy.findResps(account, pageIndex, batchID, phone, method != 1);
            }
        }, account, "findResps");
    }

    @Deprecated
    public TicketInfo findTickets(final Account account, final String phone, final Date startTime, final Date endTime, final String userName, final int pageIndex) throws Exception {
        if (pageIndex <= 0) {
            return null;
        }
        return this.moHAInvokeAdapt(new MoInvokeAdaptor<TicketInfo>(){

            @Override
            public TicketInfo invoke() throws Exception {
                return PostMsg.this.proxy.findTickets(account, phone, startTime, endTime, userName, pageIndex);
            }
        }, account, "findTickets");
    }

    public List<MTReport> getReports(final Account account, final int fetchSize) throws Exception {
        if (fetchSize <= 0) {
            return Collections.emptyList();
        }
        return this.moHAInvokeAdapt(new MoInvokeAdaptor<List<MTReport>>(){

            @Override
            public List<MTReport> invoke() throws Exception {
                return PostMsg.this.proxy.getReports(account, fetchSize, 3);
            }
        }, account, "getReports");
    }

    @Deprecated
    public List<MTReport> findReports(final Account account, final int pageIndex, final UUID batchID, final String phone, final int method) throws Exception {
        if (pageIndex <= 0) {
            return Collections.emptyList();
        }
        if (batchID == null && CommonUtil.isBlank(phone)) {
            throw new IllegalArgumentException("\u53c2\u6570\u65e0\u6548\uff08\u6279\u6b21ID\u548c\u624b\u673a\u53f7\u7801\u5176\u4e2d\u4e00\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff09");
        }
        return this.moHAInvokeAdapt(new MoInvokeAdaptor<List<MTReport>>(){

            @Override
            public List<MTReport> invoke() throws Exception {
                return PostMsg.this.proxy.findReports(account, pageIndex, batchID, phone, method != 1);
            }
        }, account, "findReports");
    }

    public int modifyPassword(final Account account, final String newPwd) throws Exception {
        if (CommonUtil.isBlank(newPwd)) {
            throw new IllegalArgumentException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        return this.moHAInvokeAdapt(new MoInvokeAdaptor<Integer>(){

            @Override
            public Integer invoke() throws Exception {
                return PostMsg.this.proxy.modifyPassword(account, newPwd);
            }
        }, account, "modifyPassword");
    }

    public List<BusinessType> getBizTypes(final Account account) throws Exception {
        return this.moHAInvokeAdapt(new MoInvokeAdaptor<List<BusinessType>>(){

            @Override
            public List<BusinessType> invoke() throws Exception {
                return PostMsg.this.proxy.getBizTypes(account);
            }
        }, account, "getBizTypes");
    }

    public boolean confirmRespRequest(final Account account, final String confirmId) throws Exception {
        return this.moHAInvokeAdapt(new MoInvokeAdaptor<Boolean>(){

            @Override
            public Boolean invoke() throws Exception {
                return PostMsg.this.proxy.confirmRequest(account, CommonItem.OMsgType.RESP, confirmId);
            }
        }, account, "confirmRespRequest");
    }

    public boolean confirmReportRequest(final Account account, final String confirmId) throws Exception {
        return this.moHAInvokeAdapt(new MoInvokeAdaptor<Boolean>(){

            @Override
            public Boolean invoke() throws Exception {
                return PostMsg.this.proxy.confirmRequest(account, CommonItem.OMsgType.REPORT, confirmId);
            }
        }, account, "confirmReportRequest");
    }

    public boolean confirmMoRequest(final Account account, final String confirmId) throws Exception {
        return this.moHAInvokeAdapt(new MoInvokeAdaptor<Boolean>(){

            @Override
            public Boolean invoke() throws Exception {
                return PostMsg.this.proxy.confirmRequest(account, CommonItem.OMsgType.MO, confirmId);
            }
        }, account, "confirmMoRequest");
    }

    public void setAutoConfirm(boolean autoConfirm) {
        this.autoConfirm = autoConfirm;
        MOSupport.setAutoConfirm(autoConfirm);
        this.proxy.setAutoConfirm(autoConfirm);
    }

    public boolean isAutoConfirm() {
        return this.autoConfirm;
    }

    public static void setHighAvailability(boolean highAvailability) {
        PostMsg.highAvailability = highAvailability;
    }

    public static boolean isHighAvailability() {
        return highAvailability;
    }

    public static void setHaMonitor(HAMonitor haMonitor) {
        PostMsg.haMonitor = haMonitor;
    }

    public synchronized void disableHighAvailability() {
        PostMsgLogger.logInfo("Starting disable high availability function ...");
        highAvailability = false;
        if (haMonitor != null) {
            haMonitor.closeMonitor();
        }
        haMonitor = null;
        PostMsgLogger.logInfo("High availability function disabled");
    }

    public void disableRetryWhenEOFException() {
        MtInvokeAdaptor.retryWhenEOFException = false;
    }

    private GsmsResponse mtHAInvokeAdapt(MtInvokeAdaptor invokeAdaptor, Account account, String method) throws Exception {
        ConfigControlCenter.accountName = account.getName();
        HostInfo beforeSendMtServer = this.gwHost;
        try {
            return invokeAdaptor.invokeWithInternalRetry(beforeSendMtServer, method);
        }
        catch (Exception e) {
            if (!highAvailability || haMonitor == null) {
                throw e;
            }
            int trySwitchTimes = haMonitor.getMtTrySwitchTimes();
            for (int i = 0; i < trySwitchTimes; ++i) {
                PostMsgLogger.logCommError(method, "Sent error, before send server:" + beforeSendMtServer + ", caused by:" + e.getMessage());
                haMonitor.markCrashMtServer(beforeSendMtServer);
                if (!this.trySwitchMtServer(beforeSendMtServer)) {
                    throw e;
                }
                beforeSendMtServer = this.gwHost;
                PostMsgLogger.logCommError(method, "Retry using server:" + beforeSendMtServer);
                try {
                    return invokeAdaptor.invokeWithInternalRetry(beforeSendMtServer, method);
                }
                catch (Exception e1) {
                    PostMsgLogger.logCommError(method, "Sent error, before send server:" + beforeSendMtServer + ", current switch times:" + (i + 1) + ", total switch times:" + trySwitchTimes + ", caused by:" + e1.getMessage());
                    haMonitor.markCrashMtServer(beforeSendMtServer);
                    e = e1;
                    if (i < trySwitchTimes - 1) continue;
                    throw e1;
                }
            }
            throw e;
        }
    }

    private <T> T moHAInvokeAdapt(MoInvokeAdaptor<T> invokeAdaptor, Account account, String method) throws Exception {
        ConfigControlCenter.accountName = account.getName();
        HostInfo beforeSendMoServer = this.wsHost;
        try {
            return invokeAdaptor.invokeWithInternalRetry(beforeSendMoServer, method);
        }
        catch (Exception e) {
            if (!highAvailability || haMonitor == null) {
                throw e;
            }
            int trySwitchTimes = haMonitor.getMoTrySwitchTimes();
            for (int i = 0; i < trySwitchTimes; ++i) {
                PostMsgLogger.logCommError(method, "Sent error, before send server:" + beforeSendMoServer + ", caused by:" + e.getMessage());
                haMonitor.markCrashMoServer(beforeSendMoServer);
                if (!this.trySwitchMoServer(beforeSendMoServer)) {
                    throw e;
                }
                beforeSendMoServer = this.wsHost;
                PostMsgLogger.logCommError(method, "Retry using server:" + beforeSendMoServer);
                try {
                    return invokeAdaptor.invokeWithInternalRetry(beforeSendMoServer, method);
                }
                catch (Exception e1) {
                    PostMsgLogger.logCommError(method, "Sent error, before send server:" + beforeSendMoServer + ", current switch times:" + (i + 1) + ", total switch times:" + trySwitchTimes + ", caused by:" + e1.getMessage());
                    haMonitor.markCrashMoServer(beforeSendMoServer);
                    e = e1;
                    if (i < trySwitchTimes - 1) continue;
                    throw e1;
                }
            }
            throw e;
        }
    }

    private synchronized boolean trySwitchMtServer(HostInfo beforeSendMtServer) {
        if (!this.gwHost.equals(beforeSendMtServer)) {
            return true;
        }
        HostInfo newMtServer = haMonitor.takeOneMtServer();
        if (newMtServer == null) {
            return false;
        }
        this.gwHost = newMtServer;
        this.proxy.createNewMtPool(newMtServer, this.builder.shortConnMode, this.builder.soTimeout, this.builder.mtMaxConn);
        return true;
    }

    private synchronized boolean trySwitchMoServer(HostInfo beforeSendMoServer) {
        if (!this.wsHost.equals(beforeSendMoServer)) {
            return true;
        }
        HostInfo newMoServer = haMonitor.takeOneMoServer();
        if (newMoServer == null) {
            return false;
        }
        this.wsHost = newMoServer;
        this.proxy.createNewMoPool(newMoServer, this.builder.shortConnMode, this.builder.soTimeout, this.builder.moMaxConn);
        return true;
    }
}

