/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos;

import com.xuanwu.mos.PostMsg;
import com.xuanwu.mos.common.MTSupport;

public class PostMsgBuilder {
    boolean shortConnMode = false;
    int soTimeout = 20000;
    int mtMaxConn = 2;
    int moMaxConn = 2;
    final int phoneSizeMaxLimit = 100000;
    private volatile PostMsg postMsg;
    private static final PostMsgBuilder INSTANCE = new PostMsgBuilder();

    private PostMsgBuilder() {
    }

    public static PostMsgBuilder getInstance() {
        return INSTANCE;
    }

    @Deprecated
    public static PostMsgBuilder customNewInstance() {
        return new PostMsgBuilder();
    }

    public PostMsgBuilder setShortConnMode(boolean shortConnMode) {
        this.shortConnMode = shortConnMode;
        return this;
    }

    public PostMsgBuilder setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
        return this;
    }

    public PostMsgBuilder setMaxConnForMT(int mtMaxConn) {
        this.mtMaxConn = mtMaxConn;
        return this;
    }

    public PostMsgBuilder setMaxConnForMO(int moMaxConn) {
        this.moMaxConn = moMaxConn;
        return this;
    }

    public PostMsgBuilder setMaxPhoneSize(int maxPhoneSize) {
        if (maxPhoneSize > 100000) {
            throw new IllegalArgumentException("max phone size must be less than(or equal) 100000");
        }
        MTSupport.setMaxPhoneSize(maxPhoneSize);
        return this;
    }

    public synchronized PostMsg build() {
        if (this.postMsg == null) {
            this.postMsg = new PostMsg(this);
        }
        return this.postMsg;
    }
}

