/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos;

import com.xuanwu.mos.HostInfo;
import com.xuanwu.mos.ams.ApiInvokeCollector;
import com.xuanwu.mos.ams.BizDataCollector;
import com.xuanwu.mos.ams.MonitorSecurity;
import com.xuanwu.mos.ams.MonitorService;
import com.xuanwu.mos.ams.NetworkCollector;
import com.xuanwu.mos.common.MOSupport;
import com.xuanwu.mos.common.MTSupport;
import com.xuanwu.mos.common.entity.Account;
import com.xuanwu.mos.common.entity.AccountInfo;
import com.xuanwu.mos.common.entity.BusinessType;
import com.xuanwu.mos.common.entity.GsmsResponse;
import com.xuanwu.mos.common.entity.MOLoginResponse;
import com.xuanwu.mos.common.entity.MOMsg;
import com.xuanwu.mos.common.entity.MTPack;
import com.xuanwu.mos.common.entity.MTReport;
import com.xuanwu.mos.common.entity.MTResponse;
import com.xuanwu.mos.common.entity.TicketInfo;
import com.xuanwu.mos.common.log.PostMsgLogger;
import com.xuanwu.mos.common.pool.SocketObject;
import com.xuanwu.mos.common.pool.SocketObjectFactory;
import com.xuanwu.mos.common.util.DigestUtils;
import com.xuanwu.mos.common.util.Interceptor;
import com.xuanwu.mos.common.util.StringUtils;
import com.xuanwu.mos.msggate.protobuf.CommonItem;
import com.xuanwu.mos.msggate.protobuf.mo.MOResponse;
import com.xuanwu.mos.thirdparty.org.apache.commons.pool.impl.GenericKeyedObjectPool;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyServer {
    private HostInfo proxyHost = new HostInfo("192.168.0.1", 0);
    private static int maxFrameLen = 0xA00000;
    private boolean autoConfirm = true;
    private Interceptor interceptor;
    public static final int SUCCESS_FLAG = 0;
    private HostInfo mtHost;
    private HostInfo moHost;
    private GenericKeyedObjectPool mtPool;
    private GenericKeyedObjectPool moPool;

    public ProxyServer(HostInfo mtHost, HostInfo moHost, boolean shortConnMode, int soTimeout, int mtMaxConns, int moMaxConns) {
        if (mtMaxConns < 1) {
            throw new IllegalArgumentException("Max connection invalid: " + mtMaxConns);
        }
        if (moMaxConns < 1) {
            throw new IllegalArgumentException("Max connection invalid: " + moMaxConns);
        }
        this.mtHost = mtHost;
        this.moHost = moHost;
        this.mtPool = this.newPool(mtHost, shortConnMode, soTimeout, mtMaxConns);
        this.moPool = this.newPool(moHost, shortConnMode, soTimeout, moMaxConns);
        MonitorService.setMtHost(mtHost);
    }

    private GenericKeyedObjectPool newPool(HostInfo host, boolean shortConnMode, int soTimeout, int maxConns) {
        SocketObjectFactory factory = new SocketObjectFactory();
        factory.setProxyHost(this.proxyHost);
        factory.setHost(host);
        factory.setShortConnMode(shortConnMode);
        factory.setSoTimeout(soTimeout);
        GenericKeyedObjectPool pool = new GenericKeyedObjectPool(factory);
        pool.setTestOnBorrow(true);
        pool.setTestOnReturn(true);
        pool.setTestWhileIdle(true);
        pool.setMaxActive(maxConns);
        pool.setMaxIdle(maxConns);
        pool.setMaxTotal(-1);
        pool.setMinEvictableIdleTimeMillis(SocketObjectFactory.MAX_IDLE_TIME);
        pool.setTimeBetweenEvictionRunsMillis(TimeUnit.SECONDS.toMillis(10L));
        pool.setNumTestsPerEvictionRun(3);
        pool.setWhenExhaustedAction((byte)1);
        return pool;
    }

    public synchronized void createNewMtPool(HostInfo mtHost, boolean shortConnMode, int soTimeout, int maxConns) {
        if (mtHost == null) {
            return;
        }
        if (mtHost.equals(this.mtHost)) {
            return;
        }
        this.mtHost = mtHost;
        GenericKeyedObjectPool oldMtPool = this.mtPool;
        this.mtPool = this.newPool(mtHost, shortConnMode, soTimeout, maxConns);
        try {
            oldMtPool.clear();
            oldMtPool.setTimeBetweenEvictionRunsMillis(-1L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MonitorService.setMtHost(mtHost);
    }

    public synchronized void createNewMoPool(HostInfo moHost, boolean shortConnMode, int soTimeout, int maxConns) {
        if (moHost == null) {
            return;
        }
        if (moHost.equals(this.moHost)) {
            return;
        }
        this.moHost = moHost;
        GenericKeyedObjectPool oldMoPool = this.moPool;
        this.moPool = this.newPool(moHost, shortConnMode, soTimeout, maxConns);
        try {
            oldMoPool.clear();
            oldMoPool.setTimeBetweenEvictionRunsMillis(-1L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HostInfo getProxyHost() {
        return this.proxyHost;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GsmsResponse sendMessage(Account account, MTPack pack) throws Exception {
        long loginInnerCostTime;
        long beforeLogin;
        SocketObject sockObj;
        GsmsResponse resp;
        block18: {
            GsmsResponse gsmsResponse;
            block16: {
                block17: {
                    if (account == null) {
                        throw new NullPointerException("account");
                    }
                    long begin = System.currentTimeMillis();
                    resp = null;
                    try {
                        sockObj = (SocketObject)this.mtPool.borrowObject(account.getName());
                    }
                    catch (Exception e) {
                        ApiInvokeCollector.incrMtFailure(account);
                        throw e;
                    }
                    beforeLogin = System.currentTimeMillis();
                    loginInnerCostTime = 0L;
                    try {
                        if (!sockObj.isLogin()) {
                            resp = this.doMTLogin(sockObj, account);
                            if (resp.getResult() != 0) {
                                gsmsResponse = resp;
                                Object var14_12 = null;
                                if (resp == null || resp.getResult() != 0) break block16;
                                break block17;
                            }
                            loginInnerCostTime = resp.getInnerCostTime();
                        }
                        if (this.interceptor != null) {
                            long end = System.currentTimeMillis();
                            this.interceptor.beforeMtSend(beforeLogin - begin, end - beforeLogin, pack);
                        }
                        resp = MTSupport.getResponse(this.transfer(sockObj, MTSupport.getSendBytes(account, pack), account));
                        break block18;
                    }
                    catch (Throwable throwable) {
                        Object var14_14 = null;
                        if (resp != null && resp.getResult() == 0) {
                            this.mtPool.returnObject(account.getName(), sockObj);
                            ApiInvokeCollector.incrMtSuccessAndCostTime(account, beforeLogin, System.currentTimeMillis(), resp.getInnerCostTime() + loginInnerCostTime);
                            BizDataCollector.mtMsgCount(account, pack.getMsgs().size());
                            throw throwable;
                        }
                        this.mtPool.invalidateObject(account.getName(), sockObj);
                        if (resp != null) {
                            PostMsgLogger.logBizError("post", "Response with code: " + resp.getResult());
                        }
                        ApiInvokeCollector.incrMtFailure(account);
                        throw throwable;
                    }
                }
                this.mtPool.returnObject(account.getName(), sockObj);
                ApiInvokeCollector.incrMtSuccessAndCostTime(account, beforeLogin, System.currentTimeMillis(), resp.getInnerCostTime() + loginInnerCostTime);
                BizDataCollector.mtMsgCount(account, pack.getMsgs().size());
                return gsmsResponse;
            }
            this.mtPool.invalidateObject(account.getName(), sockObj);
            if (resp != null) {
                PostMsgLogger.logBizError("post", "Response with code: " + resp.getResult());
            }
            ApiInvokeCollector.incrMtFailure(account);
            return gsmsResponse;
        }
        Object var14_13 = null;
        if (resp != null && resp.getResult() == 0) {
            this.mtPool.returnObject(account.getName(), sockObj);
            ApiInvokeCollector.incrMtSuccessAndCostTime(account, beforeLogin, System.currentTimeMillis(), resp.getInnerCostTime() + loginInnerCostTime);
            BizDataCollector.mtMsgCount(account, pack.getMsgs().size());
            return resp;
        }
        this.mtPool.invalidateObject(account.getName(), sockObj);
        if (resp != null) {
            PostMsgLogger.logBizError("post", "Response with code: " + resp.getResult());
        }
        ApiInvokeCollector.incrMtFailure(account);
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountInfo getAccountInfo(Account account) throws Exception {
        AccountInfo accountInfo;
        block5: {
            SocketObject sockObj;
            block4: {
                sockObj = (SocketObject)this.moPool.borrowObject(account.getName());
                try {
                    this.doMoLogin(sockObj, account);
                    accountInfo = MOSupport.toAcInfo(account, this.transfer(sockObj, MOSupport.getAcInfoReq(), account));
                    Object var5_4 = null;
                    if (sockObj.isLogin()) break block4;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (!sockObj.isLogin()) {
                        this.moPool.invalidateObject(account.getName(), sockObj);
                    } else {
                        this.moPool.returnObject(account.getName(), sockObj);
                    }
                    throw throwable;
                }
                this.moPool.invalidateObject(account.getName(), sockObj);
                break block5;
            }
            this.moPool.returnObject(account.getName(), sockObj);
        }
        return accountInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BusinessType> getBizTypes(Account account) throws Exception {
        List<BusinessType> list;
        block5: {
            SocketObject sockObj;
            block4: {
                sockObj = (SocketObject)this.moPool.borrowObject(account.getName());
                try {
                    this.doMoLogin(sockObj, account);
                    list = MOSupport.toBizType(account, this.transfer(sockObj, MOSupport.getBizTypeReq(), account));
                    Object var5_4 = null;
                    if (sockObj.isLogin()) break block4;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (!sockObj.isLogin()) {
                        this.moPool.invalidateObject(account.getName(), sockObj);
                    } else {
                        this.moPool.returnObject(account.getName(), sockObj);
                    }
                    throw throwable;
                }
                this.moPool.invalidateObject(account.getName(), sockObj);
                break block5;
            }
            this.moPool.returnObject(account.getName(), sockObj);
        }
        return list;
    }

    public List<MOMsg> getMOMsgs(Account account, int fetchSize) throws Exception {
        List<MOMsg> list;
        block11: {
            SocketObject sockObj;
            block10: {
                try {
                    sockObj = (SocketObject)this.moPool.borrowObject(account.getName());
                }
                catch (Exception e) {
                    ApiInvokeCollector.incrMoFailure(account);
                    throw e;
                }
                try {
                    long beforeLogin = System.currentTimeMillis();
                    long loginInnerCostTime = this.doMoLogin(sockObj, account);
                    MOResponse.OResponse.Builder resp = MOSupport.toRespBuilder(this.transfer(sockObj, MOSupport.getMOReq(fetchSize), account));
                    List<MOMsg> mos = MOSupport.toMos(account, resp);
                    if (this.autoConfirm && mos != null && mos.size() > 0) {
                        this.transfer(sockObj, MOSupport.getConfirmBytes(resp), account);
                    }
                    ApiInvokeCollector.incrMoSuccessAndCostTime(account, beforeLogin, System.currentTimeMillis(), resp.getInnerCostTime() + loginInnerCostTime);
                    if (mos != null && mos.size() > 0) {
                        BizDataCollector.moMsgCount(account, mos.size());
                    }
                    list = mos;
                    Object var12_11 = null;
                    if (sockObj.isLogin()) break block10;
                }
                catch (Exception e) {
                    try {
                        ApiInvokeCollector.incrMoFailure(account);
                        throw e;
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        if (!sockObj.isLogin()) {
                            this.moPool.invalidateObject(account.getName(), sockObj);
                        } else {
                            this.moPool.returnObject(account.getName(), sockObj);
                        }
                        throw throwable;
                    }
                }
                this.moPool.invalidateObject(account.getName(), sockObj);
                break block11;
            }
            this.moPool.returnObject(account.getName(), sockObj);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MTResponse[] getResps(Account account, int fetchSize, int limitDays) throws Exception {
        MTResponse[] mTResponseArray;
        block6: {
            SocketObject sockObj;
            block5: {
                sockObj = (SocketObject)this.moPool.borrowObject(account.getName());
                try {
                    this.doMoLogin(sockObj, account);
                    MOResponse.OResponse.Builder resp = MOSupport.toRespBuilder(this.transfer(sockObj, MOSupport.getRespReq(limitDays, fetchSize), account));
                    MTResponse[] resps = MOSupport.toResps(account, resp);
                    if (this.autoConfirm && resps != null && resps.length > 0) {
                        this.transfer(sockObj, MOSupport.getConfirmBytes(resp), account);
                    }
                    mTResponseArray = resps;
                    Object var9_8 = null;
                    if (sockObj.isLogin()) break block5;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (!sockObj.isLogin()) {
                        this.moPool.invalidateObject(account.getName(), sockObj);
                    } else {
                        this.moPool.returnObject(account.getName(), sockObj);
                    }
                    throw throwable;
                }
                this.moPool.invalidateObject(account.getName(), sockObj);
                break block6;
            }
            this.moPool.returnObject(account.getName(), sockObj);
        }
        return mTResponseArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MTResponse[] findResps(Account account, int pageIndex, UUID batchID, String phone, boolean isSimple) throws Exception {
        MTResponse[] mTResponseArray;
        block5: {
            SocketObject sockObj;
            block4: {
                sockObj = (SocketObject)this.moPool.borrowObject(account.getName());
                try {
                    this.doMoLogin(sockObj, account);
                    MOResponse.OResponse.Builder resp = MOSupport.toRespBuilder(this.transfer(sockObj, MOSupport.getFindRespReq(batchID, phone, pageIndex, isSimple), account));
                    mTResponseArray = MOSupport.toResps(account, resp);
                    Object var10_9 = null;
                    if (sockObj.isLogin()) break block4;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (!sockObj.isLogin()) {
                        this.moPool.invalidateObject(account.getName(), sockObj);
                    } else {
                        this.moPool.returnObject(account.getName(), sockObj);
                    }
                    throw throwable;
                }
                this.moPool.invalidateObject(account.getName(), sockObj);
                break block5;
            }
            this.moPool.returnObject(account.getName(), sockObj);
        }
        return mTResponseArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TicketInfo findTickets(Account account, String phone, Date startTime, Date endTime, String userName, int pageIndex) throws Exception {
        TicketInfo ticketInfo;
        block5: {
            SocketObject sockObj;
            block4: {
                sockObj = (SocketObject)this.moPool.borrowObject(account.getName());
                try {
                    this.doMoLogin(sockObj, account);
                    MOResponse.OResponse.Builder resp = MOSupport.toRespBuilder(this.transfer(sockObj, MOSupport.findTicketReq(phone, startTime, endTime, userName, pageIndex), account));
                    ticketInfo = MOSupport.toTickets(resp);
                    Object var11_10 = null;
                    if (sockObj.isLogin()) break block4;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (!sockObj.isLogin()) {
                        this.moPool.invalidateObject(account.getName(), sockObj);
                    } else {
                        this.moPool.returnObject(account.getName(), sockObj);
                    }
                    throw throwable;
                }
                this.moPool.invalidateObject(account.getName(), sockObj);
                break block5;
            }
            this.moPool.returnObject(account.getName(), sockObj);
        }
        return ticketInfo;
    }

    public List<MTReport> getReports(Account account, int fetchSize, int limitDays) throws Exception {
        List<MTReport> list;
        block11: {
            SocketObject sockObj;
            block10: {
                try {
                    sockObj = (SocketObject)this.moPool.borrowObject(account.getName());
                }
                catch (Exception e) {
                    ApiInvokeCollector.incrReportFailure(account);
                    throw e;
                }
                try {
                    long beforeLogin = System.currentTimeMillis();
                    long loginInnerCostTime = this.doMoLogin(sockObj, account);
                    MOResponse.OResponse.Builder resp = MOSupport.toRespBuilder(this.transfer(sockObj, MOSupport.getReportReq(limitDays, fetchSize), account));
                    List<MTReport> reports = MOSupport.toReports(account, resp);
                    if (this.autoConfirm && reports != null && reports.size() > 0) {
                        this.transfer(sockObj, MOSupport.getConfirmBytes(resp), account);
                    }
                    if (reports != null && reports.size() > 0) {
                        BizDataCollector.reportMsgCount(account, reports.size());
                    }
                    ApiInvokeCollector.incrReportSuccessAndCostTime(account, beforeLogin, System.currentTimeMillis(), resp.getInnerCostTime() + loginInnerCostTime);
                    list = reports;
                    Object var13_12 = null;
                    if (sockObj.isLogin()) break block10;
                }
                catch (Exception e) {
                    try {
                        ApiInvokeCollector.incrReportFailure(account);
                        throw e;
                    }
                    catch (Throwable throwable) {
                        Object var13_13 = null;
                        if (!sockObj.isLogin()) {
                            this.moPool.invalidateObject(account.getName(), sockObj);
                        } else {
                            this.moPool.returnObject(account.getName(), sockObj);
                        }
                        throw throwable;
                    }
                }
                this.moPool.invalidateObject(account.getName(), sockObj);
                break block11;
            }
            this.moPool.returnObject(account.getName(), sockObj);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MTReport> findReports(Account account, int pageIndex, UUID batchID, String phone, boolean isSimple) throws Exception {
        List<MTReport> list;
        block5: {
            SocketObject sockObj;
            block4: {
                sockObj = (SocketObject)this.moPool.borrowObject(account.getName());
                try {
                    this.doMoLogin(sockObj, account);
                    MOResponse.OResponse.Builder resp = MOSupport.toRespBuilder(this.transfer(sockObj, MOSupport.getFindReportReq(batchID, phone, pageIndex, isSimple), account));
                    list = MOSupport.toReports(account, resp);
                    Object var10_9 = null;
                    if (sockObj.isLogin()) break block4;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (!sockObj.isLogin()) {
                        this.moPool.invalidateObject(account.getName(), sockObj);
                    } else {
                        this.moPool.returnObject(account.getName(), sockObj);
                    }
                    throw throwable;
                }
                this.moPool.invalidateObject(account.getName(), sockObj);
                break block5;
            }
            this.moPool.returnObject(account.getName(), sockObj);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int modifyPassword(Account account, String newPwd) throws Exception {
        int n;
        block5: {
            SocketObject sockObj;
            block4: {
                String md5Pwd = DigestUtils.md5Hex(newPwd);
                sockObj = (SocketObject)this.moPool.borrowObject(account.getName());
                try {
                    this.doMoLogin(sockObj, account);
                    n = MOSupport.toModifyPwdResult(this.transfer(sockObj, MOSupport.getModifyPwdReq(account, md5Pwd), account));
                    Object var7_6 = null;
                    if (sockObj.isLogin()) break block4;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (!sockObj.isLogin()) {
                        this.moPool.invalidateObject(account.getName(), sockObj);
                    } else {
                        this.moPool.returnObject(account.getName(), sockObj);
                    }
                    throw throwable;
                }
                this.moPool.invalidateObject(account.getName(), sockObj);
                break block5;
            }
            this.moPool.returnObject(account.getName(), sockObj);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean confirmRequest(Account account, CommonItem.OMsgType msgType, String confirmId) throws Exception {
        boolean bl;
        block6: {
            SocketObject sockObj;
            block5: {
                if (account == null || msgType == null || StringUtils.isBlank(confirmId)) {
                    return false;
                }
                sockObj = (SocketObject)this.moPool.borrowObject(account.getName());
                try {
                    this.doMoLogin(sockObj, account);
                    MOResponse.OResponse.Builder resp = MOSupport.toRespBuilder(this.transfer(sockObj, MOSupport.getConfirmBytes(msgType, confirmId), account));
                    bl = resp.getResult() == CommonItem.Result.SUCCESS;
                    Object var8_7 = null;
                    if (sockObj.isLogin()) break block5;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (!sockObj.isLogin()) {
                        this.moPool.invalidateObject(account.getName(), sockObj);
                    } else {
                        this.moPool.returnObject(account.getName(), sockObj);
                    }
                    throw throwable;
                }
                this.moPool.invalidateObject(account.getName(), sockObj);
                break block6;
            }
            this.moPool.returnObject(account.getName(), sockObj);
        }
        return bl;
    }

    private GsmsResponse doMTLogin(SocketObject sockObj, Account account) throws Exception {
        GsmsResponse resp = MTSupport.getResponse(this.transfer(sockObj, MTSupport.getLoginBytes(account), account));
        if (resp.getResult() != 0) {
            return resp;
        }
        sockObj.setLogin(true);
        MonitorSecurity.processMtAccountToken(account, resp);
        return resp;
    }

    private long doMoLogin(SocketObject sockObj, Account account) throws Exception {
        if (account == null) {
            throw new NullPointerException("account");
        }
        if (sockObj.isLogin()) {
            return 0L;
        }
        MOLoginResponse resp = MOSupport.getMOLoginResponse(this.transfer(sockObj, MOSupport.getLoginBytes(account), account));
        if (resp.getType() == CommonItem.OMsgType.LOGIN && resp.getResult() == CommonItem.Result.SUCCESS) {
            sockObj.setLogin(true);
            MonitorSecurity.processMoAccountToken(account, resp);
            return resp.getInnerCostTime();
        }
        throw new RuntimeException(resp.getResult().getNumber() + ", " + resp.getResult().name() + ", " + resp.getMessage());
    }

    private final byte[] transfer(SocketObject sockObj, byte[] sendBytes, Account account) throws IOException {
        if (sendBytes == null) {
            throw new NullPointerException("sendBytes");
        }
        boolean isLogin = sockObj.isLogin();
        NetworkCollector.writeCount(isLogin, account, sendBytes.length);
        try {
            sockObj.getDos().writeInt(sendBytes.length);
            sockObj.getDos().write(sendBytes);
            sockObj.getDos().flush();
            int recvLength = sockObj.getDis().readInt();
            if (recvLength > maxFrameLen || recvLength < 0) {
                sockObj.destory();
                throw new RuntimeException("Adjusted frame length exceeds " + maxFrameLen + ": " + recvLength);
            }
            byte[] recvBytes = new byte[recvLength];
            sockObj.getDis().readFully(recvBytes);
            NetworkCollector.readCount(isLogin, account, recvBytes.length);
            return recvBytes;
        }
        catch (IOException e) {
            NetworkCollector.errorCount(isLogin, account, 1L);
            sockObj.destory();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkMTSocketIsValid(Account account) throws Exception {
        boolean bl;
        SocketObject sockObj = null;
        try {
            sockObj = (SocketObject)this.mtPool.borrowObject(account.getName());
            bl = sockObj.isValid();
            Object var5_5 = null;
            if (sockObj == null) return bl;
        }
        catch (Exception e) {
            try {
                ApiInvokeCollector.incrMtFailure(account);
                Object var5_6 = null;
                if (sockObj == null) return false;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (sockObj == null) throw throwable;
                this.mtPool.returnObject(account.getName(), sockObj);
                throw throwable;
            }
            this.mtPool.returnObject(account.getName(), sockObj);
            return false;
        }
        this.mtPool.returnObject(account.getName(), sockObj);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GsmsResponse innerTryMTLogin(Account account) throws Exception {
        GsmsResponse gsmsResponse;
        block9: {
            GsmsResponse resp;
            SocketObject sockObj;
            block8: {
                sockObj = null;
                resp = null;
                try {
                    sockObj = (SocketObject)this.mtPool.borrowObject(account.getName());
                }
                catch (Exception e) {
                    ApiInvokeCollector.incrMtFailure(account);
                    throw e;
                }
                long beforeLogin = System.currentTimeMillis();
                long loginInnerCostTime = 0L;
                try {
                    resp = this.doMTLogin(sockObj, account);
                    loginInnerCostTime = resp.getInnerCostTime();
                    gsmsResponse = resp;
                    Object var10_8 = null;
                    if (resp == null || resp.getResult() != 0) break block8;
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    if (resp != null && resp.getResult() == 0) {
                        this.mtPool.returnObject(account.getName(), sockObj);
                        ApiInvokeCollector.incrMtSuccessAndCostTime(account, beforeLogin, System.currentTimeMillis(), resp.getInnerCostTime() + loginInnerCostTime);
                    } else {
                        this.mtPool.invalidateObject(account.getName(), sockObj);
                        if (resp != null) {
                            PostMsgLogger.logBizError("post", "Response with code: " + resp.getResult());
                        }
                        ApiInvokeCollector.incrMtFailure(account);
                    }
                    throw throwable;
                }
                this.mtPool.returnObject(account.getName(), sockObj);
                ApiInvokeCollector.incrMtSuccessAndCostTime(account, beforeLogin, System.currentTimeMillis(), resp.getInnerCostTime() + loginInnerCostTime);
                break block9;
            }
            this.mtPool.invalidateObject(account.getName(), sockObj);
            if (resp != null) {
                PostMsgLogger.logBizError("post", "Response with code: " + resp.getResult());
            }
            ApiInvokeCollector.incrMtFailure(account);
        }
        return gsmsResponse;
    }

    public void setAutoConfirm(boolean autoConfirm) {
        this.autoConfirm = autoConfirm;
    }

    public void setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }
}

