/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.ams;

import com.xuanwu.mos.ams.MonitorSecurity;
import com.xuanwu.mos.ams.MonitorService;
import com.xuanwu.mos.ams.MsgReporter;
import com.xuanwu.mos.ams.metric.NodeBuilder;
import com.xuanwu.mos.ams.report.protocol.NodeMeta;
import com.xuanwu.mos.common.entity.Account;
import com.xuanwu.mos.common.log.PostMsgLogger;
import com.xuanwu.mos.common.util.StringUtils;
import com.xuanwu.mos.profiles.UserProfiles;
import com.xuanwu.mos.profiles.UserProfilesListener;
import com.xuanwu.mos.profiles.UserProfilesService;
import com.xuanwu.mos.profiles.ams.MonitorConfig;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AmsMonitor
implements UserProfilesListener {
    public static volatile boolean monitoring = false;
    private static final long REGISTER_FAILED_INTERVAL = 30000L;
    private BlockingQueue<NodeMeta> nodeMetaQueue = new ArrayBlockingQueue<NodeMeta>(20);
    private static Lock monitorLock = new ReentrantLock();
    private static AmsMonitor monitor;
    private MsgReporter reporter;
    private MonitorService monitorService;
    private Thread registerThread;
    private Thread reportThread;
    private volatile long reportInterval = 60L;
    private ConcurrentMap<String, MonitorSecurity.AccountToken> accountTokenMap = new ConcurrentHashMap<String, MonitorSecurity.AccountToken>();

    public static boolean isMonitoring() {
        return monitoring;
    }

    public static boolean setMonitoring(boolean monitoring) throws RuntimeException {
        if (monitoring) {
            return AmsMonitor.startServer();
        }
        return AmsMonitor.stopServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean startServer() throws RuntimeException {
        MonitorConfig monitorConfig;
        block6: {
            monitorLock.lock();
            try {
                if (!monitoring) break block6;
                boolean bl = false;
                Object var4_2 = null;
                monitorLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                monitorLock.unlock();
                throw throwable;
            }
        }
        PostMsgLogger.logInfo("Starting enable monitor function ...");
        monitoring = true;
        monitor = new AmsMonitor();
        UserProfiles profiles = UserProfilesService.getUserProfiles();
        String serverUrl = null;
        if (profiles != null && profiles.getAms() != null && (monitorConfig = profiles.getAms().getMonitorConfig()) != null) {
            if (StringUtils.isNotBlank(monitorConfig.getServerGroupName())) {
                NodeBuilder.serverGroupName = monitorConfig.getServerGroupName();
            }
            if (monitorConfig.getReportInterval() > 0) {
                AmsMonitor.monitor.reportInterval = monitorConfig.getReportInterval();
            }
            serverUrl = monitorConfig.getServerUrl();
        }
        AmsMonitor.monitor.monitorService = MonitorService.getInstance();
        AmsMonitor.monitor.monitorService.initServerUrl(serverUrl);
        AmsMonitor.monitor.reporter = new MsgReporter(AmsMonitor.monitor.monitorService);
        AmsMonitor.monitor.registerThread = new Thread(monitor.new RegisterHandler());
        AmsMonitor.monitor.registerThread.setName("PostMsg Monitor-Register");
        AmsMonitor.monitor.registerThread.setDaemon(true);
        AmsMonitor.monitor.registerThread.start();
        AmsMonitor.monitor.reportThread = new Thread(monitor.new ReportHandler());
        AmsMonitor.monitor.reportThread.setName("PostMsg Monitor-Reporter");
        AmsMonitor.monitor.reportThread.setDaemon(true);
        AmsMonitor.monitor.reportThread.start();
        UserProfilesService.addUserProfilesListener(monitor);
        PostMsgLogger.logInfo("Monitor function enabled");
        Object var4_3 = null;
        monitorLock.unlock();
        return true;
    }

    public static boolean stopServer() throws RuntimeException {
        block6: {
            monitorLock.lock();
            if (monitoring) break block6;
            boolean bl = false;
            Object var2_2 = null;
            monitorLock.unlock();
            return bl;
        }
        try {
            try {
                PostMsgLogger.logInfo("Starting disable monitor function ...");
                UserProfilesService.removeUserProfilesListener(monitor);
                if (monitor != null) {
                    AmsMonitor.monitor.reportThread.interrupt();
                    AmsMonitor.monitor.registerThread.interrupt();
                    monitor = null;
                }
                monitoring = false;
                PostMsgLogger.logInfo("Monitor function disabled");
            }
            catch (Exception e) {
                PostMsgLogger.logInfo("Disable monitor function error: " + e.getMessage());
                throw new RuntimeException(e);
            }
            Object var2_3 = null;
            monitorLock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            monitorLock.unlock();
            throw throwable;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void listen(Account account) {
        block12: {
            if (!monitoring || account == null) {
                return;
            }
            String accountName = account.getName();
            String monitorToken = account.getMonitorToken();
            try {
                MonitorSecurity.AccountToken accountToken;
                if (StringUtils.isBlank(accountName)) {
                    return;
                }
                if (monitorToken == null) {
                    monitorToken = "";
                }
                if ((accountToken = (MonitorSecurity.AccountToken)AmsMonitor.monitor.accountTokenMap.get(accountName)) == null) {
                    ConcurrentMap<String, MonitorSecurity.AccountToken> concurrentMap = AmsMonitor.monitor.accountTokenMap;
                    synchronized (concurrentMap) {
                        accountToken = (MonitorSecurity.AccountToken)AmsMonitor.monitor.accountTokenMap.get(accountName);
                        if (accountToken == null) {
                            NodeMeta nodeMeta = NodeBuilder.generateNode(account.getName());
                            nodeMeta.setAccountName(account.getName());
                            AmsMonitor.monitor.accountTokenMap.put(accountName, new MonitorSecurity.AccountToken(account, monitorToken));
                            AmsMonitor.monitor.nodeMetaQueue.offer(nodeMeta);
                        } else {
                            accountToken.setAccount(account);
                            accountToken.setMonitorToken(monitorToken);
                        }
                        break block12;
                    }
                }
                if (StringUtils.isNotBlank(monitorToken)) {
                    accountToken.setAccount(account);
                    accountToken.setMonitorToken(monitorToken);
                }
            }
            catch (Exception e) {
                return;
            }
        }
    }

    private boolean registerNode(NodeMeta nodeMetadata, MonitorSecurity.AccountToken accountToken) {
        if (nodeMetadata == null) {
            return false;
        }
        int nodeId = this.monitorService.registerNode(nodeMetadata, accountToken);
        if (nodeId > 0) {
            nodeMetadata.getInfo().setNodeId(nodeId);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWhenRefresh() {
        UserProfiles profiles = UserProfilesService.getUserProfiles();
        if (profiles == null || profiles.getAms() == null) {
            return;
        }
        MonitorConfig monitorConfig = profiles.getAms().getMonitorConfig();
        if (monitorConfig == null) {
            return;
        }
        if (StringUtils.isNotBlank(monitorConfig.getServerGroupName())) {
            NodeBuilder.serverGroupName = monitorConfig.getServerGroupName();
        }
        if (StringUtils.isNotBlank(monitorConfig.getServerUrl())) {
            this.monitorService.initServerUrl(monitorConfig.getServerUrl());
        }
        monitorLock.lock();
        try {
            int newReportInterval = monitorConfig.getReportInterval();
            if (monitoring && newReportInterval > 0) {
                this.reportInterval = newReportInterval;
            }
            Object var5_4 = null;
            monitorLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            monitorLock.unlock();
            throw throwable;
        }
    }

    public static MonitorSecurity.AccountToken getTokenByAccount(String accountName) {
        if (monitor != null) {
            return (MonitorSecurity.AccountToken)AmsMonitor.monitor.accountTokenMap.get(accountName);
        }
        return null;
    }

    class ReportHandler
    implements Runnable {
        ReportHandler() {
        }

        public void run() {
            PostMsgLogger.logInfo("Starting report handler...");
            while (monitoring) {
                try {
                    TimeUnit.SECONDS.sleep(AmsMonitor.this.reportInterval);
                    AmsMonitor.this.reporter.report();
                }
                catch (InterruptedException e) {
                    PostMsgLogger.logWarn("Report handler interrupted");
                }
                catch (Exception e) {
                    PostMsgLogger.logError("Report metrics error: " + e.getMessage());
                }
            }
        }
    }

    class RegisterHandler
    implements Runnable {
        RegisterHandler() {
        }

        public void run() {
            PostMsgLogger.logInfo("Starting register handler...");
            while (monitoring) {
                NodeMeta metadata = null;
                boolean registerSuccess = false;
                try {
                    metadata = (NodeMeta)AmsMonitor.this.nodeMetaQueue.take();
                    if (metadata == null) continue;
                    MonitorSecurity.AccountToken accountToken = (MonitorSecurity.AccountToken)monitor.accountTokenMap.get(metadata.getAccountName());
                    if (accountToken == null) {
                        PostMsgLogger.logWarn("Try register node, but account and token is null");
                        continue;
                    }
                    String monitorToken = accountToken.getMonitorToken();
                    if (StringUtils.isNotBlank(monitorToken)) {
                        registerSuccess = AmsMonitor.this.registerNode(metadata, accountToken);
                        if (registerSuccess) {
                            AmsMonitor.this.reporter.addNodeMeta(metadata);
                            PostMsgLogger.logInfo("Register node success with id: " + metadata.getInfo().getNodeId());
                        }
                    } else {
                        PostMsgLogger.logWarn("Try register node, but monitor token is blank with account: " + metadata.getAccountName() + ", continue check...");
                    }
                }
                catch (InterruptedException e) {
                    PostMsgLogger.logWarn("Register handler interrupted");
                }
                catch (Exception e) {
                    PostMsgLogger.logError("Register node metadata failed: " + e.getMessage());
                }
                if (registerSuccess) continue;
                try {
                    AmsMonitor.this.nodeMetaQueue.offer(metadata);
                    Thread.sleep(30000L);
                }
                catch (Exception e) {
                    PostMsgLogger.logError("Register node failed and retry put to queue failed: " + e.getMessage());
                }
            }
        }
    }
}

