/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.ams;

import com.codahale.metrics.Counter;
import com.xuanwu.mos.ams.AmsMonitor;
import com.xuanwu.mos.ams.Collector;
import com.xuanwu.mos.ams.CollectorHelper;
import com.xuanwu.mos.ams.metric.MetricNameUtil;
import com.xuanwu.mos.ams.metric.Metrics;
import com.xuanwu.mos.ams.vo.AvgCostTimeCounter;
import com.xuanwu.mos.common.entity.Account;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ApiInvokeCollector
implements Collector {
    private static final Object MT_LOCK_OBJ = new Object();
    private static final Object MO_LOCK_OBJ = new Object();
    private static final Object REPORT_LOCK_OBJ = new Object();
    private final ConcurrentMap<String, AvgCostTimeCounter> avgCostTimeMap = new ConcurrentHashMap<String, AvgCostTimeCounter>();

    public static ApiInvokeCollector getInstance() {
        return ApiInvokeCollectorHolder.INSTANCE;
    }

    private ApiInvokeCollector() {
        CollectorHelper.addCollector(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrMtSuccessAndCostTime(Account account, long begin, long end, long innerCostTime) {
        if (!AmsMonitor.isMonitoring() || account == null || account.getName() == null) {
            return;
        }
        AmsMonitor.listen(account);
        Metrics.counter(MetricNameUtil.nameWithNode("api.success.mt", account.getName())).inc();
        long cost = end - begin;
        if (cost <= 0L) {
            return;
        }
        ApiInvokeCollector.getAvgCostTimeCounter(account.getName()).updateMt(cost, cost - innerCostTime);
        Counter maxCounter = Metrics.counter(MetricNameUtil.nameWithNode("api.maxCostTime.mt", account.getName()));
        Object object = MT_LOCK_OBJ;
        synchronized (object) {
            long old = maxCounter.getCount();
            if (cost > old) {
                maxCounter.inc(cost - old);
            }
        }
    }

    public static void incrMtFailure(Account account) {
        if (!AmsMonitor.isMonitoring() || account == null || account.getName() == null) {
            return;
        }
        Metrics.counter(MetricNameUtil.nameWithNode("api.failure.mt", account.getName())).inc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrMoSuccessAndCostTime(Account account, long begin, long end, long innerCostTime) {
        if (!AmsMonitor.isMonitoring() || account == null || account.getName() == null) {
            return;
        }
        AmsMonitor.listen(account);
        Metrics.counter(MetricNameUtil.nameWithNode("api.success.mo", account.getName())).inc();
        long cost = end - begin;
        if (cost <= 0L) {
            return;
        }
        ApiInvokeCollector.getAvgCostTimeCounter(account.getName()).updateMo(cost, cost - innerCostTime);
        Counter maxCounter = Metrics.counter(MetricNameUtil.nameWithNode("api.maxCostTime.mo", account.getName()));
        Object object = MO_LOCK_OBJ;
        synchronized (object) {
            long old = maxCounter.getCount();
            if (cost > old) {
                maxCounter.inc(cost - old);
            }
        }
    }

    public static void incrMoFailure(Account account) {
        if (!AmsMonitor.isMonitoring() || account == null || account.getName() == null) {
            return;
        }
        Metrics.counter(MetricNameUtil.nameWithNode("api.failure.mo", account.getName())).inc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrReportSuccessAndCostTime(Account account, long begin, long end, long innerCostTime) {
        if (!AmsMonitor.isMonitoring() || account == null || account.getName() == null) {
            return;
        }
        AmsMonitor.listen(account);
        Metrics.counter(MetricNameUtil.nameWithNode("api.success.report", account.getName())).inc();
        long cost = end - begin;
        if (cost <= 0L) {
            return;
        }
        ApiInvokeCollector.getAvgCostTimeCounter(account.getName()).updateReport(cost, cost - innerCostTime);
        Counter maxCounter = Metrics.counter(MetricNameUtil.nameWithNode("api.maxCostTime.report", account.getName()));
        Object object = REPORT_LOCK_OBJ;
        synchronized (object) {
            long old = maxCounter.getCount();
            if (cost > old) {
                maxCounter.inc(cost - old);
            }
        }
    }

    public static void incrReportFailure(Account account) {
        if (!AmsMonitor.isMonitoring() || account == null || account.getName() == null) {
            return;
        }
        Metrics.counter(MetricNameUtil.nameWithNode("api.failure.report", account.getName())).inc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AvgCostTimeCounter getAvgCostTimeCounter(String nodeName) {
        ConcurrentMap<String, AvgCostTimeCounter> avgCostTimeMap = ApiInvokeCollector.getInstance().avgCostTimeMap;
        AvgCostTimeCounter counter = (AvgCostTimeCounter)avgCostTimeMap.get(nodeName);
        if (counter == null) {
            ConcurrentMap<String, AvgCostTimeCounter> concurrentMap = avgCostTimeMap;
            synchronized (concurrentMap) {
                counter = (AvgCostTimeCounter)avgCostTimeMap.get(nodeName);
                if (counter == null) {
                    counter = new AvgCostTimeCounter();
                    avgCostTimeMap.put(nodeName, counter);
                }
            }
        }
        return counter;
    }

    public void collect() {
        for (Map.Entry entry : this.avgCostTimeMap.entrySet()) {
            String accountName = (String)entry.getKey();
            AvgCostTimeCounter counter = (AvgCostTimeCounter)entry.getValue();
            AvgCostTimeCounter.AvgCostTime mtAvgCostTime = counter.calMtAvgCostTime();
            Metrics.gauge(MetricNameUtil.nameWithNode("api.avgCostTime.mt", accountName), mtAvgCostTime.getAvgCost());
            Metrics.gauge(MetricNameUtil.nameWithNode("api.avgTrafficCostTime.mt", accountName), mtAvgCostTime.getAvgTrafficCost());
            AvgCostTimeCounter.AvgCostTime moAvgCostTime = counter.calMoAvgCostTime();
            Metrics.gauge(MetricNameUtil.nameWithNode("api.avgCostTime.mo", accountName), moAvgCostTime.getAvgCost());
            Metrics.gauge(MetricNameUtil.nameWithNode("api.avgTrafficCostTime.mo", accountName), moAvgCostTime.getAvgTrafficCost());
            AvgCostTimeCounter.AvgCostTime reportAvgCostTime = counter.calReportAvgCostTime();
            Metrics.gauge(MetricNameUtil.nameWithNode("api.avgCostTime.report", accountName), reportAvgCostTime.getAvgCost());
            Metrics.gauge(MetricNameUtil.nameWithNode("api.avgTrafficCostTime.report", accountName), reportAvgCostTime.getAvgTrafficCost());
        }
    }

    private static class ApiInvokeCollectorHolder {
        private static final ApiInvokeCollector INSTANCE = new ApiInvokeCollector();

        private ApiInvokeCollectorHolder() {
        }
    }
}

