/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.ams;

import com.xuanwu.mos.common.entity.Account;
import com.xuanwu.mos.common.entity.GsmsResponse;
import com.xuanwu.mos.common.entity.MOLoginResponse;
import com.xuanwu.mos.common.util.StringUtils;
import com.xuanwu.mos.common.util.XmlUtil;
import java.util.Map;

public class MonitorSecurity {
    public static final String TOKEN_NAME = "token";

    public static void processMtAccountToken(Account account, GsmsResponse resp) {
        if (account == null || resp == null) {
            return;
        }
        String attr = resp.getAttributes();
        if (StringUtils.isBlank(attr)) {
            return;
        }
        try {
            String token;
            Object tokenObj;
            Map attrMap = (Map)XmlUtil.fromXML(attr);
            if (attrMap != null && (tokenObj = attrMap.get(TOKEN_NAME)) != null && StringUtils.isNotBlank(token = (String)tokenObj)) {
                account.setMonitorToken(token);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void processMoAccountToken(Account account, MOLoginResponse resp) {
        if (account == null || resp == null) {
            return;
        }
        String attr = resp.getAttributes();
        if (StringUtils.isBlank(attr)) {
            return;
        }
        try {
            String token;
            Object tokenObj;
            Map attrMap = (Map)XmlUtil.fromXML(attr);
            if (attrMap != null && (tokenObj = attrMap.get(TOKEN_NAME)) != null && StringUtils.isNotBlank(token = (String)tokenObj)) {
                account.setMonitorToken(token);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class AccountToken {
        private Account account;
        private String monitorToken;

        public AccountToken() {
        }

        public AccountToken(Account account, String monitorToken) {
            this.account = account;
            this.monitorToken = monitorToken;
        }

        public Account getAccount() {
            return this.account;
        }

        public void setAccount(Account account) {
            this.account = account;
        }

        public String getMonitorToken() {
            return this.monitorToken;
        }

        public void setMonitorToken(String monitorToken) {
            this.monitorToken = monitorToken;
        }
    }
}

