/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.ams;

import com.xuanwu.mos.HostInfo;
import com.xuanwu.mos.ams.MonitorSecurity;
import com.xuanwu.mos.ams.metric.NodeBuilder;
import com.xuanwu.mos.ams.report.protocol.NodeMeta;
import com.xuanwu.mos.ams.report.protocol.NodeSample;
import com.xuanwu.mos.ams.vo.ResponseParams;
import com.xuanwu.mos.ams.vo.ResponseSuccessObj;
import com.xuanwu.mos.common.MTSupport;
import com.xuanwu.mos.common.entity.Account;
import com.xuanwu.mos.common.entity.GsmsResponse;
import com.xuanwu.mos.common.log.PostMsgLogger;
import com.xuanwu.mos.common.pool.SocketObject;
import com.xuanwu.mos.common.util.JsonUtil;
import com.xuanwu.mos.common.util.StringUtils;
import com.xuanwu.mos.common.util.ZipUtil;
import com.xuanwu.mos.common.util.http.HttpResponse;
import com.xuanwu.mos.common.util.http.WebUtils;
import com.xuanwu.mos.config.PostMsgConfig;
import com.xuanwu.mos.msggate.protobuf.mt.MTRequest;
import com.xuanwu.mos.msggate.protobuf.mt.MTResponse;
import com.xuanwu.mos.thirdparty.com.google.protobuf.ByteString;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;

public class MonitorService {
    private static final String REGISTRY_PATH = "/monitor/register";
    private static final String PUSH_METRIC_PATH = "/monitor/metrics";
    private String serverUrl;
    private String registryUrl;
    private String pushMetricsUrl;
    private static final String CONTENT_TYPE_JSON = "application/json;charset=utf-8";
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 10000;
    private static HostInfo mtHost;
    private static int maxFrameLen;
    private static final int SUCCESS_FLAG = 0;

    public static MonitorService getInstance() {
        return Holder.INSTANCE;
    }

    private MonitorService() {
    }

    public void initServerUrl(String serverUrl) {
        if (StringUtils.isBlank(serverUrl)) {
            return;
        }
        if ((serverUrl = serverUrl.trim()).endsWith("/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
        }
        this.serverUrl = serverUrl;
        this.registryUrl = serverUrl + REGISTRY_PATH;
        this.pushMetricsUrl = serverUrl + PUSH_METRIC_PATH;
    }

    public int registerNode(NodeMeta nodeMeta, MonitorSecurity.AccountToken accountToken) {
        if (nodeMeta == null) {
            return -1;
        }
        if (PostMsgConfig.isMonitorReportByMtChannel()) {
            return this.registerNodeByMtChannel(nodeMeta, accountToken.getAccount());
        }
        return this.registerNodeByHTTP(nodeMeta, accountToken.getMonitorToken());
    }

    private int registerNodeByHTTP(NodeMeta nodeMeta, String monitorToken) {
        if (StringUtils.isBlank(this.serverUrl)) {
            PostMsgLogger.logWarn("User profiles of monitor server URL is empty, can't register node");
            return -1;
        }
        PostMsgLogger.logInfo("Ready to register node...");
        try {
            Map<String, String> extInfo = nodeMeta.getInfo().getExtInfo();
            if (extInfo != null) {
                extInfo.put("groupName", NodeBuilder.serverGroupName);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", CONTENT_TYPE_JSON);
            headers.put("token", monitorToken == null ? "" : monitorToken);
            String content = JsonUtil.toJson(nodeMeta);
            HttpResponse response = WebUtils.doPost(this.registryUrl, headers, content.getBytes("UTF-8"), 5000, 10000);
            String respContent = response.getContent();
            if (response.getStatusCode() == 200) {
                ResponseSuccessObj respObj = JsonUtil.fromJson(respContent, ResponseSuccessObj.class);
                ResponseParams responseParams = respObj.getResponseParams();
                if (responseParams != null && responseParams.getNodeId() != null) {
                    return responseParams.getNodeId();
                }
            } else {
                PostMsgLogger.logError("Register/connect node[" + nodeMeta.getInfo() + "] failed: http code: " + response.getStatusCode() + ", content: " + respContent);
            }
        }
        catch (Exception e) {
            PostMsgLogger.logError("Register/connect node[" + nodeMeta.getInfo() + "] failed: " + e.getMessage());
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int registerNodeByMtChannel(NodeMeta nodeMeta, Account account) {
        SocketObject sockObj;
        block9: {
            int n;
            block10: {
                if (mtHost == null) {
                    PostMsgLogger.logWarn("MT host is null, can't register node");
                    return -1;
                }
                if (account == null) {
                    PostMsgLogger.logWarn("Account is null, can't register node");
                    return -1;
                }
                PostMsgLogger.logInfo("Ready to register node...");
                sockObj = null;
                try {
                    try {
                        String content = JsonUtil.toJson(nodeMeta);
                        sockObj = MonitorService.createSocketObject();
                        GsmsResponse resp = MonitorService.doMtLogin(sockObj, account);
                        if (resp.getResult() != 0) {
                            PostMsgLogger.logWarn("Register node failure with login result: " + resp.getResult());
                            int n2 = -1;
                            Object var12_9 = null;
                            if (sockObj == null) return n2;
                            sockObj.destory();
                            return n2;
                        }
                        resp = MonitorService.sendMassMessageToMt(sockObj, MTRequest.TRequestType.LOGOUT, content);
                        int result = resp.getResult();
                        String respContent = resp.getMessage();
                        if (result == 0) {
                            ResponseSuccessObj respObj = JsonUtil.fromJson(respContent, ResponseSuccessObj.class);
                            ResponseParams responseParams = respObj.getResponseParams();
                            if (responseParams == null || responseParams.getNodeId() == null) break block9;
                            n = responseParams.getNodeId();
                            break block10;
                        }
                        PostMsgLogger.logError("Register/connect node[" + nodeMeta.getInfo() + "] failed: result code: " + result + ", content: " + respContent);
                        break block9;
                    }
                    catch (Exception e) {
                        PostMsgLogger.logError("Register/connect node[" + nodeMeta.getInfo() + "] failed: " + e.getMessage());
                        Object var12_12 = null;
                        if (sockObj == null) return -1;
                        sockObj.destory();
                        return -1;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    if (sockObj == null) throw throwable;
                    sockObj.destory();
                    throw throwable;
                }
            }
            Object var12_10 = null;
            if (sockObj == null) return n;
            sockObj.destory();
            return n;
        }
        Object var12_11 = null;
        if (sockObj == null) return -1;
        sockObj.destory();
        return -1;
    }

    public void pushMetrics(NodeSample nodeSample, MonitorSecurity.AccountToken accountToken) {
        if (PostMsgConfig.isMonitorReportByMtChannel()) {
            this.pushMetricsByMtChannel(nodeSample, accountToken.getAccount());
        } else {
            this.pushMetricsByHTTP(nodeSample, accountToken.getMonitorToken());
        }
    }

    private void pushMetricsByHTTP(NodeSample nodeSample, String monitorToken) {
        if (StringUtils.isBlank(this.serverUrl)) {
            PostMsgLogger.logWarn("User profiles of monitor server URL is empty, can't push metrics");
            return;
        }
        if (StringUtils.isBlank(monitorToken)) {
            PostMsgLogger.logWarn("Monitor token is empty when report metrics");
            return;
        }
        PostMsgLogger.logInfo("Ready to push metrics...");
        try {
            if (monitorToken == null) {
                monitorToken = "";
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", CONTENT_TYPE_JSON);
            headers.put("token", monitorToken);
            String content = JsonUtil.toJson(nodeSample);
            HttpResponse response = WebUtils.doPost(this.pushMetricsUrl, headers, content.getBytes("UTF-8"), 5000, 10000);
            if (response.getStatusCode() != 200) {
                String respContent = response.getContent();
                PostMsgLogger.logError("Push metrics response failed nodeId[" + nodeSample.getNodeId() + "] by:" + respContent);
            }
        }
        catch (Exception e) {
            PostMsgLogger.logError("Push metrics failed nodeId[" + nodeSample.getNodeId() + "]: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pushMetricsByMtChannel(NodeSample nodeSample, Account account) {
        if (mtHost == null) {
            PostMsgLogger.logWarn("MT host is null, can't push metrics");
            return;
        }
        if (account == null) {
            PostMsgLogger.logWarn("MT account is null, can't push metrics");
            return;
        }
        PostMsgLogger.logInfo("Ready to push metrics...");
        SocketObject sockObj = null;
        try {
            try {
                String content = JsonUtil.toJson(nodeSample);
                sockObj = MonitorService.createSocketObject();
                GsmsResponse resp = MonitorService.doMtLogin(sockObj, account);
                if (resp.getResult() != 0) {
                    PostMsgLogger.logWarn("Push metrics failure with login result: " + resp.getResult());
                    Object var9_7 = null;
                    if (sockObj == null) return;
                    sockObj.destory();
                    return;
                }
                resp = MonitorService.sendMassMessageToMt(sockObj, MTRequest.TRequestType.LOGOUT, content);
                int result = resp.getResult();
                if (result != 0) {
                    String respContent = resp.getMessage();
                    PostMsgLogger.logError("Push metrics response failed nodeId[" + nodeSample.getNodeId() + "], result code: " + result + ", content: " + respContent);
                }
            }
            catch (Exception e) {
                PostMsgLogger.logError("Push metrics failed nodeId[" + nodeSample.getNodeId() + "]: " + e.getMessage());
                Object var9_9 = null;
                if (sockObj == null) return;
                sockObj.destory();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (sockObj == null) throw throwable;
            sockObj.destory();
            throw throwable;
        }
        Object var9_8 = null;
        if (sockObj == null) return;
        sockObj.destory();
    }

    private static GsmsResponse doMtLogin(SocketObject sockObj, Account account) throws Exception {
        byte[] recvBytes = MonitorService.transferToMt(sockObj, MTSupport.getLoginBytes(account));
        return MTSupport.getResponse(recvBytes);
    }

    private static GsmsResponse sendMassMessageToMt(SocketObject sockObj, MTRequest.TRequestType type, String content) throws Exception {
        MTRequest.TRequest.Builder reqBuilder = MTRequest.TRequest.newBuilder();
        reqBuilder.setType(type);
        reqBuilder.setMassMsg(ByteString.copyFrom(ZipUtil.zipByteArray(content.getBytes("UTF-8"))));
        byte[] sendBytes = reqBuilder.build().toByteArray();
        byte[] recvBytes = MonitorService.transferToMt(sockObj, sendBytes);
        MTResponse.TResponse.Builder respBuilder = MTResponse.TResponse.newBuilder();
        respBuilder.mergeFrom(recvBytes);
        GsmsResponse resp = new GsmsResponse();
        resp.setMessage(respBuilder.getMessage());
        resp.setResult(respBuilder.getResult().getNumber());
        return resp;
    }

    private static SocketObject createSocketObject() throws IOException {
        Socket socket = new Socket();
        socket.setSoTimeout(10000);
        socket.setTcpNoDelay(true);
        socket.connect(new InetSocketAddress(mtHost.getIp(), mtHost.getPort()), 5000);
        SocketObject sockObj = new SocketObject(socket);
        return sockObj;
    }

    private static byte[] transferToMt(SocketObject sockObj, byte[] sendBytes) throws Exception {
        sockObj.getDos().writeInt(sendBytes.length);
        sockObj.getDos().write(sendBytes);
        sockObj.getDos().flush();
        int recvLength = sockObj.getDis().readInt();
        if (recvLength > maxFrameLen || recvLength < 0) {
            sockObj.destory();
            throw new RuntimeException("Adjusted frame length exceeds " + maxFrameLen + ": " + recvLength);
        }
        byte[] recvBytes = new byte[recvLength];
        sockObj.getDis().readFully(recvBytes);
        return recvBytes;
    }

    public static GsmsResponse loginAndPushMonitorData(Account account, String content) throws Exception {
        SocketObject sockObj;
        block10: {
            if (account == null) {
                throw new RuntimeException("Account can't be null");
            }
            if (StringUtils.isBlank(content)) {
                throw new RuntimeException("Content can't be blank");
            }
            if (mtHost == null) {
                throw new RuntimeException("MT host is null, can't push monitor data");
            }
            sockObj = null;
            sockObj = MonitorService.createSocketObject();
            GsmsResponse resp = MonitorService.doMtLogin(sockObj, account);
            if (resp.getResult() == 0) break block10;
            GsmsResponse gsmsResponse = resp;
            Object var6_7 = null;
            if (sockObj != null) {
                sockObj.destory();
            }
            return gsmsResponse;
        }
        try {
            GsmsResponse gsmsResponse = MonitorService.sendMassMessageToMt(sockObj, MTRequest.TRequestType.LOGOUT, content);
            Object var6_8 = null;
            if (sockObj != null) {
                sockObj.destory();
            }
            return gsmsResponse;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var6_9 = null;
                    if (sockObj == null) break block11;
                    sockObj.destory();
                }
                throw throwable;
            }
        }
    }

    public static void setMtHost(HostInfo mtHost) {
        MonitorService.mtHost = mtHost;
    }

    static {
        maxFrameLen = 0xA00000;
    }

    private static class Holder {
        private static final MonitorService INSTANCE = new MonitorService();

        private Holder() {
        }
    }
}

