/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.ams;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.xuanwu.mos.ams.AmsMonitor;
import com.xuanwu.mos.ams.CollectorHelper;
import com.xuanwu.mos.ams.MonitorSecurity;
import com.xuanwu.mos.ams.MonitorService;
import com.xuanwu.mos.ams.metric.MetricNameUtil;
import com.xuanwu.mos.ams.metric.Metrics;
import com.xuanwu.mos.ams.report.protocol.MeasureMentField;
import com.xuanwu.mos.ams.report.protocol.NodeMeta;
import com.xuanwu.mos.ams.report.protocol.NodePoint;
import com.xuanwu.mos.ams.report.protocol.NodeSample;
import com.xuanwu.mos.common.log.PostMsgLogger;
import com.xuanwu.mos.common.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsgReporter {
    private final MetricRegistry registry;
    private final MetricFilter filter;
    private MonitorService monitorService;
    private static final long THOUSAND_UNIT = 1000L;
    private List<NodeMeta> nodeMetaList = new ArrayList<NodeMeta>();

    public MsgReporter(MonitorService monitorService) {
        this.registry = Metrics.metrics();
        this.filter = MetricFilter.ALL;
        this.monitorService = monitorService;
    }

    public void addNodeMeta(NodeMeta nodeMeta) {
        this.nodeMetaList.add(nodeMeta);
        this.initMetrics(nodeMeta);
    }

    private void initMetrics(NodeMeta nodeMeta) {
        Map<String, NodeMeta.MetricMeta> metricMap = this.getMetricMetaMap(nodeMeta);
        for (NodeMeta.GraphMeta graphMeta : nodeMeta.getGraphs()) {
            List<String> instances = graphMeta.getInstances();
            if (instances == null || instances.size() == 0) {
                this.registerMetric(metricMap, nodeMeta, graphMeta, null);
                continue;
            }
            for (String inst : instances) {
                this.registerMetric(metricMap, nodeMeta, graphMeta, inst);
            }
        }
    }

    private Map<String, NodeMeta.MetricMeta> getMetricMetaMap(NodeMeta nodeMeta) {
        HashMap<String, NodeMeta.MetricMeta> metricMap = new HashMap<String, NodeMeta.MetricMeta>();
        for (NodeMeta.MetricMeta metric : nodeMeta.getMetrics()) {
            metricMap.put(metric.getName(), metric);
        }
        return metricMap;
    }

    private void registerMetric(Map<String, NodeMeta.MetricMeta> metricMap, NodeMeta nodeMeta, NodeMeta.GraphMeta graphMeta, String inst) {
        for (String metric : graphMeta.getRefMetrics()) {
            NodeMeta.MetricMeta meta = metricMap.get(metric);
            String nodeName = nodeMeta.getInfo().getNodeName();
            String metricName = this.getMetricName(nodeName, this.getCompleteMetricName(nodeMeta, meta), inst);
            switch (NodeMeta.DataType.getType(meta.getDsType())) {
                case GAUGE: {
                    Metrics.gauge(metricName, 0);
                    break;
                }
                case COUNTER: {
                    Metrics.counter(metricName);
                    break;
                }
                case METER: {
                    Metrics.meter(metricName);
                    break;
                }
                case TIMER: {
                    Metrics.timer(metricName);
                    break;
                }
                case HISTOGRAM: {
                    Metrics.histogram(metricName);
                    break;
                }
                case RESET_COUNTER: {
                    Metrics.counter(metricName);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report() {
        MsgReporter msgReporter = this;
        synchronized (msgReporter) {
            CollectorHelper.beforeReport();
            this.report(this.registry.getGauges(this.filter), this.registry.getCounters(this.filter), this.registry.getHistograms(this.filter), this.registry.getMeters(this.filter), this.registry.getTimers(this.filter));
        }
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        if (this.nodeMetaList == null || this.nodeMetaList.size() == 0) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        for (NodeMeta nodeMeta : this.nodeMetaList) {
            this.pushNodeSample(nodeMeta, timestamp, gauges, counters, histograms, meters, timers);
        }
    }

    private void pushNodeSample(NodeMeta nodeMeta, long timeStamp, SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        NodeSample sample = new NodeSample();
        sample.setNodeId(String.valueOf(nodeMeta.getInfo().getNodeId()));
        sample.setTimeStamp(timeStamp);
        ArrayList<NodePoint> nodePoints = new ArrayList<NodePoint>();
        sample.setPoints(nodePoints);
        for (NodeMeta.GraphMeta graph : nodeMeta.getGraphs()) {
            List<String> tags = graph.getInstances();
            if (tags == null || tags.size() == 0) {
                nodePoints.add(this.getNodePoint(nodeMeta, graph, null, gauges, counters, histograms, meters, timers));
                continue;
            }
            for (String tag : tags) {
                nodePoints.add(this.getNodePoint(nodeMeta, graph, tag, gauges, counters, histograms, meters, timers));
            }
        }
        MonitorSecurity.AccountToken accountToken = AmsMonitor.getTokenByAccount(nodeMeta.getAccountName());
        if (accountToken == null) {
            PostMsgLogger.logWarn("Account token is null when report metrics");
            return;
        }
        this.monitorService.pushMetrics(sample, accountToken);
    }

    private NodePoint getNodePoint(NodeMeta nodeMeta, NodeMeta.GraphMeta graphMeta, String tag, SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        NodePoint point = new NodePoint();
        point.setMeasurement(this.getMeasurementName(nodeMeta, graphMeta));
        if (StringUtils.isNotBlank(tag)) {
            point.setTags(tag);
        }
        ArrayList<MeasureMentField> fields = new ArrayList<MeasureMentField>();
        point.setFields(fields);
        List<String> metrics = graphMeta.getRefMetrics();
        for (String metricMetaName : metrics) {
            MeasureMentField filed = this.getField(nodeMeta, metricMetaName, tag, gauges, counters, histograms, meters, timers);
            if (null == filed) continue;
            fields.add(filed);
        }
        return point;
    }

    private String getMeasurementName(NodeMeta nodeMeta, NodeMeta.GraphMeta graphMeta) {
        String ns;
        String string = ns = StringUtils.isBlank(graphMeta.getNameSpace()) ? nodeMeta.getInfo().getMetricNs() : graphMeta.getNameSpace();
        if (StringUtils.isNotBlank(ns)) {
            return ns + "." + graphMeta.getName();
        }
        return graphMeta.getName();
    }

    private MeasureMentField getField(NodeMeta nodeMeta, String metricMetaName, String tag, SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        NodeMeta.MetricMeta metricMeta = this.getMetricMeta(nodeMeta.getMetrics(), metricMetaName);
        String nodeName = nodeMeta.getInfo().getNodeName();
        String completeMetricName = this.getCompleteMetricName(nodeMeta, metricMeta);
        String instanceMetricName = this.getMetricName(nodeName, completeMetricName, tag);
        if (null == metricMeta) {
            PostMsgLogger.logError("Can't find the [" + instanceMetricName + "] metricMeta, please check!");
            return null;
        }
        Object value = null;
        try {
            switch (NodeMeta.DataType.getType(metricMeta.getDsType())) {
                case GAUGE: {
                    value = ((Gauge)gauges.get(instanceMetricName)).getValue();
                    break;
                }
                case COUNTER: {
                    value = ((Counter)counters.get(instanceMetricName)).getCount();
                    break;
                }
                case METER: {
                    value = ((Meter)meters.get(instanceMetricName)).getOneMinuteRate();
                    break;
                }
                case TIMER: {
                    double mean = ((Timer)timers.get(instanceMetricName)).getSnapshot().getMean();
                    value = mean / 1000.0;
                    break;
                }
                case HISTOGRAM: {
                    value = ((Histogram)histograms.get(instanceMetricName)).getSnapshot().getMean();
                    break;
                }
                case RESET_COUNTER: {
                    value = ((Counter)counters.get(instanceMetricName)).getCount();
                    Metrics.counter(instanceMetricName).dec(((Long)value).longValue());
                    break;
                }
            }
        }
        catch (Exception e) {
            PostMsgLogger.logError("Get metric[" + instanceMetricName + "] value failed,may be can't find the metric in registry,please check: " + e.getMessage());
        }
        return new MeasureMentField(completeMetricName, value);
    }

    private NodeMeta.MetricMeta getMetricMeta(List<NodeMeta.MetricMeta> metas, String name) {
        if (StringUtils.isBlank(name) || metas == null || metas.size() == 0) {
            return null;
        }
        for (NodeMeta.MetricMeta meta : metas) {
            if (!name.equals(meta.getName())) continue;
            return meta;
        }
        return null;
    }

    private String getCompleteMetricName(NodeMeta nodeMeta, NodeMeta.MetricMeta metricMeta) {
        String metricNs;
        String string = metricNs = StringUtils.isBlank(metricMeta.getMetricNs()) ? nodeMeta.getInfo().getMetricNs() : metricMeta.getMetricNs();
        if (StringUtils.isNotBlank(metricNs)) {
            return metricNs + "." + metricMeta.getName();
        }
        return metricMeta.getName();
    }

    private String getMetricName(String nodeName, String name, String tag) {
        return MetricNameUtil.name(name, tag, nodeName);
    }
}

