/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.ams.metric;

import com.xuanwu.mos.common.util.StringUtils;

public class MetricNameUtil {
    public static String name(String metricName) {
        return MetricNameUtil.name(metricName, null);
    }

    public static String name(String metricName, String instName) {
        return MetricNameUtil.name(metricName, instName, null);
    }

    public static String nameWithNode(String metricName, String nodeName) {
        return MetricNameUtil.name(MetricNameUtil.withNamespace(metricName, "gsms.sdk"), null, nodeName);
    }

    public static String nameWithNode(String metricName, String nodeName, String nameSpace) {
        return MetricNameUtil.name(MetricNameUtil.withNamespace(metricName, nameSpace), null, nodeName);
    }

    public static String name(String metricName, String instName, String nodeName) {
        if (StringUtils.isBlank(metricName)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank(nodeName)) {
            sb.append(nodeName).append(",");
        }
        sb.append(metricName);
        if (StringUtils.isNotBlank(instName)) {
            sb.append(",").append(instName);
        }
        return sb.toString();
    }

    private static String withNamespace(String metricName, String nameSpace) {
        if (StringUtils.isNotBlank(nameSpace)) {
            return nameSpace + "." + metricName;
        }
        return metricName;
    }
}

