/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.ams.metric;

import com.xuanwu.mos.ams.report.protocol.NodeMeta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NodeBuilder {
    private String accountName;
    private String ns;
    private int period;
    private List<NodeMeta.MetricMeta> metrics = new ArrayList<NodeMeta.MetricMeta>();
    private Map<String, NodeMeta.GraphMeta> graphMap = new HashMap<String, NodeMeta.GraphMeta>();
    private Map<String, Set<String>> graphMetricMap = new HashMap<String, Set<String>>();
    public static final String NAMESPACE = "gsms.sdk";
    public static String serverGroupName = "unknown";
    public static final int GATHER_PERIOD = 60;

    public static NodeMeta generateNode(String account) {
        NodeBuilder builder = new NodeBuilder();
        builder.account(account).ns(NAMESPACE).period(60);
        builder.graph("netTraffic", "\u7f51\u7edc\u6d41\u91cf", "\u5b57\u8282\u6570");
        builder.graph("netError", "\u7f51\u7edc\u9519\u8bef", "\u6b21\u6570");
        builder.metric("netTraffic", "net.traffic.read", "\u63a5\u6536", NodeMeta.DataType.RESET_COUNTER.getName(), "\u63a5\u6536\u5b57\u8282\u6570");
        builder.metric("netTraffic", "net.traffic.write", "\u53d1\u9001", NodeMeta.DataType.RESET_COUNTER.getName(), "\u53d1\u9001\u5b57\u8282\u6570");
        builder.metric("netError", "net.error", "\u9519\u8bef", NodeMeta.DataType.RESET_COUNTER.getName(), "\u7f51\u7edc\u9519\u8bef\u6b21\u6570");
        builder.graph("bizMsg", "\u6d88\u606f\u603b\u91cf(\u6210\u529f)", "\u603b\u6761\u6570");
        builder.metric("bizMsg", "bizMsg.mt", "\u4e0b\u884c", NodeMeta.DataType.RESET_COUNTER.getName(), "\u4e0b\u884c\u603b\u6761\u6570");
        builder.metric("bizMsg", "bizMsg.mo", "\u4e0a\u884c", NodeMeta.DataType.RESET_COUNTER.getName(), "\u4e0a\u884c\u603b\u6761\u6570");
        builder.metric("bizMsg", "bizMsg.report", "\u72b6\u6001\u62a5\u544a", NodeMeta.DataType.RESET_COUNTER.getName(), "\u72b6\u6001\u62a5\u544a\u603b\u6761\u6570");
        builder.graph("apiSuccess", "\u63a5\u53e3\u8c03\u7528\u6210\u529f", "\u6b21\u6570");
        builder.graph("apiFailure", "\u63a5\u53e3\u8c03\u7528\u5931\u8d25", "\u6b21\u6570");
        builder.graph("apiAvgCostTime", "\u63a5\u53e3\u8c03\u7528\u5e73\u5747\u8017\u65f6", "\u6beb\u79d2");
        builder.graph("apiMaxCostTime", "\u63a5\u53e3\u8c03\u7528\u6700\u5927\u8017\u65f6", "\u6beb\u79d2");
        builder.graph("apiAvgTrafficCostTime", "\u63a5\u53e3\u8c03\u7528\u7f51\u7edc\u5e73\u5747\u5ef6\u65f6", "\u6beb\u79d2");
        builder.metric("apiSuccess", "api.success.mt", "\u4e0b\u884c", NodeMeta.DataType.RESET_COUNTER.getName(), "\u4e0b\u884c\u63a5\u53e3\u6210\u529f\u6570");
        builder.metric("apiFailure", "api.failure.mt", "\u4e0b\u884c", NodeMeta.DataType.RESET_COUNTER.getName(), "\u4e0b\u884c\u63a5\u53e3\u5931\u8d25\u6570");
        builder.metric("apiAvgCostTime", "api.avgCostTime.mt", "\u4e0b\u884c", NodeMeta.DataType.GAUGE.getName(), "\u4e0b\u884c\u63a5\u53e3\u5e73\u5747\u8017\u65f6");
        builder.metric("apiMaxCostTime", "api.maxCostTime.mt", "\u4e0b\u884c", NodeMeta.DataType.RESET_COUNTER.getName(), "\u4e0b\u884c\u63a5\u53e3\u6700\u5927\u8017\u65f6");
        builder.metric("apiAvgTrafficCostTime", "api.avgTrafficCostTime.mt", "\u4e0b\u884c", NodeMeta.DataType.GAUGE.getName(), "\u4e0b\u884c\u63a5\u53e3\u7f51\u7edc\u5e73\u5747\u5ef6\u65f6");
        builder.metric("apiSuccess", "api.success.mo", "\u4e0a\u884c", NodeMeta.DataType.RESET_COUNTER.getName(), "\u4e0a\u884c\u63a5\u53e3\u6210\u529f\u6570");
        builder.metric("apiFailure", "api.failure.mo", "\u4e0a\u884c", NodeMeta.DataType.RESET_COUNTER.getName(), "\u4e0a\u884c\u63a5\u53e3\u5931\u8d25\u6570");
        builder.metric("apiAvgCostTime", "api.avgCostTime.mo", "\u4e0a\u884c", NodeMeta.DataType.GAUGE.getName(), "\u4e0a\u884c\u63a5\u53e3\u5e73\u5747\u8017\u65f6");
        builder.metric("apiMaxCostTime", "api.maxCostTime.mo", "\u4e0a\u884c", NodeMeta.DataType.RESET_COUNTER.getName(), "\u4e0a\u884c\u63a5\u53e3\u6700\u5927\u8017\u65f6");
        builder.metric("apiAvgTrafficCostTime", "api.avgTrafficCostTime.mo", "\u4e0a\u884c", NodeMeta.DataType.GAUGE.getName(), "\u4e0a\u884c\u63a5\u53e3\u7f51\u7edc\u5e73\u5747\u5ef6\u65f6");
        builder.metric("apiSuccess", "api.success.report", "\u72b6\u6001\u62a5\u544a", NodeMeta.DataType.RESET_COUNTER.getName(), "\u72b6\u6001\u62a5\u544a\u63a5\u53e3\u6210\u529f\u6570");
        builder.metric("apiFailure", "api.failure.report", "\u72b6\u6001\u62a5\u544a", NodeMeta.DataType.RESET_COUNTER.getName(), "\u72b6\u6001\u62a5\u544a\u63a5\u53e3\u5931\u8d25\u6570");
        builder.metric("apiAvgCostTime", "api.avgCostTime.report", "\u72b6\u6001\u62a5\u544a", NodeMeta.DataType.GAUGE.getName(), "\u72b6\u6001\u62a5\u544a\u63a5\u53e3\u5e73\u5747\u8017\u65f6");
        builder.metric("apiMaxCostTime", "api.maxCostTime.report", "\u72b6\u6001\u62a5\u544a", NodeMeta.DataType.RESET_COUNTER.getName(), "\u72b6\u6001\u62a5\u544a\u63a5\u53e3\u6700\u5927\u8017\u65f6");
        builder.metric("apiAvgTrafficCostTime", "api.avgTrafficCostTime.report", "\u72b6\u6001\u62a5\u544a", NodeMeta.DataType.GAUGE.getName(), "\u72b6\u6001\u62a5\u544a\u63a5\u53e3\u7f51\u7edc\u5e73\u5747\u5ef6\u65f6");
        return builder.build();
    }

    public NodeBuilder account(String account) {
        this.accountName = account;
        return this;
    }

    public NodeBuilder period(int period) {
        this.period = period;
        return this;
    }

    public NodeBuilder ns(String ns) {
        this.ns = ns;
        return this;
    }

    public NodeBuilder metric(String graphName, String name, String showName, String dsType, String desc) {
        this.metrics.add(new MetricBuilder().name(name).showName(showName).type(dsType).desc(desc).build());
        this.putGraphMap(graphName, name);
        return this;
    }

    public NodeBuilder graph(String name, String showName, String label) {
        this.graphMap.put(name, new GraphBuilder().name(name).showName(showName).label(label).build());
        return this;
    }

    private void putGraphMap(String graphName, String metricName) {
        Set<String> refMetrics = this.graphMetricMap.get(graphName);
        if (null == refMetrics) {
            refMetrics = new HashSet<String>();
            this.graphMetricMap.put(graphName, refMetrics);
        }
        refMetrics.add(metricName);
    }

    public NodeMeta build() {
        NodeMeta meta = new NodeMeta();
        meta.setGatherPeriod(this.period);
        meta.setInfo(new NodeInfoBuilder().account(this.accountName).ns(this.ns).build());
        meta.setMetrics(this.metrics);
        for (Map.Entry<String, NodeMeta.GraphMeta> entry : this.graphMap.entrySet()) {
            Set<String> metrics = this.graphMetricMap.get(entry.getKey());
            if (null == metrics || metrics.size() <= 0) continue;
            entry.getValue().setRefMetrics(new ArrayList<String>(metrics));
        }
        meta.setGraphs(new ArrayList<NodeMeta.GraphMeta>(this.graphMap.values()));
        return meta;
    }

    public static class GraphBuilder {
        private String name;
        private String showName;
        private String vLabel;

        public GraphBuilder name(String name) {
            this.name = name;
            return this;
        }

        public GraphBuilder showName(String showName) {
            this.showName = showName;
            return this;
        }

        public GraphBuilder label(String vLabel) {
            this.vLabel = vLabel;
            return this;
        }

        public NodeMeta.GraphMeta build() {
            NodeMeta.GraphMeta graphMeta = new NodeMeta.GraphMeta();
            graphMeta.setName(this.name);
            graphMeta.setShowName(this.showName);
            graphMeta.setvLabel(this.vLabel);
            return graphMeta;
        }
    }

    public static class NodeInfoBuilder {
        private String nodeVer;
        private String nodeDesc;
        private String metricNs;
        private String accountName;

        public NodeInfoBuilder desc(String desc) {
            this.nodeDesc = desc;
            return this;
        }

        public NodeInfoBuilder version(String version) {
            this.nodeVer = version;
            return this;
        }

        public NodeInfoBuilder ns(String ns) {
            this.metricNs = ns;
            return this;
        }

        public NodeInfoBuilder account(String account) {
            this.accountName = account;
            return this;
        }

        public NodeMeta.Info build() {
            NodeMeta.Info info = new NodeMeta.Info();
            info.setNodeName(this.accountName);
            info.setNodeDesc(this.nodeDesc);
            info.setNodeVer(this.nodeVer);
            info.setMetricNs(this.metricNs);
            info.setNodeType(NodeMeta.NodeType.GSMS_SDK.getTypeName());
            HashMap<String, String> extInfo = new HashMap<String, String>();
            extInfo.put("account", this.accountName);
            extInfo.put("groupName", serverGroupName);
            info.setExtInfo(extInfo);
            return info;
        }
    }

    public static class MetricBuilder {
        private String name;
        private String showName;
        private String dsType;
        private String desc;

        public MetricBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MetricBuilder showName(String showName) {
            this.showName = showName;
            return this;
        }

        public MetricBuilder type(String dsType) {
            this.dsType = dsType;
            return this;
        }

        public MetricBuilder desc(String desc) {
            this.desc = desc;
            return this;
        }

        public NodeMeta.MetricMeta build() {
            NodeMeta.MetricMeta metric = new NodeMeta.MetricMeta();
            metric.setDesc(this.desc);
            metric.setDsType(this.dsType);
            metric.setName(this.name);
            metric.setShowName(this.showName);
            return metric;
        }
    }
}

