/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.ams.vo;

import java.util.concurrent.atomic.AtomicLong;

public class AvgCostTimeCounter {
    private final AtomicLong mtCount = new AtomicLong();
    private final AtomicLong totalMtCost = new AtomicLong();
    private final AtomicLong totalMtTrafficCost = new AtomicLong();
    private final AtomicLong moCount = new AtomicLong();
    private final AtomicLong totalMoCost = new AtomicLong();
    private final AtomicLong totalMoTrafficCost = new AtomicLong();
    private final AtomicLong reportCount = new AtomicLong();
    private final AtomicLong totalReportCost = new AtomicLong();
    private final AtomicLong totalReportTrafficCost = new AtomicLong();

    public void updateMt(long cost, long trafficCost) {
        this.mtCount.incrementAndGet();
        this.totalMtCost.addAndGet(cost);
        this.totalMtTrafficCost.addAndGet(trafficCost);
    }

    public void updateMo(long cost, long trafficCost) {
        this.moCount.incrementAndGet();
        this.totalMoCost.addAndGet(cost);
        this.totalMoTrafficCost.addAndGet(trafficCost);
    }

    public void updateReport(long cost, long trafficCost) {
        this.reportCount.incrementAndGet();
        this.totalReportCost.addAndGet(cost);
        this.totalReportTrafficCost.addAndGet(trafficCost);
    }

    public AvgCostTime calMtAvgCostTime() {
        long count = this.mtCount.getAndSet(0L);
        long total = this.totalMtCost.getAndSet(0L);
        long trafficTotal = this.totalMtTrafficCost.getAndSet(0L);
        long avgCost = 0L;
        long avgTrafficCost = 0L;
        if (count > 0L) {
            avgCost = total / count;
            avgTrafficCost = trafficTotal / count;
        }
        return new AvgCostTime(avgCost, avgTrafficCost);
    }

    public AvgCostTime calMoAvgCostTime() {
        long count = this.moCount.getAndSet(0L);
        long total = this.totalMoCost.getAndSet(0L);
        long trafficTotal = this.totalMoTrafficCost.getAndSet(0L);
        long avgCost = 0L;
        long avgTrafficCost = 0L;
        if (count > 0L) {
            avgCost = total / count;
            avgTrafficCost = trafficTotal / count;
        }
        return new AvgCostTime(avgCost, avgTrafficCost);
    }

    public AvgCostTime calReportAvgCostTime() {
        long count = this.reportCount.getAndSet(0L);
        long total = this.totalReportCost.getAndSet(0L);
        long trafficTotal = this.totalReportTrafficCost.getAndSet(0L);
        long avgCost = 0L;
        long avgTrafficCost = 0L;
        if (count > 0L) {
            avgCost = total / count;
            avgTrafficCost = trafficTotal / count;
        }
        return new AvgCostTime(avgCost, avgTrafficCost);
    }

    public class AvgCostTime {
        private long avgCost;
        private long avgTrafficCost;

        public AvgCostTime(long avgCost, long avgTrafficCost) {
            this.avgCost = avgCost;
            this.avgTrafficCost = avgTrafficCost;
        }

        public long getAvgCost() {
            return this.avgCost;
        }

        public long getAvgTrafficCost() {
            return this.avgTrafficCost;
        }
    }
}

