/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.common;

import com.xuanwu.mos.common.entity.Account;
import com.xuanwu.mos.common.entity.AccountInfo;
import com.xuanwu.mos.common.entity.BindChannel;
import com.xuanwu.mos.common.entity.BusinessType;
import com.xuanwu.mos.common.entity.MOLoginResponse;
import com.xuanwu.mos.common.entity.MOMsg;
import com.xuanwu.mos.common.entity.MTReport;
import com.xuanwu.mos.common.entity.MTResponse;
import com.xuanwu.mos.common.entity.Ticket;
import com.xuanwu.mos.common.entity.TicketInfo;
import com.xuanwu.mos.common.util.UUIDUtil;
import com.xuanwu.mos.common.util.XmlUtil;
import com.xuanwu.mos.common.util.ZipUtil;
import com.xuanwu.mos.msggate.protobuf.CommonItem;
import com.xuanwu.mos.msggate.protobuf.mo.MORequest;
import com.xuanwu.mos.msggate.protobuf.mo.MOResponse;
import com.xuanwu.mos.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MOSupport {
    private static boolean autoConfirm = true;

    public static void setAutoConfirm(boolean autoConfirm) {
        MOSupport.autoConfirm = autoConfirm;
    }

    public static byte[] getLoginBytes(Account account) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.LOGIN);
        CommonItem.Account.Builder acBuilder = CommonItem.Account.newBuilder();
        acBuilder.setName(account.getName());
        if (account.isSessionEncrypt()) {
            try {
                acBuilder.setPassword(account.getSessionCryptoTool().encrypt(account.getPassword()));
            }
            catch (Exception e) {
                throw new RuntimeException("Encrypt password error: " + e.getMessage());
            }
            acBuilder.setSessionEncrypt(true);
        } else {
            acBuilder.setPassword(account.getPassword());
        }
        builder.setUser(acBuilder.build());
        return builder.build().toByteArray();
    }

    public static MOLoginResponse getMOLoginResponse(byte[] srcBytes) throws InvalidProtocolBufferException {
        MOResponse.OResponse.Builder builder = MOResponse.OResponse.newBuilder();
        builder.mergeFrom(srcBytes);
        MOLoginResponse resp = new MOLoginResponse();
        resp.setType(builder.getType());
        resp.setResult(builder.getResult());
        resp.setMessage(builder.getMessage());
        resp.setAttributes(builder.getAttributes());
        resp.setInnerCostTime(builder.getInnerCostTime());
        return resp;
    }

    public static byte[] getAcInfoReq() {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.ACCOUNT_INFO);
        return builder.build().toByteArray();
    }

    public static byte[] getBizTypeReq() {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.BIZ_TYPE);
        return builder.build().toByteArray();
    }

    public static byte[] getModifyPwdReq(Account account, String newPwd) throws Exception {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.MODIFY_PWD);
        if (account.isSessionEncrypt()) {
            builder.setNewPwd(account.getSessionCryptoTool().encrypt(newPwd));
        } else {
            builder.setNewPwd(newPwd);
        }
        return builder.build().toByteArray();
    }

    public static byte[] getMOReq(int fetchSize) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.MO);
        builder.setPageSize(fetchSize);
        if (autoConfirm) {
            builder.setAttributes("<map><entry><string>needConfirm</string><string>1</string></entry></map>");
        } else {
            builder.setAttributes("<map><entry><string>needConfirmAsync</string><string>1</string></entry></map>");
        }
        return builder.build().toByteArray();
    }

    public static byte[] findTicketReq(String phone, Date startTime, Date endTime, String userName, int pageIndex) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.FIND_TICKET);
        if (phone != null) {
            builder.setPhone(phone);
        }
        builder.setPageIndex(pageIndex);
        HashMap<String, Object> map = new HashMap<String, Object>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (startTime != null) {
            map.put("START_TIME", sdf.format(startTime));
        }
        if (endTime != null) {
            map.put("END_TIME", sdf.format(endTime));
        }
        if (userName != null) {
            map.put("USER_NAME", userName);
        }
        builder.setAttributes(XmlUtil.toXML(map));
        return builder.build().toByteArray();
    }

    public static byte[] getFindRespReq(UUID batchID, String phone, int pageIndex, boolean isSimple) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.FIND_RESP);
        if (batchID != null) {
            builder.setBatchID(batchID.toString());
        }
        if (phone != null) {
            builder.setPhone(phone);
        }
        builder.setIsSimple(isSimple);
        builder.setPageIndex(pageIndex);
        return builder.build().toByteArray();
    }

    public static byte[] getRespReq(int limitDays, int fetchSize) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.RESP);
        builder.setDays(limitDays);
        builder.setPageSize(fetchSize);
        if (autoConfirm) {
            builder.setAttributes("<map><entry><string>needConfirm</string><string>1</string></entry></map>");
        } else {
            builder.setAttributes("<map><entry><string>needConfirmAsync</string><string>1</string></entry></map>");
        }
        return builder.build().toByteArray();
    }

    public static byte[] getFindReportReq(UUID batchID, String phone, int pageIndex, boolean isSimple) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.FIND_REPORT);
        if (batchID != null) {
            builder.setBatchID(batchID.toString());
        }
        if (phone != null) {
            builder.setPhone(phone);
        }
        builder.setIsSimple(isSimple);
        builder.setPageIndex(pageIndex);
        return builder.build().toByteArray();
    }

    public static byte[] getReportReq(int limitDays, int fetchSize) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.REPORT);
        builder.setDays(limitDays);
        builder.setPageSize(fetchSize);
        if (autoConfirm) {
            builder.setAttributes("<map><entry><string>needConfirm</string><string>1</string></entry></map>");
        } else {
            builder.setAttributes("<map><entry><string>needConfirmAsync</string><string>1</string></entry></map>");
        }
        return builder.build().toByteArray();
    }

    public static TicketInfo toTickets(MOResponse.OResponse.Builder builder) throws IOException {
        if (builder.getType() != CommonItem.OMsgType.FIND_TICKET) {
            return null;
        }
        CommonItem.TicketPack.Builder ticketPack = CommonItem.TicketPack.newBuilder();
        Map map = (Map)XmlUtil.fromXML(builder.getAttributes());
        ticketPack.mergeFrom(ZipUtil.unzipByteArray(builder.getData().toByteArray()));
        List<CommonItem.Ticket> items = ticketPack.getTicketsList();
        if (items == null || items.size() == 0) {
            return null;
        }
        TicketInfo ticketInfo = new TicketInfo();
        ticketInfo.setTotal(Integer.valueOf(String.valueOf(map.get("TOTAL"))));
        ticketInfo.setFlag(Boolean.valueOf(String.valueOf(map.get("ALL"))));
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        for (CommonItem.Ticket t : items) {
            Ticket ticket = new Ticket();
            ticket.setTicketId(t.getId());
            ticket.setPhone(t.getPhone());
            ticket.setContent(t.getContent());
            ticket.setTotal(t.getTotal());
            ticket.setNumber(t.getNumber());
            ticket.setSpecNumber(t.getSpecNumer());
            ticket.setSubmitRespTime(new Date(t.getSubmitRespTime()));
            ticket.setOriginResult(t.getOriginResult());
            tickets.add(ticket);
        }
        ticketInfo.setTickets(tickets);
        return ticketInfo;
    }

    public static MTResponse[] toResps(Account account, MOResponse.OResponse.Builder builder) throws Exception {
        if (builder.getType() != CommonItem.OMsgType.RESP && builder.getType() != CommonItem.OMsgType.FIND_RESP) {
            return null;
        }
        CommonItem.RespPack.Builder respPack = CommonItem.RespPack.newBuilder();
        byte[] srcData = builder.getData().toByteArray();
        if (account.isSessionEncrypt()) {
            srcData = MOSupport.decryptData(account, srcData);
        }
        respPack.mergeFrom(ZipUtil.unzipByteArray(srcData));
        List<CommonItem.RespItem> items = respPack.getItemsList();
        if (items == null || items.size() == 0) {
            return null;
        }
        ArrayList<MTResponse> resps = new ArrayList<MTResponse>();
        for (CommonItem.RespItem item : items) {
            MTResponse resp = new MTResponse();
            resp.setBatchID(UUIDUtil.tranBuilder2UUID(item.getBatchID()));
            resp.setCustomMsgID(item.getCustomMsgID());
            resp.setMsgID(item.getMsgID());
            resp.setNumber(item.getNumber());
            resp.setOriginResult(item.getOriginResult());
            resp.setPhone(item.getPhone());
            resp.setState(item.getState());
            resp.setSubmitRespTime(item.getSubmitRespTime());
            resp.setTotal(item.getTotal());
            resp.setReserve(item.getReserve());
            resp.setRespId(builder.getUuid());
            resps.add(resp);
        }
        return resps.toArray(new MTResponse[resps.size()]);
    }

    public static List<MTReport> toReports(Account account, MOResponse.OResponse.Builder builder) throws Exception {
        if (builder.getType() != CommonItem.OMsgType.REPORT && builder.getType() != CommonItem.OMsgType.FIND_REPORT) {
            return Collections.emptyList();
        }
        CommonItem.ReportPack.Builder reportPack = CommonItem.ReportPack.newBuilder();
        byte[] srcData = builder.getData().toByteArray();
        if (account.isSessionEncrypt()) {
            srcData = MOSupport.decryptData(account, srcData);
        }
        reportPack.mergeFrom(ZipUtil.unzipByteArray(srcData));
        List<CommonItem.StateItem> items = reportPack.getStateItemList();
        if (items == null || items.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<MTReport> reportList = new ArrayList<MTReport>();
        for (CommonItem.StateItem item : items) {
            MTReport report = new MTReport();
            report.setBatchID(UUIDUtil.tranBuilder2UUID(item.getBatchID()));
            report.setPhone(item.getDestPhone());
            report.setState(item.getState());
            report.setMsgID(item.getMsgID());
            report.setCustomMsgID(item.getCustomMsgID());
            report.setSubmitTime(item.getSubmitTime());
            report.setDoneTime(item.getDoneTime());
            report.setOriginResult(item.getOriginResult());
            report.setSepcNumber(item.getSpecNumber());
            report.setReserve(item.getReserve());
            report.setRespId(builder.getUuid());
            reportList.add(report);
        }
        return reportList;
    }

    public static List<MOMsg> toMos(Account account, MOResponse.OResponse.Builder builder) throws Exception {
        if (builder.getType() != CommonItem.OMsgType.MO) {
            return Collections.emptyList();
        }
        CommonItem.MOTicketPack.Builder moPack = CommonItem.MOTicketPack.newBuilder();
        byte[] srcData = builder.getData().toByteArray();
        if (account.isSessionEncrypt()) {
            srcData = MOSupport.decryptData(account, srcData);
        }
        moPack.mergeFrom(ZipUtil.unzipByteArray(srcData));
        List<CommonItem.MOTicket> items = moPack.getItemsList();
        if (items == null || items.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<MOMsg> moList = new ArrayList<MOMsg>();
        for (CommonItem.MOTicket item : items) {
            MOMsg mo = new MOMsg();
            mo.setPhone(item.getPhone());
            mo.setContent(item.getContent());
            mo.setMsgType(item.getType());
            mo.setSepcNumber(item.getSpecNumber());
            mo.setServiceType(item.getServiceType());
            mo.setRecevieTime(item.getPostTime());
            mo.setReserve(item.getReserve());
            mo.setCustomNum(item.getCustomNum());
            mo.setRespId(builder.getUuid());
            moList.add(mo);
        }
        return moList;
    }

    public static AccountInfo toAcInfo(Account account, byte[] srcBytes) throws Exception {
        MOResponse.OResponse.Builder builder = MOSupport.toRespBuilder(srcBytes);
        if (builder.getType() != CommonItem.OMsgType.ACCOUNT_INFO) {
            return null;
        }
        MOResponse.AccountInfo.Builder acInfoBuilder = MOResponse.AccountInfo.newBuilder();
        byte[] srcData = builder.getData().toByteArray();
        if (account.isSessionEncrypt()) {
            srcData = MOSupport.decryptData(account, srcData);
        }
        acInfoBuilder.mergeFrom(ZipUtil.unzipByteArray(srcData));
        AccountInfo acInfo = new AccountInfo();
        acInfo.setAccount(acInfoBuilder.getAccount());
        acInfo.setName(acInfoBuilder.getName());
        acInfo.setIdentify(acInfoBuilder.getIdentify());
        acInfo.setUserBrief(acInfoBuilder.getSignature());
        acInfo.setBizNames(acInfoBuilder.getBizNamesList().toArray(new String[0]));
        acInfo.setBalance((long)(acInfoBuilder.getBalance() * 100.0));
        return acInfo;
    }

    public static List<BusinessType> toBizType(Account account, byte[] srcBytes) throws Exception {
        MOResponse.OResponse.Builder builder = MOSupport.toRespBuilder(srcBytes);
        if (builder.getType() != CommonItem.OMsgType.BIZ_TYPE) {
            return Collections.emptyList();
        }
        MOResponse.BizTypePack.Builder bizPack = MOResponse.BizTypePack.newBuilder();
        byte[] srcData = builder.getData().toByteArray();
        if (account.isSessionEncrypt()) {
            srcData = MOSupport.decryptData(account, srcData);
        }
        bizPack.mergeFrom(ZipUtil.unzipByteArray(srcData));
        ArrayList<BusinessType> bizTypeList = new ArrayList<BusinessType>();
        List<MOResponse.BusinessType> items = bizPack.getItemsList();
        if (items == null || items.size() == 0) {
            return Collections.emptyList();
        }
        for (MOResponse.BusinessType biz : items) {
            BusinessType bizType = new BusinessType();
            bizType.setId(biz.getId());
            bizType.setName(biz.getName());
            bizType.setPriority(biz.getPriority());
            bizType.setStartTime(biz.getStartTime());
            bizType.setEndTime(biz.getEndTime());
            bizType.setExtendFlag(biz.getExtendFlag());
            bizType.setState(biz.getState());
            ArrayList<BindChannel> bindChs = new ArrayList<BindChannel>();
            for (MOResponse.BindChannel chBuilder : biz.getBindChsList()) {
                BindChannel bindCh = new BindChannel();
                bindCh.setCarrier(chBuilder.getCarrier());
                bindCh.setSpecNumber(chBuilder.getSpecNumber());
                bindCh.setSendType(chBuilder.getSendType());
                bindChs.add(bindCh);
            }
            bizType.setBindChs(bindChs);
            bizTypeList.add(bizType);
        }
        return bizTypeList;
    }

    public static int toModifyPwdResult(byte[] srcBytes) throws IOException {
        MOResponse.OResponse.Builder builder = MOSupport.toRespBuilder(srcBytes);
        if (builder.getType() != CommonItem.OMsgType.MODIFY_PWD) {
            return -100;
        }
        return builder.getResult().getNumber();
    }

    public static byte[] getConfirmBytes(MOResponse.OResponse.Builder resp) {
        MORequest.ORequest.Builder builder = MORequest.ORequest.newBuilder();
        builder.setType(resp.getType());
        builder.setUuid(resp.getUuid());
        builder.setAttributes("<map><entry><string>confirm</string><string>1</string></entry></map>");
        return builder.build().toByteArray();
    }

    public static byte[] getConfirmBytes(CommonItem.OMsgType msgType, String confirmId) {
        MORequest.ORequest.Builder builder = MORequest.ORequest.newBuilder();
        builder.setType(msgType);
        builder.setUuid(UUIDUtil.tranUUID2Builder(UUID.randomUUID()).build());
        builder.setAttributes("<map><entry><string>confirmAsync</string><string>" + confirmId + "</string></entry></map>");
        return builder.build().toByteArray();
    }

    private static MORequest.ORequest.Builder getReq(CommonItem.OMsgType type) {
        return MOSupport.getReq(type, UUID.randomUUID());
    }

    private static MORequest.ORequest.Builder getReq(CommonItem.OMsgType type, UUID uuid) {
        MORequest.ORequest.Builder builder = MORequest.ORequest.newBuilder();
        builder.setType(type);
        builder.setUuid(UUIDUtil.tranUUID2Builder(uuid));
        builder.setNodeSendId("C1_5.1");
        builder.setNodeSendTime(System.currentTimeMillis());
        return builder;
    }

    public static MOResponse.OResponse.Builder toRespBuilder(byte[] srcBytes) throws IOException {
        if (srcBytes == null) {
            throw new NullPointerException("srcBytes");
        }
        MOResponse.OResponse.Builder builder = MOResponse.OResponse.newBuilder();
        builder.mergeFrom(srcBytes);
        return builder;
    }

    private static byte[] decryptData(Account account, byte[] srcData) throws Exception {
        return account.getSessionCryptoTool().decrypt(srcData);
    }
}

