/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.common;

import com.xuanwu.mos.MessageData;
import com.xuanwu.mos.common.entity.Account;
import com.xuanwu.mos.common.entity.GsmsResponse;
import com.xuanwu.mos.common.entity.MTPack;
import com.xuanwu.mos.common.entity.MediaItem;
import com.xuanwu.mos.common.util.AesCryptoTool;
import com.xuanwu.mos.common.util.CommonUtil;
import com.xuanwu.mos.common.util.StringUtils;
import com.xuanwu.mos.common.util.UUIDUtil;
import com.xuanwu.mos.common.util.XmlUtil;
import com.xuanwu.mos.common.util.ZipUtil;
import com.xuanwu.mos.msggate.protobuf.CommonItem;
import com.xuanwu.mos.msggate.protobuf.mt.MTRequest;
import com.xuanwu.mos.msggate.protobuf.mt.MTResponse;
import com.xuanwu.mos.thirdparty.com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;

public class MTSupport {
    public static final String METHOD = "SDK_JAVA";
    public static final String VERSION = "5.1";
    public static final String FROM_CODE = "SDK_JAVA_5.1";
    public static final String ACCESS_METHOD = "ACCESS_METHOD";
    public static final String ACCESS_VERSION = "ACCESS_VERSION";
    public static final String ACCESS_EXT_MSG = "ACCESS_EXT_MSG";
    private static int maxPhoneSize = 20000;

    public static byte[] getLoginBytes(Account account) {
        MTRequest.TRequest.Builder builder = MTRequest.TRequest.newBuilder();
        builder.setUuid(UUIDUtil.tranUUID2Builder(UUID.randomUUID()));
        builder.setType(MTRequest.TRequestType.LOGIN);
        CommonItem.Account.Builder acc = CommonItem.Account.newBuilder();
        acc.setName(account.getName());
        if (account.isSessionEncrypt()) {
            try {
                acc.setPassword(account.getSessionCryptoTool().encrypt(account.getPassword()));
            }
            catch (Exception e) {
                throw new RuntimeException("Encrypt password error: " + e.getMessage());
            }
            acc.setSessionEncrypt(true);
        } else {
            acc.setPassword(account.getPassword());
        }
        builder.setUser(acc);
        builder.setNodeSendId("C1_5.1");
        builder.setNodeSendTime(System.currentTimeMillis());
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(ACCESS_METHOD, METHOD);
        attributes.put(ACCESS_VERSION, VERSION);
        if (CommonUtil.isNotBlank(account.getFrom())) {
            attributes.put(ACCESS_EXT_MSG, account.getFrom());
        }
        builder.setAttributes(XmlUtil.toXML(attributes));
        return builder.build().toByteArray();
    }

    public static byte[] getSendBytes(Account account, MTPack pack) throws Exception {
        MTRequest.TRequest.Builder builder = MTRequest.TRequest.newBuilder();
        builder.setType(MTRequest.TRequestType.MESSAGE_SENT);
        if (pack.getBatchID() == null) {
            pack.setBatchID(UUID.randomUUID());
        }
        builder.setUuid(UUIDUtil.tranUUID2Builder(pack.getBatchID()));
        if (pack.getCustomNum() != null) {
            builder.setCustomNum(pack.getCustomNum());
        }
        CommonItem.BizMeta.Builder biz = CommonItem.BizMeta.newBuilder();
        biz.setLevel(0);
        biz.setPriority(0);
        biz.setMsgType(pack.getMsgType().getIndex());
        biz.setSendType(pack.getSendType().ordinal());
        if (pack.getScheduleTime() > 0L) {
            biz.setScheduleTime(pack.getScheduleTime());
        }
        if (pack.getDeadline() > 0L) {
            biz.setDeadline(pack.getDeadline());
        }
        if (pack.getRemark() != null) {
            builder.setRemark(pack.getRemark());
        }
        biz.setBizType(pack.getBizType());
        builder.setInfo(biz);
        builder.setFrom(FROM_CODE);
        if (pack.getBatchName() != null) {
            builder.setBatchName(pack.getBatchName());
        }
        builder.setDistinctFlag(pack.isDistinctFlag());
        if (pack.getMedias() != null) {
            for (MediaItem mItem : pack.getMedias()) {
                CommonItem.MediaItem.Builder temp = CommonItem.MediaItem.newBuilder();
                temp.setMediaType(mItem.getMediaType());
                temp.setMeta(mItem.getMeta());
                temp.setData(ByteString.copyFrom(mItem.getData()));
                builder.addMmsAttachment(temp);
            }
        }
        switch (pack.getSendType()) {
            case MASS: {
                AesCryptoTool sessionCryptoTool;
                CommonItem.MassPack.Builder massmsg = CommonItem.MassPack.newBuilder();
                MessageData msg0 = pack.getMsgs().get(0);
                CommonItem.MsgContent.Builder contentMass = CommonItem.MsgContent.newBuilder();
                contentMass.setContent(msg0.getContent());
                massmsg.setContent(contentMass);
                for (MessageData msg : pack.getMsgs()) {
                    CommonItem.MsgItem.Builder item = CommonItem.MsgItem.newBuilder();
                    item.setPhone(msg.getPhone());
                    if (msg.getCustomMsgID() != null) {
                        item.setCustomMsgID(msg.getCustomMsgID());
                    }
                    if (msg.getCustomNum() != null) {
                        item.setCustomNum(msg.getCustomNum());
                    }
                    item.setVipFlag(msg.isVipFlag());
                    massmsg.addItems(item);
                }
                byte[] zipMassMsgBytes = ZipUtil.zipByteArray(massmsg.build().toByteArray());
                if (account.isSessionEncrypt() && (sessionCryptoTool = account.getSessionCryptoTool()) != null) {
                    zipMassMsgBytes = sessionCryptoTool.encrypt(zipMassMsgBytes);
                }
                builder.setMassMsg(ByteString.copyFrom(zipMassMsgBytes));
                break;
            }
            case GROUP: {
                AesCryptoTool sessionCryptoTool;
                CommonItem.GroupPack.Builder groupmsg = CommonItem.GroupPack.newBuilder();
                for (MessageData msg : pack.getMsgs()) {
                    CommonItem.MsgItem.Builder item = CommonItem.MsgItem.newBuilder();
                    CommonItem.MsgContent.Builder contentGroup = CommonItem.MsgContent.newBuilder();
                    item.setPhone(msg.getPhone());
                    contentGroup.setContent(msg.getContent());
                    if (msg.getMedias() != null) {
                        for (MediaItem mItem : msg.getMedias()) {
                            CommonItem.MediaItem.Builder temp = CommonItem.MediaItem.newBuilder();
                            temp.setMediaType(mItem.getMediaType());
                            temp.setMeta(mItem.getMeta());
                            temp.setData(ByteString.copyFrom(mItem.getData()));
                            contentGroup.addMedias(temp);
                        }
                    }
                    if (msg.getCustomMsgID() != null) {
                        item.setCustomMsgID(msg.getCustomMsgID());
                    }
                    if (msg.getCustomNum() != null) {
                        item.setCustomNum(msg.getCustomNum());
                    }
                    item.setVipFlag(msg.isVipFlag());
                    item.setContent(contentGroup);
                    groupmsg.addItems(item);
                }
                byte[] zipGroupMsgBytes = ZipUtil.zipByteArray(groupmsg.build().toByteArray());
                if (account.isSessionEncrypt() && (sessionCryptoTool = account.getSessionCryptoTool()) != null) {
                    zipGroupMsgBytes = sessionCryptoTool.encrypt(zipGroupMsgBytes);
                }
                builder.setGroupMsg(ByteString.copyFrom(zipGroupMsgBytes));
                break;
            }
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>(3);
        attributes.put(ACCESS_METHOD, METHOD);
        attributes.put(ACCESS_VERSION, VERSION);
        String templateNo = pack.getTemplateNo();
        if (StringUtils.isNotBlank(templateNo)) {
            attributes.put("TEMPLATE_NO", templateNo.trim());
        }
        builder.setAttributes(XmlUtil.toXML(attributes));
        builder.setNodeSendId("C1_5.1");
        builder.setNodeSendTime(System.currentTimeMillis());
        return builder.build().toByteArray();
    }

    public static boolean isLoginSuc(byte[] srcBytes) throws IOException {
        GsmsResponse resp = MTSupport.getResponse(srcBytes);
        return resp.getResult() == 0;
    }

    public static GsmsResponse getResponse(byte[] srcBytes) throws IOException {
        MTResponse.TResponse.Builder builder = MTResponse.TResponse.newBuilder();
        builder.mergeFrom(srcBytes);
        GsmsResponse resp = new GsmsResponse();
        resp.setMessage(builder.getMessage());
        resp.setResult(builder.getResult().getNumber());
        resp.setUuid(UUIDUtil.tranBuilder2UUID(builder.getUuid()));
        resp.setAttributes(builder.getAttributes());
        resp.setInnerCostTime(builder.getInnerCostTime());
        return resp;
    }

    public static void verifyPack(MTPack pack) {
        if (pack == null) {
            throw new NullPointerException("pack");
        }
        if (pack.getMsgs() == null || pack.getMsgs().size() < 1) {
            throw new IllegalArgumentException("msgs is empty");
        }
        if (pack.getMsgs().size() > maxPhoneSize) {
            throw new IllegalArgumentException("phone size must be less than(or equal) " + maxPhoneSize);
        }
        if (pack.getSendType() == null) {
            throw new NullPointerException("sendType");
        }
        if (pack.getMsgType() == null) {
            throw new NullPointerException("msgType");
        }
    }

    public static void setMaxPhoneSize(int maxPhoneSize) {
        MTSupport.maxPhoneSize = maxPhoneSize;
    }
}

