/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.common.entity;

import com.xuanwu.mos.common.util.AesCryptoTool;
import com.xuanwu.mos.common.util.CommonUtil;
import com.xuanwu.mos.common.util.DigestUtils;
import com.xuanwu.mos.common.util.StringUtils;
import java.util.Arrays;

public class Account {
    private String name;
    private String password;
    private String sessionKey;
    private byte[] sessionKeyInBytes;
    private boolean sessionEncrypt = false;
    private String from;
    private String monitorToken;

    public Account(String name, String password) {
        this.setName(name);
        this.setPassword(password);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (CommonUtil.isBlank(name)) {
            throw new IllegalArgumentException("name is blank");
        }
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    public void setPassword(String password) {
        if (password == null) {
            throw new NullPointerException("password");
        }
        this.password = DigestUtils.md5Hex(password);
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        if (StringUtils.isNotBlank(sessionKey)) {
            this.sessionEncrypt = true;
            byte[] sessionKeyBytes = sessionKey.getBytes();
            if (sessionKeyBytes.length != 16) {
                byte[] temp = new byte[16];
                Arrays.fill(temp, (byte)48);
                int length = Math.min(temp.length, sessionKeyBytes.length);
                System.arraycopy(sessionKeyBytes, 0, temp, 0, length);
                sessionKeyBytes = temp;
            }
            this.sessionKeyInBytes = sessionKeyBytes;
        } else {
            this.sessionEncrypt = false;
        }
        this.sessionKey = sessionKey;
    }

    public AesCryptoTool getSessionCryptoTool() {
        if (this.sessionKeyInBytes == null) {
            return null;
        }
        return new AesCryptoTool(this.sessionKeyInBytes);
    }

    public boolean isSessionEncrypt() {
        return this.sessionEncrypt;
    }

    public String getMonitorToken() {
        return this.monitorToken;
    }

    public void setMonitorToken(String monitorToken) {
        this.monitorToken = monitorToken;
    }

    public String toString() {
        return this.name + ":" + this.password;
    }
}

