/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.common.log;

import com.xuanwu.mos.common.log.LogWrapper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class PostMsgLogger {
    private static volatile boolean enableLogger = false;
    private static volatile boolean enableBizLogger = false;
    private static final String SEPARATOR = "@_@";

    public static void setEnableLogger(boolean enable) {
        enableLogger = enable;
    }

    public static boolean isEnableLogger() {
        return enableLogger;
    }

    public static void setEnableBizLogger(boolean enableBizLogger) {
        PostMsgLogger.enableBizLogger = enableBizLogger;
    }

    public static void logInfo(String message) {
        if (!enableLogger) {
            return;
        }
        LogWrapper.logInfo(message);
    }

    public static void logWarn(String message) {
        if (!enableLogger) {
            return;
        }
        LogWrapper.logWarn(message);
    }

    public static void logWarn(String method, String message) {
        if (!enableLogger) {
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        StringBuilder sb = new StringBuilder();
        sb.append(df.format(new Date())).append(SEPARATOR).append(method).append(SEPARATOR).append(message);
        LogWrapper.logWarn(sb.toString());
    }

    public static void logError(String message) {
        if (!enableLogger) {
            return;
        }
        LogWrapper.logError(message);
    }

    public static void logCommError(String method, String message) {
        if (!enableLogger) {
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        StringBuilder sb = new StringBuilder();
        sb.append(df.format(new Date())).append(SEPARATOR).append(method).append(SEPARATOR).append(message);
        LogWrapper.logCommError(sb.toString());
    }

    public static void logCommWarn(String method, String message) {
        if (!enableLogger) {
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        StringBuilder sb = new StringBuilder();
        sb.append(df.format(new Date())).append(SEPARATOR).append(method).append(SEPARATOR).append(message);
        LogWrapper.logCommWarn(sb.toString());
    }

    public static void logBizWarn(String message) {
        if (!enableBizLogger) {
            return;
        }
        LogWrapper.logBizWarn(message);
    }

    public static void logBizWarn(String method, String message) {
        if (!enableBizLogger) {
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        StringBuilder sb = new StringBuilder();
        sb.append(df.format(new Date())).append(SEPARATOR).append(method).append(SEPARATOR).append(message);
        LogWrapper.logBizWarn(sb.toString());
    }

    public static void logBizError(String message) {
        if (!enableBizLogger) {
            return;
        }
        LogWrapper.logBizError(message);
    }

    public static void logBizError(String method, String message) {
        if (!enableBizLogger) {
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        StringBuilder sb = new StringBuilder();
        sb.append(df.format(new Date())).append(SEPARATOR).append(method).append(SEPARATOR).append(message);
        LogWrapper.logBizError(sb.toString());
    }
}

