/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.common.pool;

import com.xuanwu.mos.HostInfo;
import com.xuanwu.mos.common.ConnectionSupport;
import com.xuanwu.mos.common.pool.SocketObject;
import com.xuanwu.mos.thirdparty.org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import java.util.concurrent.TimeUnit;

public class SocketObjectFactory
extends BaseKeyedPoolableObjectFactory {
    public static final long MAX_IDLE_TIME = TimeUnit.SECONDS.toMillis(50L);
    private HostInfo proxyHost;
    private HostInfo host;
    private boolean shortConnMode = false;
    private int soTimeout = 30000;

    public Object makeObject(Object key) throws Exception {
        return ConnectionSupport.getValidSockObj(this.proxyHost, this.host, this.soTimeout);
    }

    public boolean validateObject(Object key, Object obj) {
        SocketObject sockObj = (SocketObject)obj;
        long lastUsedTime = sockObj.getLastUsedTime();
        long curTime = System.currentTimeMillis();
        sockObj.setLastUsedTime(curTime);
        if (curTime - lastUsedTime < MAX_IDLE_TIME) {
            return sockObj.isValid();
        }
        return false;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        SocketObject sockObj = (SocketObject)obj;
        sockObj.destory();
    }

    public void passivateObject(Object key, Object obj) throws Exception {
        if (this.shortConnMode) {
            this.destroyObject(key, obj);
        }
    }

    public HostInfo getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(HostInfo proxyHost) {
        this.proxyHost = proxyHost;
    }

    public HostInfo getHost() {
        return this.host;
    }

    public void setHost(HostInfo host) {
        this.host = host;
    }

    public void setShortConnMode(boolean shortConnMode) {
        this.shortConnMode = shortConnMode;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }
}

