/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.common.util;

import java.util.UUID;

public class CommonUtil {
    private static String numericRegx = "\\d+";

    public static boolean isNotBlank(String src) {
        return !CommonUtil.isBlank(src);
    }

    public static UUID getUUID(String uuidStr) {
        try {
            return CommonUtil.isNotBlank(uuidStr) ? UUID.fromString(uuidStr) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isValidArray(Object[] arr) {
        return arr != null && arr.length >= 1;
    }

    public static boolean isIP(String ip) {
        String[] segs;
        if (CommonUtil.isNotBlank(ip) && (segs = ip.split("\\.")).length == 4) {
            try {
                for (String seg : segs) {
                    int temp = Integer.parseInt(seg);
                    if (temp >= 0 && temp <= 255) continue;
                    return false;
                }
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean verifyStr(String src, boolean notBlank, boolean limitLenFlag, int limitLen, boolean numeric) {
        int len;
        if (CommonUtil.isBlank(src)) {
            return !notBlank;
        }
        if (limitLenFlag && (len = src.codePointCount(0, src.length())) > limitLen) {
            return false;
        }
        if (numeric) {
            return src.matches(numericRegx);
        }
        return true;
    }
}

